@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.kotlin.outputs.ManagedKubernetesAddon
import com.pulumi.alicloud.cs.kotlin.outputs.ManagedKubernetesCertificateAuthority
import com.pulumi.alicloud.cs.kotlin.outputs.ManagedKubernetesConnections
import com.pulumi.alicloud.cs.kotlin.outputs.ManagedKubernetesDeleteOption
import com.pulumi.alicloud.cs.kotlin.outputs.ManagedKubernetesMaintenanceWindow
import com.pulumi.alicloud.cs.kotlin.outputs.ManagedKubernetesRrsaMetadata
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.cs.kotlin.outputs.ManagedKubernetesAddon.Companion.toKotlin as managedKubernetesAddonToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.ManagedKubernetesCertificateAuthority.Companion.toKotlin as managedKubernetesCertificateAuthorityToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.ManagedKubernetesConnections.Companion.toKotlin as managedKubernetesConnectionsToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.ManagedKubernetesDeleteOption.Companion.toKotlin as managedKubernetesDeleteOptionToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.ManagedKubernetesMaintenanceWindow.Companion.toKotlin as managedKubernetesMaintenanceWindowToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.ManagedKubernetesRrsaMetadata.Companion.toKotlin as managedKubernetesRrsaMetadataToKotlin

/**
 * Builder for [ManagedKubernetes].
 */
@PulumiTagMarker
public class ManagedKubernetesResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedKubernetesArgs = ManagedKubernetesArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedKubernetesArgsBuilder.() -> Unit) {
        val builder = ManagedKubernetesArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagedKubernetes {
        val builtJavaResource = com.pulumi.alicloud.cs.ManagedKubernetes(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ManagedKubernetes(builtJavaResource)
    }
}

/**
 * This resource will help you to manage a ManagedKubernetes Cluster in Alibaba Cloud Kubernetes Service.
 * > **NOTE:** Available since v1.26.0.
 * > **NOTE:** It is recommended to create a cluster with zero worker nodes, and then use a node pool to manage the cluster nodes.
 * > **NOTE:** Kubernetes cluster only supports VPC network and it can access internet while creating kubernetes cluster.
 * A Nat Gateway and configuring a SNAT for it can ensure one VPC network access internet. If there is no nat gateway in the
 * VPC, you can set `new_nat_gateway` to "true" to create one automatically.
 * > **NOTE:** Creating kubernetes cluster need to install several packages and it will cost about 15 minutes. Please be patient.
 * > **NOTE:** From version 1.9.4, the provider supports to download kube config, client certificate, client key and cluster ca certificate
 * after creating cluster successfully, and you can put them into the specified location, like '~/.kube/config'.
 * > **NOTE:** From version 1.20.0, the provider supports disabling internet load balancer for API Server by setting `false` to `slb_internet_enabled`.
 * > **NOTE:** If you want to manage Kubernetes, you can use Kubernetes Provider.
 * > **NOTE:** You need to activate several other products and confirm Authorization Policy used by Container Service before using this resource.
 * Please refer to the `Authorization management` and `Cluster management` sections in the [Document Center](https://www.alibabacloud.com/help/doc-detail/86488.htm).
 * > **NOTE:** From version 1.72.0, Some parameters have been removed from resource,You can check them below and re-import the cluster if necessary.
 * > **NOTE:** From version 1.120.0, Support for cluster migration from Standard cluster to professional.
 * > **NOTE:** From version 1.177.0+, `runtime`,`enable_ssh`,`rds_instances`,`exclude_autoscaler_nodes`,`worker_number`,`worker_instance_types`,`password`,`key_name`,`kms_encrypted_password`,`kms_encryption_context`,`worker_instance_charge_type`,`worker_period`,`worker_period_unit`,`worker_auto_renew`,`worker_auto_renew_period`,`worker_disk_category`,`worker_disk_size`,`worker_data_disks`,`node_name_mode`,`node_port_range`,`os_type`,`platform`,`image_id`,`cpu_policy`,`user_data`,`taints`,`worker_disk_performance_level`,`worker_disk_snapshot_policy_id`,`install_cloud_monitor` are deprecated.
 * We Suggest you using resource **`alicloud.cs.NodePool`** to manage your cluster worker nodes.
 * > **NOTE:** From version 1.212.0, `runtime`,`enable_ssh`,`rds_instances`,`exclude_autoscaler_nodes`,`worker_number`,`worker_instance_types`,`password`,`key_name`,`kms_encrypted_password`,`kms_encryption_context`,`worker_instance_charge_type`,`worker_period`,`worker_period_unit`,`worker_auto_renew`,`worker_auto_renew_period`,`worker_disk_category`,`worker_disk_size`,`worker_data_disks`,`node_name_mode`,`node_port_range`,`os_type`,`platform`,`image_id`,`cpu_policy`,`user_data`,`taints`,`worker_disk_performance_level`,`worker_disk_snapshot_policy_id`,`install_cloud_monitor`,`kube_config`,`availability_zone` are removed.
 * Please use resource **`alicloud.cs.NodePool`** to manage your cluster worker nodes.
 * ## Import
 * Kubernetes managed cluster can be imported using the id, e.g. Then complete the main.tf accords to the result of `pulumi preview`.
 * ```sh
 * $ pulumi import alicloud:cs/managedKubernetes:ManagedKubernetes main cluster_id
 * ```
 */
public class ManagedKubernetes internal constructor(
    override val javaResource: com.pulumi.alicloud.cs.ManagedKubernetes,
) : KotlinCustomResource(javaResource, ManagedKubernetesMapper) {
    public val addons: Output<List<ManagedKubernetesAddon>>?
        get() = javaResource.addons().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> managedKubernetesAddonToKotlin(args0) })
                })
            }).orElse(null)
        })

    public val apiAudiences: Output<List<String>>?
        get() = javaResource.apiAudiences().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * (Available in 1.105.0+) Nested attribute containing certificate authority data for your cluster.
     */
    public val certificateAuthority: Output<ManagedKubernetesCertificateAuthority>
        get() = javaResource.certificateAuthority().applyValue({ args0 ->
            args0.let({ args0 ->
                managedKubernetesCertificateAuthorityToKotlin(args0)
            })
        })

    /**
     * The base64 encoded client certificate data required to communicate with your cluster. Add this to the client-certificate-data section of the kubeconfig file for your cluster.
     */
    public val clientCert: Output<String>?
        get() = javaResource.clientCert().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The base64 encoded client key data required to communicate with your cluster. Add this to the client-key-data section of the kubeconfig file for your cluster.
     */
    public val clientKey: Output<String>?
        get() = javaResource.clientKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val clusterCaCert: Output<String>?
        get() = javaResource.clusterCaCert().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * cluster local domain
     */
    public val clusterDomain: Output<String>?
        get() = javaResource.clusterDomain().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val clusterSpec: Output<String>
        get() = javaResource.clusterSpec().applyValue({ args0 -> args0 })

    /**
     * Map of kubernetes cluster connection information.
     */
    public val connections: Output<ManagedKubernetesConnections>
        get() = javaResource.connections().applyValue({ args0 ->
            args0.let({ args0 ->
                managedKubernetesConnectionsToKotlin(args0)
            })
        })

    public val controlPlaneLogComponents: Output<List<String>>?
        get() = javaResource.controlPlaneLogComponents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    public val controlPlaneLogProject: Output<String>
        get() = javaResource.controlPlaneLogProject().applyValue({ args0 -> args0 })

    public val controlPlaneLogTtl: Output<String>
        get() = javaResource.controlPlaneLogTtl().applyValue({ args0 -> args0 })

    public val customSan: Output<String>?
        get() = javaResource.customSan().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val deleteOptions: Output<List<ManagedKubernetesDeleteOption>>?
        get() = javaResource.deleteOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        managedKubernetesDeleteOptionToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    public val deletionProtection: Output<Boolean>?
        get() = javaResource.deletionProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val enableRrsa: Output<Boolean>?
        get() = javaResource.enableRrsa().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * disk encryption key, only in ack-pro
     */
    public val encryptionProviderKey: Output<String>?
        get() = javaResource.encryptionProviderKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val isEnterpriseSecurityGroup: Output<Boolean>
        get() = javaResource.isEnterpriseSecurityGroup().applyValue({ args0 -> args0 })

    public val loadBalancerSpec: Output<String>?
        get() = javaResource.loadBalancerSpec().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val maintenanceWindow: Output<ManagedKubernetesMaintenanceWindow>
        get() = javaResource.maintenanceWindow().applyValue({ args0 ->
            args0.let({ args0 ->
                managedKubernetesMaintenanceWindowToKotlin(args0)
            })
        })

    /**
     * Node name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val namePrefix: Output<String>?
        get() = javaResource.namePrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of nat gateway used to launch kubernetes cluster.
     */
    public val natGatewayId: Output<String>
        get() = javaResource.natGatewayId().applyValue({ args0 -> args0 })

    public val newNatGateway: Output<Boolean>?
        get() = javaResource.newNatGateway().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val nodeCidrMask: Output<Int>?
        get() = javaResource.nodeCidrMask().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val podCidr: Output<String>?
        get() = javaResource.podCidr().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val podVswitchIds: Output<List<String>>?
        get() = javaResource.podVswitchIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    public val proxyMode: Output<String>?
        get() = javaResource.proxyMode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    public val retainResources: Output<List<String>>?
        get() = javaResource.retainResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * (Optional, Available in v1.185.0+) Nested attribute containing RRSA related data for your cluster.
     */
    public val rrsaMetadata: Output<ManagedKubernetesRrsaMetadata>
        get() = javaResource.rrsaMetadata().applyValue({ args0 ->
            args0.let({ args0 ->
                managedKubernetesRrsaMetadataToKotlin(args0)
            })
        })

    public val securityGroupId: Output<String>
        get() = javaResource.securityGroupId().applyValue({ args0 -> args0 })

    public val serviceAccountIssuer: Output<String>?
        get() = javaResource.serviceAccountIssuer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val serviceCidr: Output<String>?
        get() = javaResource.serviceCidr().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of APIServer load balancer.
     */
    public val slbId: Output<String>
        get() = javaResource.slbId().applyValue({ args0 -> args0 })

    /**
     * The public ip of load balancer.
     */
    public val slbInternet: Output<String>
        get() = javaResource.slbInternet().applyValue({ args0 -> args0 })

    public val slbInternetEnabled: Output<Boolean>?
        get() = javaResource.slbInternetEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of private load balancer where the current cluster master node is located.
     */
    public val slbIntranet: Output<String>
        get() = javaResource.slbIntranet().applyValue({ args0 -> args0 })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    public val timezone: Output<String>?
        get() = javaResource.timezone().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val userCa: Output<String>?
        get() = javaResource.userCa().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })

    /**
     * The ID of VPC where the current cluster is located.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The RamRole Name attached to worker node.
     */
    public val workerRamRoleName: Output<String>
        get() = javaResource.workerRamRoleName().applyValue({ args0 -> args0 })

    public val workerVswitchIds: Output<List<String>>
        get() = javaResource.workerVswitchIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object ManagedKubernetesMapper : ResourceMapper<ManagedKubernetes> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cs.ManagedKubernetes::class == javaResource::class

    override fun map(javaResource: Resource): ManagedKubernetes = ManagedKubernetes(
        javaResource as
            com.pulumi.alicloud.cs.ManagedKubernetes,
    )
}

/**
 * @see [ManagedKubernetes].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedKubernetes].
 */
public suspend fun managedKubernetes(
    name: String,
    block: suspend ManagedKubernetesResourceBuilder.() -> Unit,
): ManagedKubernetes {
    val builder = ManagedKubernetesResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedKubernetes].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedKubernetes(name: String): ManagedKubernetes {
    val builder = ManagedKubernetesResourceBuilder()
    builder.name(name)
    return builder.build()
}
