@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.ManagedKubernetesArgs.builder
import com.pulumi.alicloud.cs.kotlin.inputs.ManagedKubernetesAddonArgs
import com.pulumi.alicloud.cs.kotlin.inputs.ManagedKubernetesAddonArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.ManagedKubernetesDeleteOptionArgs
import com.pulumi.alicloud.cs.kotlin.inputs.ManagedKubernetesDeleteOptionArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.ManagedKubernetesMaintenanceWindowArgs
import com.pulumi.alicloud.cs.kotlin.inputs.ManagedKubernetesMaintenanceWindowArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * This resource will help you to manage a ManagedKubernetes Cluster in Alibaba Cloud Kubernetes Service.
 * > **NOTE:** Available since v1.26.0.
 * > **NOTE:** It is recommended to create a cluster with zero worker nodes, and then use a node pool to manage the cluster nodes.
 * > **NOTE:** Kubernetes cluster only supports VPC network and it can access internet while creating kubernetes cluster.
 * A Nat Gateway and configuring a SNAT for it can ensure one VPC network access internet. If there is no nat gateway in the
 * VPC, you can set `new_nat_gateway` to "true" to create one automatically.
 * > **NOTE:** Creating kubernetes cluster need to install several packages and it will cost about 15 minutes. Please be patient.
 * > **NOTE:** From version 1.9.4, the provider supports to download kube config, client certificate, client key and cluster ca certificate
 * after creating cluster successfully, and you can put them into the specified location, like '~/.kube/config'.
 * > **NOTE:** From version 1.20.0, the provider supports disabling internet load balancer for API Server by setting `false` to `slb_internet_enabled`.
 * > **NOTE:** If you want to manage Kubernetes, you can use Kubernetes Provider.
 * > **NOTE:** You need to activate several other products and confirm Authorization Policy used by Container Service before using this resource.
 * Please refer to the `Authorization management` and `Cluster management` sections in the [Document Center](https://www.alibabacloud.com/help/doc-detail/86488.htm).
 * > **NOTE:** From version 1.72.0, Some parameters have been removed from resource,You can check them below and re-import the cluster if necessary.
 * > **NOTE:** From version 1.120.0, Support for cluster migration from Standard cluster to professional.
 * > **NOTE:** From version 1.177.0+, `runtime`,`enable_ssh`,`rds_instances`,`exclude_autoscaler_nodes`,`worker_number`,`worker_instance_types`,`password`,`key_name`,`kms_encrypted_password`,`kms_encryption_context`,`worker_instance_charge_type`,`worker_period`,`worker_period_unit`,`worker_auto_renew`,`worker_auto_renew_period`,`worker_disk_category`,`worker_disk_size`,`worker_data_disks`,`node_name_mode`,`node_port_range`,`os_type`,`platform`,`image_id`,`cpu_policy`,`user_data`,`taints`,`worker_disk_performance_level`,`worker_disk_snapshot_policy_id`,`install_cloud_monitor` are deprecated.
 * We Suggest you using resource **`alicloud.cs.NodePool`** to manage your cluster worker nodes.
 * > **NOTE:** From version 1.212.0, `runtime`,`enable_ssh`,`rds_instances`,`exclude_autoscaler_nodes`,`worker_number`,`worker_instance_types`,`password`,`key_name`,`kms_encrypted_password`,`kms_encryption_context`,`worker_instance_charge_type`,`worker_period`,`worker_period_unit`,`worker_auto_renew`,`worker_auto_renew_period`,`worker_disk_category`,`worker_disk_size`,`worker_data_disks`,`node_name_mode`,`node_port_range`,`os_type`,`platform`,`image_id`,`cpu_policy`,`user_data`,`taints`,`worker_disk_performance_level`,`worker_disk_snapshot_policy_id`,`install_cloud_monitor`,`kube_config`,`availability_zone` are removed.
 * Please use resource **`alicloud.cs.NodePool`** to manage your cluster worker nodes.
 * ## Import
 * Kubernetes managed cluster can be imported using the id, e.g. Then complete the main.tf accords to the result of `pulumi preview`.
 * ```sh
 * $ pulumi import alicloud:cs/managedKubernetes:ManagedKubernetes main cluster_id
 * ```
 * @property addons
 * @property apiAudiences
 * @property clientCert The base64 encoded client certificate data required to communicate with your cluster. Add this to the client-certificate-data section of the kubeconfig file for your cluster.
 * @property clientKey The base64 encoded client key data required to communicate with your cluster. Add this to the client-key-data section of the kubeconfig file for your cluster.
 * @property clusterCaCert
 * @property clusterDomain cluster local domain
 * @property clusterSpec
 * @property controlPlaneLogComponents
 * @property controlPlaneLogProject
 * @property controlPlaneLogTtl
 * @property customSan
 * @property deleteOptions
 * @property deletionProtection
 * @property enableRrsa
 * @property encryptionProviderKey disk encryption key, only in ack-pro
 * @property isEnterpriseSecurityGroup
 * @property loadBalancerSpec
 * @property maintenanceWindow
 * @property name Node name.
 * @property namePrefix
 * @property newNatGateway
 * @property nodeCidrMask
 * @property podCidr
 * @property podVswitchIds
 * @property proxyMode
 * @property resourceGroupId
 * @property retainResources
 * @property securityGroupId
 * @property serviceAccountIssuer
 * @property serviceCidr
 * @property slbInternetEnabled
 * @property tags
 * @property timezone
 * @property userCa
 * @property version
 * @property workerVswitchIds
 */
public data class ManagedKubernetesArgs(
    public val addons: Output<List<ManagedKubernetesAddonArgs>>? = null,
    public val apiAudiences: Output<List<String>>? = null,
    public val clientCert: Output<String>? = null,
    public val clientKey: Output<String>? = null,
    public val clusterCaCert: Output<String>? = null,
    public val clusterDomain: Output<String>? = null,
    public val clusterSpec: Output<String>? = null,
    public val controlPlaneLogComponents: Output<List<String>>? = null,
    public val controlPlaneLogProject: Output<String>? = null,
    public val controlPlaneLogTtl: Output<String>? = null,
    public val customSan: Output<String>? = null,
    public val deleteOptions: Output<List<ManagedKubernetesDeleteOptionArgs>>? = null,
    public val deletionProtection: Output<Boolean>? = null,
    public val enableRrsa: Output<Boolean>? = null,
    public val encryptionProviderKey: Output<String>? = null,
    public val isEnterpriseSecurityGroup: Output<Boolean>? = null,
    public val loadBalancerSpec: Output<String>? = null,
    public val maintenanceWindow: Output<ManagedKubernetesMaintenanceWindowArgs>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val newNatGateway: Output<Boolean>? = null,
    public val nodeCidrMask: Output<Int>? = null,
    public val podCidr: Output<String>? = null,
    public val podVswitchIds: Output<List<String>>? = null,
    public val proxyMode: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val retainResources: Output<List<String>>? = null,
    public val securityGroupId: Output<String>? = null,
    public val serviceAccountIssuer: Output<String>? = null,
    public val serviceCidr: Output<String>? = null,
    public val slbInternetEnabled: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timezone: Output<String>? = null,
    public val userCa: Output<String>? = null,
    public val version: Output<String>? = null,
    public val workerVswitchIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.ManagedKubernetesArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.ManagedKubernetesArgs =
        com.pulumi.alicloud.cs.ManagedKubernetesArgs.builder()
            .addons(addons?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .apiAudiences(apiAudiences?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .clientCert(clientCert?.applyValue({ args0 -> args0 }))
            .clientKey(clientKey?.applyValue({ args0 -> args0 }))
            .clusterCaCert(clusterCaCert?.applyValue({ args0 -> args0 }))
            .clusterDomain(clusterDomain?.applyValue({ args0 -> args0 }))
            .clusterSpec(clusterSpec?.applyValue({ args0 -> args0 }))
            .controlPlaneLogComponents(
                controlPlaneLogComponents?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .controlPlaneLogProject(controlPlaneLogProject?.applyValue({ args0 -> args0 }))
            .controlPlaneLogTtl(controlPlaneLogTtl?.applyValue({ args0 -> args0 }))
            .customSan(customSan?.applyValue({ args0 -> args0 }))
            .deleteOptions(
                deleteOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
            .enableRrsa(enableRrsa?.applyValue({ args0 -> args0 }))
            .encryptionProviderKey(encryptionProviderKey?.applyValue({ args0 -> args0 }))
            .isEnterpriseSecurityGroup(isEnterpriseSecurityGroup?.applyValue({ args0 -> args0 }))
            .loadBalancerSpec(loadBalancerSpec?.applyValue({ args0 -> args0 }))
            .maintenanceWindow(maintenanceWindow?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .newNatGateway(newNatGateway?.applyValue({ args0 -> args0 }))
            .nodeCidrMask(nodeCidrMask?.applyValue({ args0 -> args0 }))
            .podCidr(podCidr?.applyValue({ args0 -> args0 }))
            .podVswitchIds(podVswitchIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .proxyMode(proxyMode?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .retainResources(retainResources?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .serviceAccountIssuer(serviceAccountIssuer?.applyValue({ args0 -> args0 }))
            .serviceCidr(serviceCidr?.applyValue({ args0 -> args0 }))
            .slbInternetEnabled(slbInternetEnabled?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timezone(timezone?.applyValue({ args0 -> args0 }))
            .userCa(userCa?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 }))
            .workerVswitchIds(workerVswitchIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ManagedKubernetesArgs].
 */
@PulumiTagMarker
public class ManagedKubernetesArgsBuilder internal constructor() {
    private var addons: Output<List<ManagedKubernetesAddonArgs>>? = null

    private var apiAudiences: Output<List<String>>? = null

    private var clientCert: Output<String>? = null

    private var clientKey: Output<String>? = null

    private var clusterCaCert: Output<String>? = null

    private var clusterDomain: Output<String>? = null

    private var clusterSpec: Output<String>? = null

    private var controlPlaneLogComponents: Output<List<String>>? = null

    private var controlPlaneLogProject: Output<String>? = null

    private var controlPlaneLogTtl: Output<String>? = null

    private var customSan: Output<String>? = null

    private var deleteOptions: Output<List<ManagedKubernetesDeleteOptionArgs>>? = null

    private var deletionProtection: Output<Boolean>? = null

    private var enableRrsa: Output<Boolean>? = null

    private var encryptionProviderKey: Output<String>? = null

    private var isEnterpriseSecurityGroup: Output<Boolean>? = null

    private var loadBalancerSpec: Output<String>? = null

    private var maintenanceWindow: Output<ManagedKubernetesMaintenanceWindowArgs>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var newNatGateway: Output<Boolean>? = null

    private var nodeCidrMask: Output<Int>? = null

    private var podCidr: Output<String>? = null

    private var podVswitchIds: Output<List<String>>? = null

    private var proxyMode: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var retainResources: Output<List<String>>? = null

    private var securityGroupId: Output<String>? = null

    private var serviceAccountIssuer: Output<String>? = null

    private var serviceCidr: Output<String>? = null

    private var slbInternetEnabled: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timezone: Output<String>? = null

    private var userCa: Output<String>? = null

    private var version: Output<String>? = null

    private var workerVswitchIds: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("isajwtsbinebwnmd")
    public suspend fun addons(`value`: Output<List<ManagedKubernetesAddonArgs>>) {
        this.addons = value
    }

    @JvmName("eyyijtjrmcgnmaal")
    public suspend fun addons(vararg values: Output<ManagedKubernetesAddonArgs>) {
        this.addons = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("toaahvmdgfuyigbb")
    public suspend fun addons(values: List<Output<ManagedKubernetesAddonArgs>>) {
        this.addons = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("aqclmlhewfhqvmae")
    public suspend fun apiAudiences(`value`: Output<List<String>>) {
        this.apiAudiences = value
    }

    @JvmName("ipqwhmuvalpqvvuq")
    public suspend fun apiAudiences(vararg values: Output<String>) {
        this.apiAudiences = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("nyqwbhydcsbjdsyo")
    public suspend fun apiAudiences(values: List<Output<String>>) {
        this.apiAudiences = Output.all(values)
    }

    /**
     * @param value The base64 encoded client certificate data required to communicate with your cluster. Add this to the client-certificate-data section of the kubeconfig file for your cluster.
     */
    @JvmName("alygymqqrdvchbaa")
    public suspend fun clientCert(`value`: Output<String>) {
        this.clientCert = value
    }

    /**
     * @param value The base64 encoded client key data required to communicate with your cluster. Add this to the client-key-data section of the kubeconfig file for your cluster.
     */
    @JvmName("olsajcywaevpkmxs")
    public suspend fun clientKey(`value`: Output<String>) {
        this.clientKey = value
    }

    /**
     * @param value
     */
    @JvmName("dqysurqmhrwtwlhv")
    public suspend fun clusterCaCert(`value`: Output<String>) {
        this.clusterCaCert = value
    }

    /**
     * @param value cluster local domain
     */
    @JvmName("yeellijsrlciajce")
    public suspend fun clusterDomain(`value`: Output<String>) {
        this.clusterDomain = value
    }

    /**
     * @param value
     */
    @JvmName("rkpmlqdiryiblqvv")
    public suspend fun clusterSpec(`value`: Output<String>) {
        this.clusterSpec = value
    }

    /**
     * @param value
     */
    @JvmName("morxarlnbsadpcnf")
    public suspend fun controlPlaneLogComponents(`value`: Output<List<String>>) {
        this.controlPlaneLogComponents = value
    }

    @JvmName("unjbrrpxqpudectk")
    public suspend fun controlPlaneLogComponents(vararg values: Output<String>) {
        this.controlPlaneLogComponents = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("obofyqdjgooaoorl")
    public suspend fun controlPlaneLogComponents(values: List<Output<String>>) {
        this.controlPlaneLogComponents = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("welrxgsgtongeajq")
    public suspend fun controlPlaneLogProject(`value`: Output<String>) {
        this.controlPlaneLogProject = value
    }

    /**
     * @param value
     */
    @JvmName("htbqunotmrcqsclu")
    public suspend fun controlPlaneLogTtl(`value`: Output<String>) {
        this.controlPlaneLogTtl = value
    }

    /**
     * @param value
     */
    @JvmName("pewhxkqbfhblxijh")
    public suspend fun customSan(`value`: Output<String>) {
        this.customSan = value
    }

    /**
     * @param value
     */
    @JvmName("yfjqddfdaeehvhas")
    public suspend fun deleteOptions(`value`: Output<List<ManagedKubernetesDeleteOptionArgs>>) {
        this.deleteOptions = value
    }

    @JvmName("ibddosmxjndsfmjk")
    public suspend fun deleteOptions(vararg values: Output<ManagedKubernetesDeleteOptionArgs>) {
        this.deleteOptions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("yybirmsicbftayka")
    public suspend fun deleteOptions(values: List<Output<ManagedKubernetesDeleteOptionArgs>>) {
        this.deleteOptions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("sdbvcaoerqlgfhfy")
    public suspend fun deletionProtection(`value`: Output<Boolean>) {
        this.deletionProtection = value
    }

    /**
     * @param value
     */
    @JvmName("qtrtpfwdykpipxcc")
    public suspend fun enableRrsa(`value`: Output<Boolean>) {
        this.enableRrsa = value
    }

    /**
     * @param value disk encryption key, only in ack-pro
     */
    @JvmName("pbjwqcewbewxfgve")
    public suspend fun encryptionProviderKey(`value`: Output<String>) {
        this.encryptionProviderKey = value
    }

    /**
     * @param value
     */
    @JvmName("hnniwfpisboladeh")
    public suspend fun isEnterpriseSecurityGroup(`value`: Output<Boolean>) {
        this.isEnterpriseSecurityGroup = value
    }

    /**
     * @param value
     */
    @JvmName("imrgygeixnaowoui")
    public suspend fun loadBalancerSpec(`value`: Output<String>) {
        this.loadBalancerSpec = value
    }

    /**
     * @param value
     */
    @JvmName("ovnmebdxfhwyqjbd")
    public suspend fun maintenanceWindow(`value`: Output<ManagedKubernetesMaintenanceWindowArgs>) {
        this.maintenanceWindow = value
    }

    /**
     * @param value Node name.
     */
    @JvmName("fcybhhxcdvhxoysu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("injokdpyhcmeuymp")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value
     */
    @JvmName("nqsmmqvocixvoknk")
    public suspend fun newNatGateway(`value`: Output<Boolean>) {
        this.newNatGateway = value
    }

    /**
     * @param value
     */
    @JvmName("qyicwatluojfohjg")
    public suspend fun nodeCidrMask(`value`: Output<Int>) {
        this.nodeCidrMask = value
    }

    /**
     * @param value
     */
    @JvmName("molsxytycutwldnb")
    public suspend fun podCidr(`value`: Output<String>) {
        this.podCidr = value
    }

    /**
     * @param value
     */
    @JvmName("lcrisxdjeehyjpvo")
    public suspend fun podVswitchIds(`value`: Output<List<String>>) {
        this.podVswitchIds = value
    }

    @JvmName("uwlyfgkenbomonjl")
    public suspend fun podVswitchIds(vararg values: Output<String>) {
        this.podVswitchIds = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("qrvnvprkpmsqcbol")
    public suspend fun podVswitchIds(values: List<Output<String>>) {
        this.podVswitchIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("tqdheardhssgwjhx")
    public suspend fun proxyMode(`value`: Output<String>) {
        this.proxyMode = value
    }

    /**
     * @param value
     */
    @JvmName("doxevspqmarqoitl")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value
     */
    @JvmName("kroxxfxbyogucxap")
    public suspend fun retainResources(`value`: Output<List<String>>) {
        this.retainResources = value
    }

    @JvmName("ildxvjupsafitttm")
    public suspend fun retainResources(vararg values: Output<String>) {
        this.retainResources = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("fukanncvbxpmhcep")
    public suspend fun retainResources(values: List<Output<String>>) {
        this.retainResources = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ruvxevwrllbgpbiq")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value
     */
    @JvmName("txmxggiodoiqxlpr")
    public suspend fun serviceAccountIssuer(`value`: Output<String>) {
        this.serviceAccountIssuer = value
    }

    /**
     * @param value
     */
    @JvmName("kqejrihwopqdnxlu")
    public suspend fun serviceCidr(`value`: Output<String>) {
        this.serviceCidr = value
    }

    /**
     * @param value
     */
    @JvmName("lssthbahpkgrdcji")
    public suspend fun slbInternetEnabled(`value`: Output<Boolean>) {
        this.slbInternetEnabled = value
    }

    /**
     * @param value
     */
    @JvmName("cjbqspumqkklelop")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("nobmlfremytmssjg")
    public suspend fun timezone(`value`: Output<String>) {
        this.timezone = value
    }

    /**
     * @param value
     */
    @JvmName("tjecxrcgdtcsvdgn")
    public suspend fun userCa(`value`: Output<String>) {
        this.userCa = value
    }

    /**
     * @param value
     */
    @JvmName("wqvdfqoqfojlxqjy")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value
     */
    @JvmName("kukjahorxdlcdbyq")
    public suspend fun workerVswitchIds(`value`: Output<List<String>>) {
        this.workerVswitchIds = value
    }

    @JvmName("cgoborxjgvvwsyyt")
    public suspend fun workerVswitchIds(vararg values: Output<String>) {
        this.workerVswitchIds = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ehcbdbeqsgemnxpl")
    public suspend fun workerVswitchIds(values: List<Output<String>>) {
        this.workerVswitchIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("xrjynqixegmeagmq")
    public suspend fun addons(`value`: List<ManagedKubernetesAddonArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addons = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yfexnljrsufdrwtd")
    public suspend fun addons(argument: List<suspend ManagedKubernetesAddonArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagedKubernetesAddonArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.addons = mapped
    }

    /**
     * @param argument
     */
    @JvmName("okrpckecckctlexy")
    public suspend fun addons(vararg argument: suspend ManagedKubernetesAddonArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ManagedKubernetesAddonArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.addons = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pvowmejwubsfieot")
    public suspend fun addons(argument: suspend ManagedKubernetesAddonArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ManagedKubernetesAddonArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.addons = mapped
    }

    /**
     * @param values
     */
    @JvmName("gkwbleorvfrovktw")
    public suspend fun addons(vararg values: ManagedKubernetesAddonArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addons = mapped
    }

    /**
     * @param value
     */
    @JvmName("bqtixpneupybmhmm")
    public suspend fun apiAudiences(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiAudiences = mapped
    }

    /**
     * @param values
     */
    @JvmName("hkedbwhhcwlrnsjq")
    public suspend fun apiAudiences(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiAudiences = mapped
    }

    /**
     * @param value The base64 encoded client certificate data required to communicate with your cluster. Add this to the client-certificate-data section of the kubeconfig file for your cluster.
     */
    @JvmName("blybauucanhbsmqv")
    public suspend fun clientCert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCert = mapped
    }

    /**
     * @param value The base64 encoded client key data required to communicate with your cluster. Add this to the client-key-data section of the kubeconfig file for your cluster.
     */
    @JvmName("ciibuaogmaxxmiyf")
    public suspend fun clientKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientKey = mapped
    }

    /**
     * @param value
     */
    @JvmName("yilpbgwbvqjavbpg")
    public suspend fun clusterCaCert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterCaCert = mapped
    }

    /**
     * @param value cluster local domain
     */
    @JvmName("niauitsrsscmrghj")
    public suspend fun clusterDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterDomain = mapped
    }

    /**
     * @param value
     */
    @JvmName("bdhoqryhemcbmqax")
    public suspend fun clusterSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterSpec = mapped
    }

    /**
     * @param value
     */
    @JvmName("rlbsfxlbsydsateb")
    public suspend fun controlPlaneLogComponents(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlPlaneLogComponents = mapped
    }

    /**
     * @param values
     */
    @JvmName("eiimuydjttvrxqhm")
    public suspend fun controlPlaneLogComponents(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.controlPlaneLogComponents = mapped
    }

    /**
     * @param value
     */
    @JvmName("byavjrtmdvtbnacj")
    public suspend fun controlPlaneLogProject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlPlaneLogProject = mapped
    }

    /**
     * @param value
     */
    @JvmName("cqavdkrcolfftirj")
    public suspend fun controlPlaneLogTtl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlPlaneLogTtl = mapped
    }

    /**
     * @param value
     */
    @JvmName("jxvwbilormnakdgp")
    public suspend fun customSan(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSan = mapped
    }

    /**
     * @param value
     */
    @JvmName("fkkqetpikfckxbvj")
    public suspend fun deleteOptions(`value`: List<ManagedKubernetesDeleteOptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOptions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uyanarycjckikxvl")
    public suspend fun deleteOptions(argument: List<suspend ManagedKubernetesDeleteOptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagedKubernetesDeleteOptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.deleteOptions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qfiddhlvrawrokmn")
    public suspend fun deleteOptions(vararg argument: suspend ManagedKubernetesDeleteOptionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ManagedKubernetesDeleteOptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.deleteOptions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("inoaedkqiiimyyva")
    public suspend fun deleteOptions(argument: suspend ManagedKubernetesDeleteOptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ManagedKubernetesDeleteOptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.deleteOptions = mapped
    }

    /**
     * @param values
     */
    @JvmName("stxytsbadogywvon")
    public suspend fun deleteOptions(vararg values: ManagedKubernetesDeleteOptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOptions = mapped
    }

    /**
     * @param value
     */
    @JvmName("wyqbukxxwxrxlwav")
    public suspend fun deletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value
     */
    @JvmName("wrjijjgyrfixjyqx")
    public suspend fun enableRrsa(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRrsa = mapped
    }

    /**
     * @param value disk encryption key, only in ack-pro
     */
    @JvmName("ksjdgoivovaubuca")
    public suspend fun encryptionProviderKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionProviderKey = mapped
    }

    /**
     * @param value
     */
    @JvmName("fadjkxacpdgsqgin")
    public suspend fun isEnterpriseSecurityGroup(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnterpriseSecurityGroup = mapped
    }

    /**
     * @param value
     */
    @JvmName("nusygjrsakiwepwv")
    public suspend fun loadBalancerSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerSpec = mapped
    }

    /**
     * @param value
     */
    @JvmName("ktujfgmdkaqdahop")
    public suspend fun maintenanceWindow(`value`: ManagedKubernetesMaintenanceWindowArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceWindow = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gxxwnpqroytopcby")
    public suspend fun maintenanceWindow(argument: suspend ManagedKubernetesMaintenanceWindowArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedKubernetesMaintenanceWindowArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.maintenanceWindow = mapped
    }

    /**
     * @param value Node name.
     */
    @JvmName("uovrgpahuakvpjtp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("fbyjhmshgjfwdivo")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value
     */
    @JvmName("hxlcpufhavrqwoih")
    public suspend fun newNatGateway(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newNatGateway = mapped
    }

    /**
     * @param value
     */
    @JvmName("uwjicmpwlhnjclwp")
    public suspend fun nodeCidrMask(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeCidrMask = mapped
    }

    /**
     * @param value
     */
    @JvmName("toguytombhuknayq")
    public suspend fun podCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.podCidr = mapped
    }

    /**
     * @param value
     */
    @JvmName("daauhtcurjnoufma")
    public suspend fun podVswitchIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.podVswitchIds = mapped
    }

    /**
     * @param values
     */
    @JvmName("hattsyfpxsvjyxxj")
    public suspend fun podVswitchIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.podVswitchIds = mapped
    }

    /**
     * @param value
     */
    @JvmName("flycrnhuoyqaouml")
    public suspend fun proxyMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyMode = mapped
    }

    /**
     * @param value
     */
    @JvmName("kummnpgaatlkqjcv")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("cxaralemsdxsykla")
    public suspend fun retainResources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retainResources = mapped
    }

    /**
     * @param values
     */
    @JvmName("cjwscjnwppkbcfqw")
    public suspend fun retainResources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retainResources = mapped
    }

    /**
     * @param value
     */
    @JvmName("hijoobaqdmvjkbvn")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("uutlfaihqcoayjiw")
    public suspend fun serviceAccountIssuer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAccountIssuer = mapped
    }

    /**
     * @param value
     */
    @JvmName("ixpxjovhhfxadmsh")
    public suspend fun serviceCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceCidr = mapped
    }

    /**
     * @param value
     */
    @JvmName("gyqhanfvqthvluqm")
    public suspend fun slbInternetEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slbInternetEnabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("puolnoemgbloqkko")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("esbwoklixkjwtxsl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("wrbrissupktehhuv")
    public suspend fun timezone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timezone = mapped
    }

    /**
     * @param value
     */
    @JvmName("utiikywcwixdgqye")
    public suspend fun userCa(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userCa = mapped
    }

    /**
     * @param value
     */
    @JvmName("htraqlowjkmnahky")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value
     */
    @JvmName("xewcipxcaavenqyj")
    public suspend fun workerVswitchIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerVswitchIds = mapped
    }

    /**
     * @param values
     */
    @JvmName("grpvcahxjqhosngj")
    public suspend fun workerVswitchIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workerVswitchIds = mapped
    }

    internal fun build(): ManagedKubernetesArgs = ManagedKubernetesArgs(
        addons = addons,
        apiAudiences = apiAudiences,
        clientCert = clientCert,
        clientKey = clientKey,
        clusterCaCert = clusterCaCert,
        clusterDomain = clusterDomain,
        clusterSpec = clusterSpec,
        controlPlaneLogComponents = controlPlaneLogComponents,
        controlPlaneLogProject = controlPlaneLogProject,
        controlPlaneLogTtl = controlPlaneLogTtl,
        customSan = customSan,
        deleteOptions = deleteOptions,
        deletionProtection = deletionProtection,
        enableRrsa = enableRrsa,
        encryptionProviderKey = encryptionProviderKey,
        isEnterpriseSecurityGroup = isEnterpriseSecurityGroup,
        loadBalancerSpec = loadBalancerSpec,
        maintenanceWindow = maintenanceWindow,
        name = name,
        namePrefix = namePrefix,
        newNatGateway = newNatGateway,
        nodeCidrMask = nodeCidrMask,
        podCidr = podCidr,
        podVswitchIds = podVswitchIds,
        proxyMode = proxyMode,
        resourceGroupId = resourceGroupId,
        retainResources = retainResources,
        securityGroupId = securityGroupId,
        serviceAccountIssuer = serviceAccountIssuer,
        serviceCidr = serviceCidr,
        slbInternetEnabled = slbInternetEnabled,
        tags = tags,
        timezone = timezone,
        userCa = userCa,
        version = version,
        workerVswitchIds = workerVswitchIds,
    )
}
