@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.kotlin.outputs.NodePoolDataDisk
import com.pulumi.alicloud.cs.kotlin.outputs.NodePoolKubeletConfiguration
import com.pulumi.alicloud.cs.kotlin.outputs.NodePoolLabel
import com.pulumi.alicloud.cs.kotlin.outputs.NodePoolManagement
import com.pulumi.alicloud.cs.kotlin.outputs.NodePoolPrivatePoolOptions
import com.pulumi.alicloud.cs.kotlin.outputs.NodePoolRollingPolicy
import com.pulumi.alicloud.cs.kotlin.outputs.NodePoolScalingConfig
import com.pulumi.alicloud.cs.kotlin.outputs.NodePoolSpotPriceLimit
import com.pulumi.alicloud.cs.kotlin.outputs.NodePoolTaint
import com.pulumi.alicloud.cs.kotlin.outputs.NodePoolTeeConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.cs.kotlin.outputs.NodePoolDataDisk.Companion.toKotlin as nodePoolDataDiskToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.NodePoolKubeletConfiguration.Companion.toKotlin as nodePoolKubeletConfigurationToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.NodePoolLabel.Companion.toKotlin as nodePoolLabelToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.NodePoolManagement.Companion.toKotlin as nodePoolManagementToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.NodePoolPrivatePoolOptions.Companion.toKotlin as nodePoolPrivatePoolOptionsToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.NodePoolRollingPolicy.Companion.toKotlin as nodePoolRollingPolicyToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.NodePoolScalingConfig.Companion.toKotlin as nodePoolScalingConfigToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.NodePoolSpotPriceLimit.Companion.toKotlin as nodePoolSpotPriceLimitToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.NodePoolTaint.Companion.toKotlin as nodePoolTaintToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.NodePoolTeeConfig.Companion.toKotlin as nodePoolTeeConfigToKotlin

/**
 * Builder for [NodePool].
 */
@PulumiTagMarker
public class NodePoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NodePoolArgs = NodePoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NodePoolArgsBuilder.() -> Unit) {
        val builder = NodePoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NodePool {
        val builtJavaResource = com.pulumi.alicloud.cs.NodePool(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NodePool(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Basic Usage
 * ## Import
 * ACK Nodepool can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cs/nodePool:NodePool example <cluster_id>:<node_pool_id>
 * ```
 */
public class NodePool internal constructor(
    override val javaResource: com.pulumi.alicloud.cs.NodePool,
) : KotlinCustomResource(javaResource, NodePoolMapper) {
    /**
     * Whether to enable automatic renewal for nodes in the node pool takes effect only when `instance_charge_type` is set to `PrePaid`. Default value: `false`. Valid values:
     */
    public val autoRenew: Output<Boolean>?
        get() = javaResource.autoRenew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The automatic renewal period of nodes in the node pool takes effect only when you select Prepaid and Automatic Renewal, and is a required value. When `PeriodUnit = Month`, the value range is {1, 2, 3, 6, 12}. Default value: 1.
     */
    public val autoRenewPeriod: Output<Int>?
        get() = javaResource.autoRenewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. Use `security_hardening_os` instead.
     */
    @Deprecated(
        message = """
  Field 'cis_enabled' has been deprecated from provider version 1.223.1. Whether enable worker node
      to support cis security reinforcement, its valid value `true` or `false`. Default to `false`
      and apply to AliyunLinux series. Use `security_hardening_os` instead.
  """,
    )
    public val cisEnabled: Output<Boolean>?
        get() = javaResource.cisEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The id of kubernetes cluster.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to automatically create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created due to reasons such as cost or insufficient inventory. This parameter takes effect when you set `multi_az_policy` to `COST_OPTIMIZED`. Valid values: `true`: automatically creates pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created. `false`: does not create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created.
     */
    public val compensateWithOnDemand: Output<Boolean>?
        get() = javaResource.compensateWithOnDemand().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Node CPU management policies. Default value: `none`. When the cluster version is 1.12.6 or later, the following two policies are supported:
     */
    public val cpuPolicy: Output<String>
        get() = javaResource.cpuPolicy().applyValue({ args0 -> args0 })

    /**
     * Configure the data disk of the node in the node pool. See `data_disks` below.
     */
    public val dataDisks: Output<List<NodePoolDataDisk>>?
        get() = javaResource.dataDisks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> nodePoolDataDiskToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The deployment set of node pool. Specify the deploymentSet to ensure that the nodes in the node pool can be distributed on different physical machines.
     */
    public val deploymentSetId: Output<String>?
        get() = javaResource.deploymentSetId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Number of expected nodes in the node pool.
     */
    public val desiredSize: Output<Int>?
        get() = javaResource.desiredSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to force deletion.
     */
    public val forceDelete: Output<Boolean>?
        get() = javaResource.forceDelete().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * After you select this check box, if data disks have been attached to the specified ECS instances and the file system of the last data disk is uninitialized, the system automatically formats the last data disk to ext4 and mounts the data disk to /var/lib/docker and /var/lib/kubelet. The original data on the disk will be cleared. Make sure that you back up data in advance. If no data disk is mounted on the ECS instance, no new data disk will be purchased. Default is `false`.
     */
    public val formatDisk: Output<Boolean>
        get() = javaResource.formatDisk().applyValue({ args0 -> args0 })

    /**
     * The custom image ID. The system-provided image is used by default.
     */
    public val imageId: Output<String>
        get() = javaResource.imageId().applyValue({ args0 -> args0 })

    /**
     * The operating system image type and the `platform` parameter can be selected from the following values:
     * - `AliyunLinux` : Alinux2 image.
     * - `AliyunLinux3` : Alinux3 image.
     * - `AliyunLinux3Arm64` : Alinux3 mirror ARM version.
     * - `AliyunLinuxUEFI` : Alinux2 Image UEFI version.
     * - `CentOS` : CentOS image.
     * - `Windows` : Windows image.
     * - `WindowsCore` : WindowsCore image.
     * - `ContainerOS` : container-optimized image.
     */
    public val imageType: Output<String>
        get() = javaResource.imageType().applyValue({ args0 -> args0 })

    /**
     * Whether to install cloud monitoring on the ECS node. After installation, you can view the monitoring information of the created ECS instance in the cloud monitoring console and recommend enable it. Default value: `false`. Valid values:
     */
    public val installCloudMonitor: Output<Boolean>?
        get() = javaResource.installCloudMonitor().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Node payment type. Valid values: `PostPaid`, `PrePaid`, default is `PostPaid`. If value is `PrePaid`, the arguments `period`, `period_unit`, `auto_renew` and `auto_renew_period` are required.
     */
    public val instanceChargeType: Output<String>?
        get() = javaResource.instanceChargeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * In the node instance specification list, you can select multiple instance specifications as alternatives. When each node is created, it will try to purchase from the first specification until it is created successfully. The final purchased instance specifications may vary with inventory changes.
     */
    public val instanceTypes: Output<List<String>>
        get() = javaResource.instanceTypes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The instance list. Add existing nodes under the same cluster VPC to the node pool.
     */
    public val instances: Output<List<String>>?
        get() = javaResource.instances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The billing method for network usage. Valid values `PayByBandwidth` and `PayByTraffic`. Conflict with `eip_internet_charge_type`, EIP and public network IP can only choose one.
     */
    public val internetChargeType: Output<String>?
        get() = javaResource.internetChargeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum bandwidth of the public IP address of the node. The unit is Mbps(Mega bit per second). The value range is:\[1,100\]
     */
    public val internetMaxBandwidthOut: Output<Int>?
        get() = javaResource.internetMaxBandwidthOut().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Add an existing instance to the node pool, whether to keep the original instance name. It is recommended to set to `true`.
     */
    public val keepInstanceName: Output<Boolean>
        get() = javaResource.keepInstanceName().applyValue({ args0 -> args0 })

    /**
     * The name of the key pair. When the node pool is a managed node pool, only `key_name` is supported.
     */
    public val keyName: Output<String>?
        get() = javaResource.keyName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
     */
    public val kmsEncryptedPassword: Output<String>?
        get() = javaResource.kmsEncryptedPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    public val kmsEncryptionContext: Output<Map<String, String>>?
        get() = javaResource.kmsEncryptionContext().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/). See `kubelet_configuration` below.
     */
    public val kubeletConfiguration: Output<NodePoolKubeletConfiguration>?
        get() = javaResource.kubeletConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> nodePoolKubeletConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
     */
    public val labels: Output<List<NodePoolLabel>>?
        get() = javaResource.labels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> nodePoolLabelToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Whether the ECS instance is logged on as a ecs-user user. Valid value: `true` and `false`.
     */
    public val loginAsNonRoot: Output<Boolean>?
        get() = javaResource.loginAsNonRoot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Managed node pool configuration. See `management` below.
     */
    public val management: Output<NodePoolManagement>
        get() = javaResource.management().applyValue({ args0 ->
            args0.let({ args0 ->
                nodePoolManagementToKotlin(args0)
            })
        })

    /**
     * The scaling policy for ECS instances in a multi-zone scaling group. Valid value: `PRIORITY`, `COST_OPTIMIZED` and `BALANCE`. `PRIORITY`: scales the capacity according to the virtual switches you define (VSwitchIds.N). When an ECS instance cannot be created in the zone where the higher-priority vSwitch is located, the next-priority vSwitch is automatically used to create an ECS instance. `COST_OPTIMIZED`: try to create by vCPU unit price from low to high. When the scaling configuration is configured with multiple instances of preemptible billing, preemptible instances are created first. You can continue to use the `CompensateWithOnDemand` parameter to specify whether to automatically try to create a preemptible instance by paying for it. It takes effect only when the scaling configuration has multi-instance specifications or preemptible instances. `BALANCE`: distributes ECS instances evenly among the multi-zone specified by the scaling group. If the zones become unbalanced due to insufficient inventory, you can use the API RebalanceInstances to balance resources.
     */
    public val multiAzPolicy: Output<String>
        get() = javaResource.multiAzPolicy().applyValue({ args0 -> args0 })

    /**
     * . Field 'name' has been deprecated from provider version 1.219.0. New field 'node_pool_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.219.0. New field 'node_pool_name'
      instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The worker node number of the node pool. From version 1.111.0, `node_count` is not required.
     */
    @Deprecated(
        message = """
  Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size'
      instead.
  """,
    )
    public val nodeCount: Output<Int>
        get() = javaResource.nodeCount().applyValue({ args0 -> args0 })

    /**
     * Each node name consists of a prefix, its private network IP, and a suffix, separated by commas. The input format is `customized,,ip,`.
     * - The prefix and suffix can be composed of one or more parts separated by '.', each part can use lowercase letters, numbers and '-', and the beginning and end of the node name must be lowercase letters and numbers.
     * - The node IP address is the complete private IP address of the node.
     * - For example, if the string `customized,aliyun,ip,com` is passed in (where 'customized' and 'ip' are fixed strings, 'aliyun' is the prefix, and 'com' is the suffix), the name of the node is `aliyun192.168.xxx.xxxcom`.
     */
    public val nodeNameMode: Output<String>
        get() = javaResource.nodeNameMode().applyValue({ args0 -> args0 })

    /**
     * The first ID of the resource.
     */
    public val nodePoolId: Output<String>
        get() = javaResource.nodePoolId().applyValue({ args0 -> args0 })

    /**
     * The name of node pool.
     */
    public val nodePoolName: Output<String>
        get() = javaResource.nodePoolName().applyValue({ args0 -> args0 })

    /**
     * The minimum number of pay-as-you-go instances that must be kept in the scaling group. Valid values: 0 to 1000. If the number of pay-as-you-go instances is less than the value of this parameter, Auto Scaling preferably creates pay-as-you-go instances.
     */
    public val onDemandBaseCapacity: Output<Int>?
        get() = javaResource.onDemandBaseCapacity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The percentage of pay-as-you-go instances among the extra instances that exceed the number specified by `on_demand_base_capacity`. Valid values: 0 to 100.
     */
    public val onDemandPercentageAboveBaseCapacity: Output<Int>?
        get() = javaResource.onDemandPercentageAboveBaseCapacity().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The password of ssh login. You have to specify one of `password` and `key_name` fields. The password rule is 8 to 30 characters and contains at least three items (upper and lower case letters, numbers, and special symbols).
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Node payment period. Its valid value is one of {1, 2, 3, 6, 12}.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Node payment period unit, valid value: `Month`. Default is `Month`.
     */
    public val periodUnit: Output<String>?
        get() = javaResource.periodUnit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Operating system release, using `image_type` instead.
     */
    @Deprecated(
        message = """
  Field 'platform' has been deprecated from provider version 1.145.0. Operating system release,
      using `image_type` instead.
  """,
    )
    public val platform: Output<String>
        get() = javaResource.platform().applyValue({ args0 -> args0 })

    /**
     * Private node pool configuration. See `private_pool_options` below.
     */
    public val privatePoolOptions: Output<NodePoolPrivatePoolOptions>?
        get() = javaResource.privatePoolOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> nodePoolPrivatePoolOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The list of RDS instances.
     */
    public val rdsInstances: Output<List<String>>?
        get() = javaResource.rdsInstances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The ID of the resource group
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * Rotary configuration. See `rolling_policy` below.
     */
    public val rollingPolicy: Output<NodePoolRollingPolicy>?
        get() = javaResource.rollingPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> nodePoolRollingPolicyToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The runtime name of containers. If not set, the cluster runtime will be used as the node pool runtime. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm).
     */
    public val runtimeName: Output<String>
        get() = javaResource.runtimeName().applyValue({ args0 -> args0 })

    /**
     * The runtime version of containers. If not set, the cluster runtime will be used as the node pool runtime.
     */
    public val runtimeVersion: Output<String>
        get() = javaResource.runtimeVersion().applyValue({ args0 -> args0 })

    /**
     * Automatic scaling configuration. See `scaling_config` below.
     */
    public val scalingConfig: Output<NodePoolScalingConfig>
        get() = javaResource.scalingConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                nodePoolScalingConfigToKotlin(args0)
            })
        })

    /**
     * The ID of the scaling group.
     */
    public val scalingGroupId: Output<String>
        get() = javaResource.scalingGroupId().applyValue({ args0 -> args0 })

    /**
     * Scaling group mode, default value: `release`. Valid values:
     */
    public val scalingPolicy: Output<String>
        get() = javaResource.scalingPolicy().applyValue({ args0 -> args0 })

    /**
     * The security group ID of the node pool. This field has been replaced by `security_group_ids`, please use the `security_group_ids` field instead.
     */
    @Deprecated(
        message = """
  Field 'security_group_id' has been deprecated from provider version 1.145.0. The security group ID
      of the node pool. This field has been replaced by `security_group_ids`, please use the
      `security_group_ids` field instead.
  """,
    )
    public val securityGroupId: Output<String>
        get() = javaResource.securityGroupId().applyValue({ args0 -> args0 })

    /**
     * Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Alibaba Cloud OS security reinforcement. Default value: `false`. Value:
     */
    public val securityHardeningOs: Output<Boolean>?
        get() = javaResource.securityHardeningOs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether enable worker node to support soc security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [SOC Reinforcement](https://help.aliyun.com/document_detail/196148.html).
     * > **NOTE:**  It is forbidden to set both `security_hardening_os` and `soc_enabled` to `true` at the same time.
     */
    public val socEnabled: Output<Boolean>?
        get() = javaResource.socEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of instance types that are available. Auto Scaling creates preemptible instances of multiple instance types that are available at the lowest cost. Valid values: 1 to 10.
     */
    public val spotInstancePools: Output<Int>?
        get() = javaResource.spotInstancePools().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to supplement preemptible instances when the number of preemptible instances drops below the specified minimum number. If you set the value to true, Auto Scaling attempts to create a new preemptible instance when the system notifies that an existing preemptible instance is about to be reclaimed. Valid values: `true`: enables the supplementation of preemptible instances. `false`: disables the supplementation of preemptible instances.
     */
    public val spotInstanceRemedy: Output<Boolean>?
        get() = javaResource.spotInstanceRemedy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The current single preemptible instance type market price range configuration. See `spot_price_limit` below.
     */
    public val spotPriceLimits: Output<List<NodePoolSpotPriceLimit>>?
        get() = javaResource.spotPriceLimits().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        nodePoolSpotPriceLimitToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The preemptible instance type. Value:
     * - `NoSpot` : Non-preemptible instance.
     * - `SpotWithPriceLimit` : Set the upper limit of the preemptible instance price.
     * - `SpotAsPriceGo` : The system automatically bids, following the actual price of the current market.
     */
    public val spotStrategy: Output<String>
        get() = javaResource.spotStrategy().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable the burst feature for system disks. Valid values:`true`: enables the burst feature. `false`: disables the burst feature. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
     */
    public val systemDiskBurstingEnabled: Output<Boolean>?
        get() = javaResource.systemDiskBurstingEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The multi-disk categories of the system disk. When a high-priority disk type cannot be used, Auto Scaling automatically tries to create a system disk with the next priority disk category. Valid values: `cloud`: cloud disk. `cloud_efficiency`: a high-efficiency cloud disk. `cloud_ssd`:SSD cloud disk. `cloud_essd`: ESSD cloud disk.
     */
    public val systemDiskCategories: Output<List<String>>
        get() = javaResource.systemDiskCategories().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The system disk category of worker node. Its valid value are `cloud_ssd`, `cloud_efficiency`, `cloud_essd` and `cloud_auto`.
     */
    public val systemDiskCategory: Output<String>
        get() = javaResource.systemDiskCategory().applyValue({ args0 -> args0 })

    /**
     * The encryption algorithm used by the system disk. Value range: aes-256.
     */
    public val systemDiskEncryptAlgorithm: Output<String>?
        get() = javaResource.systemDiskEncryptAlgorithm().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to encrypt the system disk. Value range: `true`: encryption. `false`: Do not encrypt.
     */
    public val systemDiskEncrypted: Output<Boolean>?
        get() = javaResource.systemDiskEncrypted().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the KMS key used by the system disk.
     */
    public val systemDiskKmsKey: Output<String>?
        get() = javaResource.systemDiskKmsKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system disk performance of the node takes effect only for the ESSD disk.
     * - `PL0`: maximum random read/write IOPS 10000 for a single disk.
     * - `PL1`: maximum random read/write IOPS 50000 for a single disk.
     * - `PL2`: highest random read/write IOPS 100000 for a single disk.
     * - `PL3`: maximum random read/write IOPS 1 million for a single disk.
     */
    public val systemDiskPerformanceLevel: Output<String>?
        get() = javaResource.systemDiskPerformanceLevel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The predefined IOPS of a system disk. Valid values: 0 to min{50,000, 1,000 × Capacity - Baseline IOPS}. Baseline IOPS = min{1,800 + 50 × Capacity, 50,000}. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
     */
    public val systemDiskProvisionedIops: Output<Int>?
        get() = javaResource.systemDiskProvisionedIops().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system disk category of worker node. Its valid value range [40~500] in GB. Default to `120`.
     */
    public val systemDiskSize: Output<Int>?
        get() = javaResource.systemDiskSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the automatic snapshot policy used by the system disk.
     */
    public val systemDiskSnapshotPolicyId: Output<String>?
        get() = javaResource.systemDiskSnapshotPolicyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Add tags only for ECS instances. The maximum length of the tag key is 128 characters. The tag key and value cannot start with aliyun or acs:, or contain https:// or http://".
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
     */
    public val taints: Output<List<NodePoolTaint>>?
        get() = javaResource.taints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> nodePoolTaintToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The configuration about confidential computing for the cluster. See `tee_config` below.
     */
    public val teeConfig: Output<NodePoolTeeConfig>
        get() = javaResource.teeConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                nodePoolTeeConfigToKotlin(args0)
            })
        })

    /**
     * Whether the node after expansion can be scheduled.
     */
    public val unschedulable: Output<Boolean>?
        get() = javaResource.unschedulable().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Synchronously update node labels and taints.
     */
    public val updateNodes: Output<Boolean>?
        get() = javaResource.updateNodes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Node custom data.
     */
    public val userData: Output<String>?
        get() = javaResource.userData().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The vswitches used by node pool workers.
     */
    public val vswitchIds: Output<List<String>>
        get() = javaResource.vswitchIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object NodePoolMapper : ResourceMapper<NodePool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cs.NodePool::class == javaResource::class

    override fun map(javaResource: Resource): NodePool = NodePool(
        javaResource as
            com.pulumi.alicloud.cs.NodePool,
    )
}

/**
 * @see [NodePool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NodePool].
 */
public suspend fun nodePool(name: String, block: suspend NodePoolResourceBuilder.() -> Unit): NodePool {
    val builder = NodePoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NodePool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun nodePool(name: String): NodePool {
    val builder = NodePoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
