@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.NodePoolArgs.builder
import com.pulumi.alicloud.cs.kotlin.inputs.NodePoolDataDiskArgs
import com.pulumi.alicloud.cs.kotlin.inputs.NodePoolDataDiskArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.NodePoolKubeletConfigurationArgs
import com.pulumi.alicloud.cs.kotlin.inputs.NodePoolKubeletConfigurationArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.NodePoolLabelArgs
import com.pulumi.alicloud.cs.kotlin.inputs.NodePoolLabelArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.NodePoolManagementArgs
import com.pulumi.alicloud.cs.kotlin.inputs.NodePoolManagementArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.NodePoolPrivatePoolOptionsArgs
import com.pulumi.alicloud.cs.kotlin.inputs.NodePoolPrivatePoolOptionsArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.NodePoolRollingPolicyArgs
import com.pulumi.alicloud.cs.kotlin.inputs.NodePoolRollingPolicyArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.NodePoolScalingConfigArgs
import com.pulumi.alicloud.cs.kotlin.inputs.NodePoolScalingConfigArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.NodePoolSpotPriceLimitArgs
import com.pulumi.alicloud.cs.kotlin.inputs.NodePoolSpotPriceLimitArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.NodePoolTaintArgs
import com.pulumi.alicloud.cs.kotlin.inputs.NodePoolTaintArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.NodePoolTeeConfigArgs
import com.pulumi.alicloud.cs.kotlin.inputs.NodePoolTeeConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Basic Usage
 * ## Import
 * ACK Nodepool can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cs/nodePool:NodePool example <cluster_id>:<node_pool_id>
 * ```
 * @property autoRenew Whether to enable automatic renewal for nodes in the node pool takes effect only when `instance_charge_type` is set to `PrePaid`. Default value: `false`. Valid values:
 * @property autoRenewPeriod The automatic renewal period of nodes in the node pool takes effect only when you select Prepaid and Automatic Renewal, and is a required value. When `PeriodUnit = Month`, the value range is {1, 2, 3, 6, 12}. Default value: 1.
 * @property cisEnabled Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. Use `security_hardening_os` instead.
 * @property clusterId The id of kubernetes cluster.
 * @property compensateWithOnDemand Specifies whether to automatically create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created due to reasons such as cost or insufficient inventory. This parameter takes effect when you set `multi_az_policy` to `COST_OPTIMIZED`. Valid values: `true`: automatically creates pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created. `false`: does not create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created.
 * @property cpuPolicy Node CPU management policies. Default value: `none`. When the cluster version is 1.12.6 or later, the following two policies are supported:
 * @property dataDisks Configure the data disk of the node in the node pool. See `data_disks` below.
 * @property deploymentSetId The deployment set of node pool. Specify the deploymentSet to ensure that the nodes in the node pool can be distributed on different physical machines.
 * @property desiredSize Number of expected nodes in the node pool.
 * @property forceDelete Whether to force deletion.
 * @property formatDisk After you select this check box, if data disks have been attached to the specified ECS instances and the file system of the last data disk is uninitialized, the system automatically formats the last data disk to ext4 and mounts the data disk to /var/lib/docker and /var/lib/kubelet. The original data on the disk will be cleared. Make sure that you back up data in advance. If no data disk is mounted on the ECS instance, no new data disk will be purchased. Default is `false`.
 * @property imageId The custom image ID. The system-provided image is used by default.
 * @property imageType The operating system image type and the `platform` parameter can be selected from the following values:
 * - `AliyunLinux` : Alinux2 image.
 * - `AliyunLinux3` : Alinux3 image.
 * - `AliyunLinux3Arm64` : Alinux3 mirror ARM version.
 * - `AliyunLinuxUEFI` : Alinux2 Image UEFI version.
 * - `CentOS` : CentOS image.
 * - `Windows` : Windows image.
 * - `WindowsCore` : WindowsCore image.
 * - `ContainerOS` : container-optimized image.
 * @property installCloudMonitor Whether to install cloud monitoring on the ECS node. After installation, you can view the monitoring information of the created ECS instance in the cloud monitoring console and recommend enable it. Default value: `false`. Valid values:
 * @property instanceChargeType Node payment type. Valid values: `PostPaid`, `PrePaid`, default is `PostPaid`. If value is `PrePaid`, the arguments `period`, `period_unit`, `auto_renew` and `auto_renew_period` are required.
 * @property instanceTypes In the node instance specification list, you can select multiple instance specifications as alternatives. When each node is created, it will try to purchase from the first specification until it is created successfully. The final purchased instance specifications may vary with inventory changes.
 * @property instances The instance list. Add existing nodes under the same cluster VPC to the node pool.
 * @property internetChargeType The billing method for network usage. Valid values `PayByBandwidth` and `PayByTraffic`. Conflict with `eip_internet_charge_type`, EIP and public network IP can only choose one.
 * @property internetMaxBandwidthOut The maximum bandwidth of the public IP address of the node. The unit is Mbps(Mega bit per second). The value range is:\[1,100\]
 * @property keepInstanceName Add an existing instance to the node pool, whether to keep the original instance name. It is recommended to set to `true`.
 * @property keyName The name of the key pair. When the node pool is a managed node pool, only `key_name` is supported.
 * @property kmsEncryptedPassword An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
 * @property kmsEncryptionContext An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
 * @property kubeletConfiguration Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/). See `kubelet_configuration` below.
 * @property labels A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
 * @property loginAsNonRoot Whether the ECS instance is logged on as a ecs-user user. Valid value: `true` and `false`.
 * @property management Managed node pool configuration. See `management` below.
 * @property multiAzPolicy The scaling policy for ECS instances in a multi-zone scaling group. Valid value: `PRIORITY`, `COST_OPTIMIZED` and `BALANCE`. `PRIORITY`: scales the capacity according to the virtual switches you define (VSwitchIds.N). When an ECS instance cannot be created in the zone where the higher-priority vSwitch is located, the next-priority vSwitch is automatically used to create an ECS instance. `COST_OPTIMIZED`: try to create by vCPU unit price from low to high. When the scaling configuration is configured with multiple instances of preemptible billing, preemptible instances are created first. You can continue to use the `CompensateWithOnDemand` parameter to specify whether to automatically try to create a preemptible instance by paying for it. It takes effect only when the scaling configuration has multi-instance specifications or preemptible instances. `BALANCE`: distributes ECS instances evenly among the multi-zone specified by the scaling group. If the zones become unbalanced due to insufficient inventory, you can use the API RebalanceInstances to balance resources.
 * @property name . Field 'name' has been deprecated from provider version 1.219.0. New field 'node_pool_name' instead.
 * @property nodeCount The worker node number of the node pool. From version 1.111.0, `node_count` is not required.
 * @property nodeNameMode Each node name consists of a prefix, its private network IP, and a suffix, separated by commas. The input format is `customized,,ip,`.
 * - The prefix and suffix can be composed of one or more parts separated by '.', each part can use lowercase letters, numbers and '-', and the beginning and end of the node name must be lowercase letters and numbers.
 * - The node IP address is the complete private IP address of the node.
 * - For example, if the string `customized,aliyun,ip,com` is passed in (where 'customized' and 'ip' are fixed strings, 'aliyun' is the prefix, and 'com' is the suffix), the name of the node is `aliyun192.168.xxx.xxxcom`.
 * @property nodePoolName The name of node pool.
 * @property onDemandBaseCapacity The minimum number of pay-as-you-go instances that must be kept in the scaling group. Valid values: 0 to 1000. If the number of pay-as-you-go instances is less than the value of this parameter, Auto Scaling preferably creates pay-as-you-go instances.
 * @property onDemandPercentageAboveBaseCapacity The percentage of pay-as-you-go instances among the extra instances that exceed the number specified by `on_demand_base_capacity`. Valid values: 0 to 100.
 * @property password The password of ssh login. You have to specify one of `password` and `key_name` fields. The password rule is 8 to 30 characters and contains at least three items (upper and lower case letters, numbers, and special symbols).
 * @property period Node payment period. Its valid value is one of {1, 2, 3, 6, 12}.
 * @property periodUnit Node payment period unit, valid value: `Month`. Default is `Month`.
 * @property platform Operating system release, using `image_type` instead.
 * @property privatePoolOptions Private node pool configuration. See `private_pool_options` below.
 * @property rdsInstances The list of RDS instances.
 * @property resourceGroupId The ID of the resource group
 * @property rollingPolicy Rotary configuration. See `rolling_policy` below.
 * @property runtimeName The runtime name of containers. If not set, the cluster runtime will be used as the node pool runtime. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm).
 * @property runtimeVersion The runtime version of containers. If not set, the cluster runtime will be used as the node pool runtime.
 * @property scalingConfig Automatic scaling configuration. See `scaling_config` below.
 * @property scalingPolicy Scaling group mode, default value: `release`. Valid values:
 * @property securityGroupId The security group ID of the node pool. This field has been replaced by `security_group_ids`, please use the `security_group_ids` field instead.
 * @property securityGroupIds Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
 * @property securityHardeningOs Alibaba Cloud OS security reinforcement. Default value: `false`. Value:
 * @property socEnabled Whether enable worker node to support soc security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [SOC Reinforcement](https://help.aliyun.com/document_detail/196148.html).
 * > **NOTE:**  It is forbidden to set both `security_hardening_os` and `soc_enabled` to `true` at the same time.
 * @property spotInstancePools The number of instance types that are available. Auto Scaling creates preemptible instances of multiple instance types that are available at the lowest cost. Valid values: 1 to 10.
 * @property spotInstanceRemedy Specifies whether to supplement preemptible instances when the number of preemptible instances drops below the specified minimum number. If you set the value to true, Auto Scaling attempts to create a new preemptible instance when the system notifies that an existing preemptible instance is about to be reclaimed. Valid values: `true`: enables the supplementation of preemptible instances. `false`: disables the supplementation of preemptible instances.
 * @property spotPriceLimits The current single preemptible instance type market price range configuration. See `spot_price_limit` below.
 * @property spotStrategy The preemptible instance type. Value:
 * - `NoSpot` : Non-preemptible instance.
 * - `SpotWithPriceLimit` : Set the upper limit of the preemptible instance price.
 * - `SpotAsPriceGo` : The system automatically bids, following the actual price of the current market.
 * @property systemDiskBurstingEnabled Specifies whether to enable the burst feature for system disks. Valid values:`true`: enables the burst feature. `false`: disables the burst feature. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
 * @property systemDiskCategories The multi-disk categories of the system disk. When a high-priority disk type cannot be used, Auto Scaling automatically tries to create a system disk with the next priority disk category. Valid values: `cloud`: cloud disk. `cloud_efficiency`: a high-efficiency cloud disk. `cloud_ssd`:SSD cloud disk. `cloud_essd`: ESSD cloud disk.
 * @property systemDiskCategory The system disk category of worker node. Its valid value are `cloud_ssd`, `cloud_efficiency`, `cloud_essd` and `cloud_auto`.
 * @property systemDiskEncryptAlgorithm The encryption algorithm used by the system disk. Value range: aes-256.
 * @property systemDiskEncrypted Whether to encrypt the system disk. Value range: `true`: encryption. `false`: Do not encrypt.
 * @property systemDiskKmsKey The ID of the KMS key used by the system disk.
 * @property systemDiskPerformanceLevel The system disk performance of the node takes effect only for the ESSD disk.
 * - `PL0`: maximum random read/write IOPS 10000 for a single disk.
 * - `PL1`: maximum random read/write IOPS 50000 for a single disk.
 * - `PL2`: highest random read/write IOPS 100000 for a single disk.
 * - `PL3`: maximum random read/write IOPS 1 million for a single disk.
 * @property systemDiskProvisionedIops The predefined IOPS of a system disk. Valid values: 0 to min{50,000, 1,000 × Capacity - Baseline IOPS}. Baseline IOPS = min{1,800 + 50 × Capacity, 50,000}. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
 * @property systemDiskSize The system disk category of worker node. Its valid value range [40~500] in GB. Default to `120`.
 * @property systemDiskSnapshotPolicyId The ID of the automatic snapshot policy used by the system disk.
 * @property tags Add tags only for ECS instances. The maximum length of the tag key is 128 characters. The tag key and value cannot start with aliyun or acs:, or contain https:// or http://".
 * @property taints A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
 * @property teeConfig The configuration about confidential computing for the cluster. See `tee_config` below.
 * @property unschedulable Whether the node after expansion can be scheduled.
 * @property updateNodes Synchronously update node labels and taints.
 * @property userData Node custom data.
 * @property vswitchIds The vswitches used by node pool workers.
 */
public data class NodePoolArgs(
    public val autoRenew: Output<Boolean>? = null,
    public val autoRenewPeriod: Output<Int>? = null,
    @Deprecated(
        message = """
  Field 'cis_enabled' has been deprecated from provider version 1.223.1. Whether enable worker node
      to support cis security reinforcement, its valid value `true` or `false`. Default to `false`
      and apply to AliyunLinux series. Use `security_hardening_os` instead.
  """,
    )
    public val cisEnabled: Output<Boolean>? = null,
    public val clusterId: Output<String>? = null,
    public val compensateWithOnDemand: Output<Boolean>? = null,
    public val cpuPolicy: Output<String>? = null,
    public val dataDisks: Output<List<NodePoolDataDiskArgs>>? = null,
    public val deploymentSetId: Output<String>? = null,
    public val desiredSize: Output<Int>? = null,
    public val forceDelete: Output<Boolean>? = null,
    public val formatDisk: Output<Boolean>? = null,
    public val imageId: Output<String>? = null,
    public val imageType: Output<String>? = null,
    public val installCloudMonitor: Output<Boolean>? = null,
    public val instanceChargeType: Output<String>? = null,
    public val instanceTypes: Output<List<String>>? = null,
    public val instances: Output<List<String>>? = null,
    public val internetChargeType: Output<String>? = null,
    public val internetMaxBandwidthOut: Output<Int>? = null,
    public val keepInstanceName: Output<Boolean>? = null,
    public val keyName: Output<String>? = null,
    public val kmsEncryptedPassword: Output<String>? = null,
    public val kmsEncryptionContext: Output<Map<String, String>>? = null,
    public val kubeletConfiguration: Output<NodePoolKubeletConfigurationArgs>? = null,
    public val labels: Output<List<NodePoolLabelArgs>>? = null,
    public val loginAsNonRoot: Output<Boolean>? = null,
    public val management: Output<NodePoolManagementArgs>? = null,
    public val multiAzPolicy: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.219.0. New field 'node_pool_name'
      instead.
  """,
    )
    public val name: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size'
      instead.
  """,
    )
    public val nodeCount: Output<Int>? = null,
    public val nodeNameMode: Output<String>? = null,
    public val nodePoolName: Output<String>? = null,
    public val onDemandBaseCapacity: Output<Int>? = null,
    public val onDemandPercentageAboveBaseCapacity: Output<Int>? = null,
    public val password: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val periodUnit: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'platform' has been deprecated from provider version 1.145.0. Operating system release,
      using `image_type` instead.
  """,
    )
    public val platform: Output<String>? = null,
    public val privatePoolOptions: Output<NodePoolPrivatePoolOptionsArgs>? = null,
    public val rdsInstances: Output<List<String>>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val rollingPolicy: Output<NodePoolRollingPolicyArgs>? = null,
    public val runtimeName: Output<String>? = null,
    public val runtimeVersion: Output<String>? = null,
    public val scalingConfig: Output<NodePoolScalingConfigArgs>? = null,
    public val scalingPolicy: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'security_group_id' has been deprecated from provider version 1.145.0. The security group ID
      of the node pool. This field has been replaced by `security_group_ids`, please use the
      `security_group_ids` field instead.
  """,
    )
    public val securityGroupId: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val securityHardeningOs: Output<Boolean>? = null,
    public val socEnabled: Output<Boolean>? = null,
    public val spotInstancePools: Output<Int>? = null,
    public val spotInstanceRemedy: Output<Boolean>? = null,
    public val spotPriceLimits: Output<List<NodePoolSpotPriceLimitArgs>>? = null,
    public val spotStrategy: Output<String>? = null,
    public val systemDiskBurstingEnabled: Output<Boolean>? = null,
    public val systemDiskCategories: Output<List<String>>? = null,
    public val systemDiskCategory: Output<String>? = null,
    public val systemDiskEncryptAlgorithm: Output<String>? = null,
    public val systemDiskEncrypted: Output<Boolean>? = null,
    public val systemDiskKmsKey: Output<String>? = null,
    public val systemDiskPerformanceLevel: Output<String>? = null,
    public val systemDiskProvisionedIops: Output<Int>? = null,
    public val systemDiskSize: Output<Int>? = null,
    public val systemDiskSnapshotPolicyId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val taints: Output<List<NodePoolTaintArgs>>? = null,
    public val teeConfig: Output<NodePoolTeeConfigArgs>? = null,
    public val unschedulable: Output<Boolean>? = null,
    public val updateNodes: Output<Boolean>? = null,
    public val userData: Output<String>? = null,
    public val vswitchIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.NodePoolArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.NodePoolArgs =
        com.pulumi.alicloud.cs.NodePoolArgs.builder()
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .autoRenewPeriod(autoRenewPeriod?.applyValue({ args0 -> args0 }))
            .cisEnabled(cisEnabled?.applyValue({ args0 -> args0 }))
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .compensateWithOnDemand(compensateWithOnDemand?.applyValue({ args0 -> args0 }))
            .cpuPolicy(cpuPolicy?.applyValue({ args0 -> args0 }))
            .dataDisks(
                dataDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .deploymentSetId(deploymentSetId?.applyValue({ args0 -> args0 }))
            .desiredSize(desiredSize?.applyValue({ args0 -> args0 }))
            .forceDelete(forceDelete?.applyValue({ args0 -> args0 }))
            .formatDisk(formatDisk?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .imageType(imageType?.applyValue({ args0 -> args0 }))
            .installCloudMonitor(installCloudMonitor?.applyValue({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.applyValue({ args0 -> args0 }))
            .instanceTypes(instanceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .instances(instances?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .internetChargeType(internetChargeType?.applyValue({ args0 -> args0 }))
            .internetMaxBandwidthOut(internetMaxBandwidthOut?.applyValue({ args0 -> args0 }))
            .keepInstanceName(keepInstanceName?.applyValue({ args0 -> args0 }))
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .kmsEncryptedPassword(kmsEncryptedPassword?.applyValue({ args0 -> args0 }))
            .kmsEncryptionContext(
                kmsEncryptionContext?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .kubeletConfiguration(
                kubeletConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .loginAsNonRoot(loginAsNonRoot?.applyValue({ args0 -> args0 }))
            .management(management?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .multiAzPolicy(multiAzPolicy?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .nodeCount(nodeCount?.applyValue({ args0 -> args0 }))
            .nodeNameMode(nodeNameMode?.applyValue({ args0 -> args0 }))
            .nodePoolName(nodePoolName?.applyValue({ args0 -> args0 }))
            .onDemandBaseCapacity(onDemandBaseCapacity?.applyValue({ args0 -> args0 }))
            .onDemandPercentageAboveBaseCapacity(
                onDemandPercentageAboveBaseCapacity?.applyValue({ args0 ->
                    args0
                }),
            )
            .password(password?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodUnit(periodUnit?.applyValue({ args0 -> args0 }))
            .platform(platform?.applyValue({ args0 -> args0 }))
            .privatePoolOptions(
                privatePoolOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rdsInstances(rdsInstances?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .rollingPolicy(rollingPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .runtimeName(runtimeName?.applyValue({ args0 -> args0 }))
            .runtimeVersion(runtimeVersion?.applyValue({ args0 -> args0 }))
            .scalingConfig(scalingConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scalingPolicy(scalingPolicy?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityHardeningOs(securityHardeningOs?.applyValue({ args0 -> args0 }))
            .socEnabled(socEnabled?.applyValue({ args0 -> args0 }))
            .spotInstancePools(spotInstancePools?.applyValue({ args0 -> args0 }))
            .spotInstanceRemedy(spotInstanceRemedy?.applyValue({ args0 -> args0 }))
            .spotPriceLimits(
                spotPriceLimits?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .spotStrategy(spotStrategy?.applyValue({ args0 -> args0 }))
            .systemDiskBurstingEnabled(systemDiskBurstingEnabled?.applyValue({ args0 -> args0 }))
            .systemDiskCategories(systemDiskCategories?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .systemDiskCategory(systemDiskCategory?.applyValue({ args0 -> args0 }))
            .systemDiskEncryptAlgorithm(systemDiskEncryptAlgorithm?.applyValue({ args0 -> args0 }))
            .systemDiskEncrypted(systemDiskEncrypted?.applyValue({ args0 -> args0 }))
            .systemDiskKmsKey(systemDiskKmsKey?.applyValue({ args0 -> args0 }))
            .systemDiskPerformanceLevel(systemDiskPerformanceLevel?.applyValue({ args0 -> args0 }))
            .systemDiskProvisionedIops(systemDiskProvisionedIops?.applyValue({ args0 -> args0 }))
            .systemDiskSize(systemDiskSize?.applyValue({ args0 -> args0 }))
            .systemDiskSnapshotPolicyId(systemDiskSnapshotPolicyId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .taints(taints?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .teeConfig(teeConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .unschedulable(unschedulable?.applyValue({ args0 -> args0 }))
            .updateNodes(updateNodes?.applyValue({ args0 -> args0 }))
            .userData(userData?.applyValue({ args0 -> args0 }))
            .vswitchIds(vswitchIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [NodePoolArgs].
 */
@PulumiTagMarker
public class NodePoolArgsBuilder internal constructor() {
    private var autoRenew: Output<Boolean>? = null

    private var autoRenewPeriod: Output<Int>? = null

    private var cisEnabled: Output<Boolean>? = null

    private var clusterId: Output<String>? = null

    private var compensateWithOnDemand: Output<Boolean>? = null

    private var cpuPolicy: Output<String>? = null

    private var dataDisks: Output<List<NodePoolDataDiskArgs>>? = null

    private var deploymentSetId: Output<String>? = null

    private var desiredSize: Output<Int>? = null

    private var forceDelete: Output<Boolean>? = null

    private var formatDisk: Output<Boolean>? = null

    private var imageId: Output<String>? = null

    private var imageType: Output<String>? = null

    private var installCloudMonitor: Output<Boolean>? = null

    private var instanceChargeType: Output<String>? = null

    private var instanceTypes: Output<List<String>>? = null

    private var instances: Output<List<String>>? = null

    private var internetChargeType: Output<String>? = null

    private var internetMaxBandwidthOut: Output<Int>? = null

    private var keepInstanceName: Output<Boolean>? = null

    private var keyName: Output<String>? = null

    private var kmsEncryptedPassword: Output<String>? = null

    private var kmsEncryptionContext: Output<Map<String, String>>? = null

    private var kubeletConfiguration: Output<NodePoolKubeletConfigurationArgs>? = null

    private var labels: Output<List<NodePoolLabelArgs>>? = null

    private var loginAsNonRoot: Output<Boolean>? = null

    private var management: Output<NodePoolManagementArgs>? = null

    private var multiAzPolicy: Output<String>? = null

    private var name: Output<String>? = null

    private var nodeCount: Output<Int>? = null

    private var nodeNameMode: Output<String>? = null

    private var nodePoolName: Output<String>? = null

    private var onDemandBaseCapacity: Output<Int>? = null

    private var onDemandPercentageAboveBaseCapacity: Output<Int>? = null

    private var password: Output<String>? = null

    private var period: Output<Int>? = null

    private var periodUnit: Output<String>? = null

    private var platform: Output<String>? = null

    private var privatePoolOptions: Output<NodePoolPrivatePoolOptionsArgs>? = null

    private var rdsInstances: Output<List<String>>? = null

    private var resourceGroupId: Output<String>? = null

    private var rollingPolicy: Output<NodePoolRollingPolicyArgs>? = null

    private var runtimeName: Output<String>? = null

    private var runtimeVersion: Output<String>? = null

    private var scalingConfig: Output<NodePoolScalingConfigArgs>? = null

    private var scalingPolicy: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var securityHardeningOs: Output<Boolean>? = null

    private var socEnabled: Output<Boolean>? = null

    private var spotInstancePools: Output<Int>? = null

    private var spotInstanceRemedy: Output<Boolean>? = null

    private var spotPriceLimits: Output<List<NodePoolSpotPriceLimitArgs>>? = null

    private var spotStrategy: Output<String>? = null

    private var systemDiskBurstingEnabled: Output<Boolean>? = null

    private var systemDiskCategories: Output<List<String>>? = null

    private var systemDiskCategory: Output<String>? = null

    private var systemDiskEncryptAlgorithm: Output<String>? = null

    private var systemDiskEncrypted: Output<Boolean>? = null

    private var systemDiskKmsKey: Output<String>? = null

    private var systemDiskPerformanceLevel: Output<String>? = null

    private var systemDiskProvisionedIops: Output<Int>? = null

    private var systemDiskSize: Output<Int>? = null

    private var systemDiskSnapshotPolicyId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var taints: Output<List<NodePoolTaintArgs>>? = null

    private var teeConfig: Output<NodePoolTeeConfigArgs>? = null

    private var unschedulable: Output<Boolean>? = null

    private var updateNodes: Output<Boolean>? = null

    private var userData: Output<String>? = null

    private var vswitchIds: Output<List<String>>? = null

    /**
     * @param value Whether to enable automatic renewal for nodes in the node pool takes effect only when `instance_charge_type` is set to `PrePaid`. Default value: `false`. Valid values:
     */
    @JvmName("ibwavjopjmhrmgpx")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value The automatic renewal period of nodes in the node pool takes effect only when you select Prepaid and Automatic Renewal, and is a required value. When `PeriodUnit = Month`, the value range is {1, 2, 3, 6, 12}. Default value: 1.
     */
    @JvmName("bnjgpimfppbukphe")
    public suspend fun autoRenewPeriod(`value`: Output<Int>) {
        this.autoRenewPeriod = value
    }

    /**
     * @param value Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. Use `security_hardening_os` instead.
     */
    @Deprecated(
        message = """
  Field 'cis_enabled' has been deprecated from provider version 1.223.1. Whether enable worker node
      to support cis security reinforcement, its valid value `true` or `false`. Default to `false`
      and apply to AliyunLinux series. Use `security_hardening_os` instead.
  """,
    )
    @JvmName("nvgmhtbtsjftfffh")
    public suspend fun cisEnabled(`value`: Output<Boolean>) {
        this.cisEnabled = value
    }

    /**
     * @param value The id of kubernetes cluster.
     */
    @JvmName("rtnspjdycosngxgu")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value Specifies whether to automatically create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created due to reasons such as cost or insufficient inventory. This parameter takes effect when you set `multi_az_policy` to `COST_OPTIMIZED`. Valid values: `true`: automatically creates pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created. `false`: does not create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created.
     */
    @JvmName("rjcqhnchsfvymaen")
    public suspend fun compensateWithOnDemand(`value`: Output<Boolean>) {
        this.compensateWithOnDemand = value
    }

    /**
     * @param value Node CPU management policies. Default value: `none`. When the cluster version is 1.12.6 or later, the following two policies are supported:
     */
    @JvmName("bxsghlvgykebgibq")
    public suspend fun cpuPolicy(`value`: Output<String>) {
        this.cpuPolicy = value
    }

    /**
     * @param value Configure the data disk of the node in the node pool. See `data_disks` below.
     */
    @JvmName("bkcvjcmtmwnouhql")
    public suspend fun dataDisks(`value`: Output<List<NodePoolDataDiskArgs>>) {
        this.dataDisks = value
    }

    @JvmName("ggkkmrnpmdttxume")
    public suspend fun dataDisks(vararg values: Output<NodePoolDataDiskArgs>) {
        this.dataDisks = Output.all(values.asList())
    }

    /**
     * @param values Configure the data disk of the node in the node pool. See `data_disks` below.
     */
    @JvmName("eqatewdrndvqxyoa")
    public suspend fun dataDisks(values: List<Output<NodePoolDataDiskArgs>>) {
        this.dataDisks = Output.all(values)
    }

    /**
     * @param value The deployment set of node pool. Specify the deploymentSet to ensure that the nodes in the node pool can be distributed on different physical machines.
     */
    @JvmName("lmyqncasifkyxvum")
    public suspend fun deploymentSetId(`value`: Output<String>) {
        this.deploymentSetId = value
    }

    /**
     * @param value Number of expected nodes in the node pool.
     */
    @JvmName("vruaddarxgdqldpa")
    public suspend fun desiredSize(`value`: Output<Int>) {
        this.desiredSize = value
    }

    /**
     * @param value Whether to force deletion.
     */
    @JvmName("arqcvefkirqwnnri")
    public suspend fun forceDelete(`value`: Output<Boolean>) {
        this.forceDelete = value
    }

    /**
     * @param value After you select this check box, if data disks have been attached to the specified ECS instances and the file system of the last data disk is uninitialized, the system automatically formats the last data disk to ext4 and mounts the data disk to /var/lib/docker and /var/lib/kubelet. The original data on the disk will be cleared. Make sure that you back up data in advance. If no data disk is mounted on the ECS instance, no new data disk will be purchased. Default is `false`.
     */
    @JvmName("hnvoopyfhvmfpflf")
    public suspend fun formatDisk(`value`: Output<Boolean>) {
        this.formatDisk = value
    }

    /**
     * @param value The custom image ID. The system-provided image is used by default.
     */
    @JvmName("fioghcvjymdvgsrd")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value The operating system image type and the `platform` parameter can be selected from the following values:
     * - `AliyunLinux` : Alinux2 image.
     * - `AliyunLinux3` : Alinux3 image.
     * - `AliyunLinux3Arm64` : Alinux3 mirror ARM version.
     * - `AliyunLinuxUEFI` : Alinux2 Image UEFI version.
     * - `CentOS` : CentOS image.
     * - `Windows` : Windows image.
     * - `WindowsCore` : WindowsCore image.
     * - `ContainerOS` : container-optimized image.
     */
    @JvmName("dltxseymqjhvknbl")
    public suspend fun imageType(`value`: Output<String>) {
        this.imageType = value
    }

    /**
     * @param value Whether to install cloud monitoring on the ECS node. After installation, you can view the monitoring information of the created ECS instance in the cloud monitoring console and recommend enable it. Default value: `false`. Valid values:
     */
    @JvmName("msfrbwemxreqitwa")
    public suspend fun installCloudMonitor(`value`: Output<Boolean>) {
        this.installCloudMonitor = value
    }

    /**
     * @param value Node payment type. Valid values: `PostPaid`, `PrePaid`, default is `PostPaid`. If value is `PrePaid`, the arguments `period`, `period_unit`, `auto_renew` and `auto_renew_period` are required.
     */
    @JvmName("sglkbitwjocnrltc")
    public suspend fun instanceChargeType(`value`: Output<String>) {
        this.instanceChargeType = value
    }

    /**
     * @param value In the node instance specification list, you can select multiple instance specifications as alternatives. When each node is created, it will try to purchase from the first specification until it is created successfully. The final purchased instance specifications may vary with inventory changes.
     */
    @JvmName("xhwceyxsistpxrhy")
    public suspend fun instanceTypes(`value`: Output<List<String>>) {
        this.instanceTypes = value
    }

    @JvmName("snequlehdiumgdek")
    public suspend fun instanceTypes(vararg values: Output<String>) {
        this.instanceTypes = Output.all(values.asList())
    }

    /**
     * @param values In the node instance specification list, you can select multiple instance specifications as alternatives. When each node is created, it will try to purchase from the first specification until it is created successfully. The final purchased instance specifications may vary with inventory changes.
     */
    @JvmName("tlethklbuqslyjjn")
    public suspend fun instanceTypes(values: List<Output<String>>) {
        this.instanceTypes = Output.all(values)
    }

    /**
     * @param value The instance list. Add existing nodes under the same cluster VPC to the node pool.
     */
    @JvmName("jjvaxfrrbgwkrnke")
    public suspend fun instances(`value`: Output<List<String>>) {
        this.instances = value
    }

    @JvmName("gbleveahdplvqxen")
    public suspend fun instances(vararg values: Output<String>) {
        this.instances = Output.all(values.asList())
    }

    /**
     * @param values The instance list. Add existing nodes under the same cluster VPC to the node pool.
     */
    @JvmName("mehxrwxwbrhnavma")
    public suspend fun instances(values: List<Output<String>>) {
        this.instances = Output.all(values)
    }

    /**
     * @param value The billing method for network usage. Valid values `PayByBandwidth` and `PayByTraffic`. Conflict with `eip_internet_charge_type`, EIP and public network IP can only choose one.
     */
    @JvmName("bhhgyvtuigkgrntd")
    public suspend fun internetChargeType(`value`: Output<String>) {
        this.internetChargeType = value
    }

    /**
     * @param value The maximum bandwidth of the public IP address of the node. The unit is Mbps(Mega bit per second). The value range is:\[1,100\]
     */
    @JvmName("sskxwsinkoyyottv")
    public suspend fun internetMaxBandwidthOut(`value`: Output<Int>) {
        this.internetMaxBandwidthOut = value
    }

    /**
     * @param value Add an existing instance to the node pool, whether to keep the original instance name. It is recommended to set to `true`.
     */
    @JvmName("hybgiyamoiieccth")
    public suspend fun keepInstanceName(`value`: Output<Boolean>) {
        this.keepInstanceName = value
    }

    /**
     * @param value The name of the key pair. When the node pool is a managed node pool, only `key_name` is supported.
     */
    @JvmName("mrkgdbkrapjnjwei")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
     */
    @JvmName("uyidfitjdrvaaqmc")
    public suspend fun kmsEncryptedPassword(`value`: Output<String>) {
        this.kmsEncryptedPassword = value
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("copmkbudunlbchky")
    public suspend fun kmsEncryptionContext(`value`: Output<Map<String, String>>) {
        this.kmsEncryptionContext = value
    }

    /**
     * @param value Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/). See `kubelet_configuration` below.
     */
    @JvmName("knxvooihtthlxhix")
    public suspend fun kubeletConfiguration(`value`: Output<NodePoolKubeletConfigurationArgs>) {
        this.kubeletConfiguration = value
    }

    /**
     * @param value A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
     */
    @JvmName("wnjhhyqixylhbbrb")
    public suspend fun labels(`value`: Output<List<NodePoolLabelArgs>>) {
        this.labels = value
    }

    @JvmName("ujjjdkjxkhiwdfms")
    public suspend fun labels(vararg values: Output<NodePoolLabelArgs>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
     */
    @JvmName("trdlnytmewcoiyxs")
    public suspend fun labels(values: List<Output<NodePoolLabelArgs>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value Whether the ECS instance is logged on as a ecs-user user. Valid value: `true` and `false`.
     */
    @JvmName("mwqkjjmeqvohtpfn")
    public suspend fun loginAsNonRoot(`value`: Output<Boolean>) {
        this.loginAsNonRoot = value
    }

    /**
     * @param value Managed node pool configuration. See `management` below.
     */
    @JvmName("llagopdeifghektc")
    public suspend fun management(`value`: Output<NodePoolManagementArgs>) {
        this.management = value
    }

    /**
     * @param value The scaling policy for ECS instances in a multi-zone scaling group. Valid value: `PRIORITY`, `COST_OPTIMIZED` and `BALANCE`. `PRIORITY`: scales the capacity according to the virtual switches you define (VSwitchIds.N). When an ECS instance cannot be created in the zone where the higher-priority vSwitch is located, the next-priority vSwitch is automatically used to create an ECS instance. `COST_OPTIMIZED`: try to create by vCPU unit price from low to high. When the scaling configuration is configured with multiple instances of preemptible billing, preemptible instances are created first. You can continue to use the `CompensateWithOnDemand` parameter to specify whether to automatically try to create a preemptible instance by paying for it. It takes effect only when the scaling configuration has multi-instance specifications or preemptible instances. `BALANCE`: distributes ECS instances evenly among the multi-zone specified by the scaling group. If the zones become unbalanced due to insufficient inventory, you can use the API RebalanceInstances to balance resources.
     */
    @JvmName("jmrusgvlbjjxinds")
    public suspend fun multiAzPolicy(`value`: Output<String>) {
        this.multiAzPolicy = value
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.219.0. New field 'node_pool_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.219.0. New field 'node_pool_name'
      instead.
  """,
    )
    @JvmName("grswsmnyvktgaxcf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The worker node number of the node pool. From version 1.111.0, `node_count` is not required.
     */
    @Deprecated(
        message = """
  Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size'
      instead.
  """,
    )
    @JvmName("ifencuajvxklmivh")
    public suspend fun nodeCount(`value`: Output<Int>) {
        this.nodeCount = value
    }

    /**
     * @param value Each node name consists of a prefix, its private network IP, and a suffix, separated by commas. The input format is `customized,,ip,`.
     * - The prefix and suffix can be composed of one or more parts separated by '.', each part can use lowercase letters, numbers and '-', and the beginning and end of the node name must be lowercase letters and numbers.
     * - The node IP address is the complete private IP address of the node.
     * - For example, if the string `customized,aliyun,ip,com` is passed in (where 'customized' and 'ip' are fixed strings, 'aliyun' is the prefix, and 'com' is the suffix), the name of the node is `aliyun192.168.xxx.xxxcom`.
     */
    @JvmName("imajcchhiegviqki")
    public suspend fun nodeNameMode(`value`: Output<String>) {
        this.nodeNameMode = value
    }

    /**
     * @param value The name of node pool.
     */
    @JvmName("fryemkaspphsobwf")
    public suspend fun nodePoolName(`value`: Output<String>) {
        this.nodePoolName = value
    }

    /**
     * @param value The minimum number of pay-as-you-go instances that must be kept in the scaling group. Valid values: 0 to 1000. If the number of pay-as-you-go instances is less than the value of this parameter, Auto Scaling preferably creates pay-as-you-go instances.
     */
    @JvmName("robiwsgrmuaietfu")
    public suspend fun onDemandBaseCapacity(`value`: Output<Int>) {
        this.onDemandBaseCapacity = value
    }

    /**
     * @param value The percentage of pay-as-you-go instances among the extra instances that exceed the number specified by `on_demand_base_capacity`. Valid values: 0 to 100.
     */
    @JvmName("nymoaupeiknkoofx")
    public suspend fun onDemandPercentageAboveBaseCapacity(`value`: Output<Int>) {
        this.onDemandPercentageAboveBaseCapacity = value
    }

    /**
     * @param value The password of ssh login. You have to specify one of `password` and `key_name` fields. The password rule is 8 to 30 characters and contains at least three items (upper and lower case letters, numbers, and special symbols).
     */
    @JvmName("wftbmkpnpbfbprch")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Node payment period. Its valid value is one of {1, 2, 3, 6, 12}.
     */
    @JvmName("tstbpauwxbuivddn")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value Node payment period unit, valid value: `Month`. Default is `Month`.
     */
    @JvmName("xnrjeqrnmoskkmtl")
    public suspend fun periodUnit(`value`: Output<String>) {
        this.periodUnit = value
    }

    /**
     * @param value Operating system release, using `image_type` instead.
     */
    @Deprecated(
        message = """
  Field 'platform' has been deprecated from provider version 1.145.0. Operating system release,
      using `image_type` instead.
  """,
    )
    @JvmName("thjbibadyauvjaan")
    public suspend fun platform(`value`: Output<String>) {
        this.platform = value
    }

    /**
     * @param value Private node pool configuration. See `private_pool_options` below.
     */
    @JvmName("dfgkbyyvumvhlhwx")
    public suspend fun privatePoolOptions(`value`: Output<NodePoolPrivatePoolOptionsArgs>) {
        this.privatePoolOptions = value
    }

    /**
     * @param value The list of RDS instances.
     */
    @JvmName("rxscrohiiyeilitx")
    public suspend fun rdsInstances(`value`: Output<List<String>>) {
        this.rdsInstances = value
    }

    @JvmName("djjhgeocancalnui")
    public suspend fun rdsInstances(vararg values: Output<String>) {
        this.rdsInstances = Output.all(values.asList())
    }

    /**
     * @param values The list of RDS instances.
     */
    @JvmName("xdsiwluoxmfwxfcn")
    public suspend fun rdsInstances(values: List<Output<String>>) {
        this.rdsInstances = Output.all(values)
    }

    /**
     * @param value The ID of the resource group
     */
    @JvmName("devvoywmwoqqeixt")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Rotary configuration. See `rolling_policy` below.
     */
    @JvmName("woohxtwcxaddlull")
    public suspend fun rollingPolicy(`value`: Output<NodePoolRollingPolicyArgs>) {
        this.rollingPolicy = value
    }

    /**
     * @param value The runtime name of containers. If not set, the cluster runtime will be used as the node pool runtime. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm).
     */
    @JvmName("uxhqavxdqhafshue")
    public suspend fun runtimeName(`value`: Output<String>) {
        this.runtimeName = value
    }

    /**
     * @param value The runtime version of containers. If not set, the cluster runtime will be used as the node pool runtime.
     */
    @JvmName("hvqrjvlxshclkohy")
    public suspend fun runtimeVersion(`value`: Output<String>) {
        this.runtimeVersion = value
    }

    /**
     * @param value Automatic scaling configuration. See `scaling_config` below.
     */
    @JvmName("yvhpiybmjmvxdfam")
    public suspend fun scalingConfig(`value`: Output<NodePoolScalingConfigArgs>) {
        this.scalingConfig = value
    }

    /**
     * @param value Scaling group mode, default value: `release`. Valid values:
     */
    @JvmName("qjapwspqlkumaynj")
    public suspend fun scalingPolicy(`value`: Output<String>) {
        this.scalingPolicy = value
    }

    /**
     * @param value The security group ID of the node pool. This field has been replaced by `security_group_ids`, please use the `security_group_ids` field instead.
     */
    @Deprecated(
        message = """
  Field 'security_group_id' has been deprecated from provider version 1.145.0. The security group ID
      of the node pool. This field has been replaced by `security_group_ids`, please use the
      `security_group_ids` field instead.
  """,
    )
    @JvmName("foiramntdjlpxiyi")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
     */
    @JvmName("sbrmrmtbmxaphpma")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("xgdblhpjasjgsjit")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
     */
    @JvmName("ffikdwcgectarcgq")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value Alibaba Cloud OS security reinforcement. Default value: `false`. Value:
     */
    @JvmName("jpdsaurvrsludbek")
    public suspend fun securityHardeningOs(`value`: Output<Boolean>) {
        this.securityHardeningOs = value
    }

    /**
     * @param value Whether enable worker node to support soc security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [SOC Reinforcement](https://help.aliyun.com/document_detail/196148.html).
     * > **NOTE:**  It is forbidden to set both `security_hardening_os` and `soc_enabled` to `true` at the same time.
     */
    @JvmName("ntjsikkjqobfstlo")
    public suspend fun socEnabled(`value`: Output<Boolean>) {
        this.socEnabled = value
    }

    /**
     * @param value The number of instance types that are available. Auto Scaling creates preemptible instances of multiple instance types that are available at the lowest cost. Valid values: 1 to 10.
     */
    @JvmName("qlrdanxxlsgmvxpy")
    public suspend fun spotInstancePools(`value`: Output<Int>) {
        this.spotInstancePools = value
    }

    /**
     * @param value Specifies whether to supplement preemptible instances when the number of preemptible instances drops below the specified minimum number. If you set the value to true, Auto Scaling attempts to create a new preemptible instance when the system notifies that an existing preemptible instance is about to be reclaimed. Valid values: `true`: enables the supplementation of preemptible instances. `false`: disables the supplementation of preemptible instances.
     */
    @JvmName("loehgsvjssgnsdxs")
    public suspend fun spotInstanceRemedy(`value`: Output<Boolean>) {
        this.spotInstanceRemedy = value
    }

    /**
     * @param value The current single preemptible instance type market price range configuration. See `spot_price_limit` below.
     */
    @JvmName("evimgotfjpspgrwb")
    public suspend fun spotPriceLimits(`value`: Output<List<NodePoolSpotPriceLimitArgs>>) {
        this.spotPriceLimits = value
    }

    @JvmName("kutpejssedvkphuv")
    public suspend fun spotPriceLimits(vararg values: Output<NodePoolSpotPriceLimitArgs>) {
        this.spotPriceLimits = Output.all(values.asList())
    }

    /**
     * @param values The current single preemptible instance type market price range configuration. See `spot_price_limit` below.
     */
    @JvmName("wpejtphlejnuprgh")
    public suspend fun spotPriceLimits(values: List<Output<NodePoolSpotPriceLimitArgs>>) {
        this.spotPriceLimits = Output.all(values)
    }

    /**
     * @param value The preemptible instance type. Value:
     * - `NoSpot` : Non-preemptible instance.
     * - `SpotWithPriceLimit` : Set the upper limit of the preemptible instance price.
     * - `SpotAsPriceGo` : The system automatically bids, following the actual price of the current market.
     */
    @JvmName("lnvnhvldaeiuwbok")
    public suspend fun spotStrategy(`value`: Output<String>) {
        this.spotStrategy = value
    }

    /**
     * @param value Specifies whether to enable the burst feature for system disks. Valid values:`true`: enables the burst feature. `false`: disables the burst feature. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
     */
    @JvmName("gfevlrmpkiwkcfmo")
    public suspend fun systemDiskBurstingEnabled(`value`: Output<Boolean>) {
        this.systemDiskBurstingEnabled = value
    }

    /**
     * @param value The multi-disk categories of the system disk. When a high-priority disk type cannot be used, Auto Scaling automatically tries to create a system disk with the next priority disk category. Valid values: `cloud`: cloud disk. `cloud_efficiency`: a high-efficiency cloud disk. `cloud_ssd`:SSD cloud disk. `cloud_essd`: ESSD cloud disk.
     */
    @JvmName("gpuohrknjvbxwpsi")
    public suspend fun systemDiskCategories(`value`: Output<List<String>>) {
        this.systemDiskCategories = value
    }

    @JvmName("tfhuytktullijmhs")
    public suspend fun systemDiskCategories(vararg values: Output<String>) {
        this.systemDiskCategories = Output.all(values.asList())
    }

    /**
     * @param values The multi-disk categories of the system disk. When a high-priority disk type cannot be used, Auto Scaling automatically tries to create a system disk with the next priority disk category. Valid values: `cloud`: cloud disk. `cloud_efficiency`: a high-efficiency cloud disk. `cloud_ssd`:SSD cloud disk. `cloud_essd`: ESSD cloud disk.
     */
    @JvmName("jbxkqhccpajfjhrh")
    public suspend fun systemDiskCategories(values: List<Output<String>>) {
        this.systemDiskCategories = Output.all(values)
    }

    /**
     * @param value The system disk category of worker node. Its valid value are `cloud_ssd`, `cloud_efficiency`, `cloud_essd` and `cloud_auto`.
     */
    @JvmName("vljwmxwnldkyxphv")
    public suspend fun systemDiskCategory(`value`: Output<String>) {
        this.systemDiskCategory = value
    }

    /**
     * @param value The encryption algorithm used by the system disk. Value range: aes-256.
     */
    @JvmName("iuxdwcwmxofpklqw")
    public suspend fun systemDiskEncryptAlgorithm(`value`: Output<String>) {
        this.systemDiskEncryptAlgorithm = value
    }

    /**
     * @param value Whether to encrypt the system disk. Value range: `true`: encryption. `false`: Do not encrypt.
     */
    @JvmName("mmqbxcrwxxxpmbtw")
    public suspend fun systemDiskEncrypted(`value`: Output<Boolean>) {
        this.systemDiskEncrypted = value
    }

    /**
     * @param value The ID of the KMS key used by the system disk.
     */
    @JvmName("efcyhnesyuhqtifg")
    public suspend fun systemDiskKmsKey(`value`: Output<String>) {
        this.systemDiskKmsKey = value
    }

    /**
     * @param value The system disk performance of the node takes effect only for the ESSD disk.
     * - `PL0`: maximum random read/write IOPS 10000 for a single disk.
     * - `PL1`: maximum random read/write IOPS 50000 for a single disk.
     * - `PL2`: highest random read/write IOPS 100000 for a single disk.
     * - `PL3`: maximum random read/write IOPS 1 million for a single disk.
     */
    @JvmName("wjhhjesbkmcywefa")
    public suspend fun systemDiskPerformanceLevel(`value`: Output<String>) {
        this.systemDiskPerformanceLevel = value
    }

    /**
     * @param value The predefined IOPS of a system disk. Valid values: 0 to min{50,000, 1,000 × Capacity - Baseline IOPS}. Baseline IOPS = min{1,800 + 50 × Capacity, 50,000}. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
     */
    @JvmName("jmowceafecdbeawl")
    public suspend fun systemDiskProvisionedIops(`value`: Output<Int>) {
        this.systemDiskProvisionedIops = value
    }

    /**
     * @param value The system disk category of worker node. Its valid value range [40~500] in GB. Default to `120`.
     */
    @JvmName("xpithtvylhinaklk")
    public suspend fun systemDiskSize(`value`: Output<Int>) {
        this.systemDiskSize = value
    }

    /**
     * @param value The ID of the automatic snapshot policy used by the system disk.
     */
    @JvmName("bguaosqxrvjpmist")
    public suspend fun systemDiskSnapshotPolicyId(`value`: Output<String>) {
        this.systemDiskSnapshotPolicyId = value
    }

    /**
     * @param value Add tags only for ECS instances. The maximum length of the tag key is 128 characters. The tag key and value cannot start with aliyun or acs:, or contain https:// or http://".
     */
    @JvmName("vralbrssxuoxlkvp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
     */
    @JvmName("tbplswocnywnbesa")
    public suspend fun taints(`value`: Output<List<NodePoolTaintArgs>>) {
        this.taints = value
    }

    @JvmName("meowvctswtdissfq")
    public suspend fun taints(vararg values: Output<NodePoolTaintArgs>) {
        this.taints = Output.all(values.asList())
    }

    /**
     * @param values A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
     */
    @JvmName("bsskeyblnydbxyat")
    public suspend fun taints(values: List<Output<NodePoolTaintArgs>>) {
        this.taints = Output.all(values)
    }

    /**
     * @param value The configuration about confidential computing for the cluster. See `tee_config` below.
     */
    @JvmName("awkwxliasgoruebp")
    public suspend fun teeConfig(`value`: Output<NodePoolTeeConfigArgs>) {
        this.teeConfig = value
    }

    /**
     * @param value Whether the node after expansion can be scheduled.
     */
    @JvmName("gsjfrosjkbtmkxcn")
    public suspend fun unschedulable(`value`: Output<Boolean>) {
        this.unschedulable = value
    }

    /**
     * @param value Synchronously update node labels and taints.
     */
    @JvmName("okyhcygtasrlnlul")
    public suspend fun updateNodes(`value`: Output<Boolean>) {
        this.updateNodes = value
    }

    /**
     * @param value Node custom data.
     */
    @JvmName("eigothealbefvhoi")
    public suspend fun userData(`value`: Output<String>) {
        this.userData = value
    }

    /**
     * @param value The vswitches used by node pool workers.
     */
    @JvmName("unkpljsastmvyiwl")
    public suspend fun vswitchIds(`value`: Output<List<String>>) {
        this.vswitchIds = value
    }

    @JvmName("inoryrpccurxykos")
    public suspend fun vswitchIds(vararg values: Output<String>) {
        this.vswitchIds = Output.all(values.asList())
    }

    /**
     * @param values The vswitches used by node pool workers.
     */
    @JvmName("gqkqlnrbhupbxjkh")
    public suspend fun vswitchIds(values: List<Output<String>>) {
        this.vswitchIds = Output.all(values)
    }

    /**
     * @param value Whether to enable automatic renewal for nodes in the node pool takes effect only when `instance_charge_type` is set to `PrePaid`. Default value: `false`. Valid values:
     */
    @JvmName("dqrvtyduixupvcrs")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value The automatic renewal period of nodes in the node pool takes effect only when you select Prepaid and Automatic Renewal, and is a required value. When `PeriodUnit = Month`, the value range is {1, 2, 3, 6, 12}. Default value: 1.
     */
    @JvmName("kbxiosyncnwnexqq")
    public suspend fun autoRenewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriod = mapped
    }

    /**
     * @param value Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. Use `security_hardening_os` instead.
     */
    @Deprecated(
        message = """
  Field 'cis_enabled' has been deprecated from provider version 1.223.1. Whether enable worker node
      to support cis security reinforcement, its valid value `true` or `false`. Default to `false`
      and apply to AliyunLinux series. Use `security_hardening_os` instead.
  """,
    )
    @JvmName("iokwveknayduajah")
    public suspend fun cisEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cisEnabled = mapped
    }

    /**
     * @param value The id of kubernetes cluster.
     */
    @JvmName("hkncfhbekdtsdfan")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value Specifies whether to automatically create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created due to reasons such as cost or insufficient inventory. This parameter takes effect when you set `multi_az_policy` to `COST_OPTIMIZED`. Valid values: `true`: automatically creates pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created. `false`: does not create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created.
     */
    @JvmName("mbtmkfspbrvaexob")
    public suspend fun compensateWithOnDemand(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compensateWithOnDemand = mapped
    }

    /**
     * @param value Node CPU management policies. Default value: `none`. When the cluster version is 1.12.6 or later, the following two policies are supported:
     */
    @JvmName("uayokkypifvctktk")
    public suspend fun cpuPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuPolicy = mapped
    }

    /**
     * @param value Configure the data disk of the node in the node pool. See `data_disks` below.
     */
    @JvmName("mocqjhjxjctmessc")
    public suspend fun dataDisks(`value`: List<NodePoolDataDiskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param argument Configure the data disk of the node in the node pool. See `data_disks` below.
     */
    @JvmName("cnstrthhfuihlgfh")
    public suspend fun dataDisks(argument: List<suspend NodePoolDataDiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NodePoolDataDiskArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument Configure the data disk of the node in the node pool. See `data_disks` below.
     */
    @JvmName("vxfqpbdcsbvlkfml")
    public suspend fun dataDisks(vararg argument: suspend NodePoolDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NodePoolDataDiskArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument Configure the data disk of the node in the node pool. See `data_disks` below.
     */
    @JvmName("ygkrqwragpgauteu")
    public suspend fun dataDisks(argument: suspend NodePoolDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NodePoolDataDiskArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param values Configure the data disk of the node in the node pool. See `data_disks` below.
     */
    @JvmName("jlgqnuocedvlmhfj")
    public suspend fun dataDisks(vararg values: NodePoolDataDiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param value The deployment set of node pool. Specify the deploymentSet to ensure that the nodes in the node pool can be distributed on different physical machines.
     */
    @JvmName("pqydfplhmgwsmqdu")
    public suspend fun deploymentSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentSetId = mapped
    }

    /**
     * @param value Number of expected nodes in the node pool.
     */
    @JvmName("fqwymteesendcefk")
    public suspend fun desiredSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredSize = mapped
    }

    /**
     * @param value Whether to force deletion.
     */
    @JvmName("lmcucpegqqwjghdl")
    public suspend fun forceDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDelete = mapped
    }

    /**
     * @param value After you select this check box, if data disks have been attached to the specified ECS instances and the file system of the last data disk is uninitialized, the system automatically formats the last data disk to ext4 and mounts the data disk to /var/lib/docker and /var/lib/kubelet. The original data on the disk will be cleared. Make sure that you back up data in advance. If no data disk is mounted on the ECS instance, no new data disk will be purchased. Default is `false`.
     */
    @JvmName("wjogerpeycpypgya")
    public suspend fun formatDisk(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.formatDisk = mapped
    }

    /**
     * @param value The custom image ID. The system-provided image is used by default.
     */
    @JvmName("fbidhujyyhrddiyj")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value The operating system image type and the `platform` parameter can be selected from the following values:
     * - `AliyunLinux` : Alinux2 image.
     * - `AliyunLinux3` : Alinux3 image.
     * - `AliyunLinux3Arm64` : Alinux3 mirror ARM version.
     * - `AliyunLinuxUEFI` : Alinux2 Image UEFI version.
     * - `CentOS` : CentOS image.
     * - `Windows` : Windows image.
     * - `WindowsCore` : WindowsCore image.
     * - `ContainerOS` : container-optimized image.
     */
    @JvmName("yokvbmgdfvdbgkgo")
    public suspend fun imageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageType = mapped
    }

    /**
     * @param value Whether to install cloud monitoring on the ECS node. After installation, you can view the monitoring information of the created ECS instance in the cloud monitoring console and recommend enable it. Default value: `false`. Valid values:
     */
    @JvmName("yyxpktynvsccijxu")
    public suspend fun installCloudMonitor(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.installCloudMonitor = mapped
    }

    /**
     * @param value Node payment type. Valid values: `PostPaid`, `PrePaid`, default is `PostPaid`. If value is `PrePaid`, the arguments `period`, `period_unit`, `auto_renew` and `auto_renew_period` are required.
     */
    @JvmName("enmvuggrypsjfafs")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceChargeType = mapped
    }

    /**
     * @param value In the node instance specification list, you can select multiple instance specifications as alternatives. When each node is created, it will try to purchase from the first specification until it is created successfully. The final purchased instance specifications may vary with inventory changes.
     */
    @JvmName("qauexgoiyavjhpbu")
    public suspend fun instanceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceTypes = mapped
    }

    /**
     * @param values In the node instance specification list, you can select multiple instance specifications as alternatives. When each node is created, it will try to purchase from the first specification until it is created successfully. The final purchased instance specifications may vary with inventory changes.
     */
    @JvmName("gpsgdeytdilksuco")
    public suspend fun instanceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceTypes = mapped
    }

    /**
     * @param value The instance list. Add existing nodes under the same cluster VPC to the node pool.
     */
    @JvmName("bkpfgxcuinvgxbob")
    public suspend fun instances(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param values The instance list. Add existing nodes under the same cluster VPC to the node pool.
     */
    @JvmName("qvvaeabsakytgieu")
    public suspend fun instances(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param value The billing method for network usage. Valid values `PayByBandwidth` and `PayByTraffic`. Conflict with `eip_internet_charge_type`, EIP and public network IP can only choose one.
     */
    @JvmName("wdlcqjhivcadpftt")
    public suspend fun internetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetChargeType = mapped
    }

    /**
     * @param value The maximum bandwidth of the public IP address of the node. The unit is Mbps(Mega bit per second). The value range is:\[1,100\]
     */
    @JvmName("eivfurbkchggbchg")
    public suspend fun internetMaxBandwidthOut(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetMaxBandwidthOut = mapped
    }

    /**
     * @param value Add an existing instance to the node pool, whether to keep the original instance name. It is recommended to set to `true`.
     */
    @JvmName("datbjniaiawkumqc")
    public suspend fun keepInstanceName(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keepInstanceName = mapped
    }

    /**
     * @param value The name of the key pair. When the node pool is a managed node pool, only `key_name` is supported.
     */
    @JvmName("blvjbhsriigkwlcx")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
     */
    @JvmName("ciopcajkyopcyxnn")
    public suspend fun kmsEncryptedPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptedPassword = mapped
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("bwdyqqnnnhgqmghw")
    public suspend fun kmsEncryptionContext(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param values An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("vetiubxqmpokenmt")
    public fun kmsEncryptionContext(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param value Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/). See `kubelet_configuration` below.
     */
    @JvmName("qcqovxqauknirmsp")
    public suspend fun kubeletConfiguration(`value`: NodePoolKubeletConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubeletConfiguration = mapped
    }

    /**
     * @param argument Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/). See `kubelet_configuration` below.
     */
    @JvmName("qixpedqycafscgui")
    public suspend fun kubeletConfiguration(argument: suspend NodePoolKubeletConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = NodePoolKubeletConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kubeletConfiguration = mapped
    }

    /**
     * @param value A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
     */
    @JvmName("yjfxdokoknlydviq")
    public suspend fun labels(`value`: List<NodePoolLabelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param argument A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
     */
    @JvmName("bvblhiyaqojdkdps")
    public suspend fun labels(argument: List<suspend NodePoolLabelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NodePoolLabelArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param argument A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
     */
    @JvmName("usrplbenwmjtygep")
    public suspend fun labels(vararg argument: suspend NodePoolLabelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NodePoolLabelArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param argument A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
     */
    @JvmName("jjfpypgnwhjcvrtk")
    public suspend fun labels(argument: suspend NodePoolLabelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NodePoolLabelArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param values A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
     */
    @JvmName("bvxuoderlangnqfx")
    public suspend fun labels(vararg values: NodePoolLabelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value Whether the ECS instance is logged on as a ecs-user user. Valid value: `true` and `false`.
     */
    @JvmName("ubnqmwtnprxxhwkr")
    public suspend fun loginAsNonRoot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginAsNonRoot = mapped
    }

    /**
     * @param value Managed node pool configuration. See `management` below.
     */
    @JvmName("olbkvwkvvymoiwts")
    public suspend fun management(`value`: NodePoolManagementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.management = mapped
    }

    /**
     * @param argument Managed node pool configuration. See `management` below.
     */
    @JvmName("kiihueyjddveepng")
    public suspend fun management(argument: suspend NodePoolManagementArgsBuilder.() -> Unit) {
        val toBeMapped = NodePoolManagementArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.management = mapped
    }

    /**
     * @param value The scaling policy for ECS instances in a multi-zone scaling group. Valid value: `PRIORITY`, `COST_OPTIMIZED` and `BALANCE`. `PRIORITY`: scales the capacity according to the virtual switches you define (VSwitchIds.N). When an ECS instance cannot be created in the zone where the higher-priority vSwitch is located, the next-priority vSwitch is automatically used to create an ECS instance. `COST_OPTIMIZED`: try to create by vCPU unit price from low to high. When the scaling configuration is configured with multiple instances of preemptible billing, preemptible instances are created first. You can continue to use the `CompensateWithOnDemand` parameter to specify whether to automatically try to create a preemptible instance by paying for it. It takes effect only when the scaling configuration has multi-instance specifications or preemptible instances. `BALANCE`: distributes ECS instances evenly among the multi-zone specified by the scaling group. If the zones become unbalanced due to insufficient inventory, you can use the API RebalanceInstances to balance resources.
     */
    @JvmName("dqfgeiveqtujgngg")
    public suspend fun multiAzPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiAzPolicy = mapped
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.219.0. New field 'node_pool_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.219.0. New field 'node_pool_name'
      instead.
  """,
    )
    @JvmName("pmulhyessiqvjwdx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The worker node number of the node pool. From version 1.111.0, `node_count` is not required.
     */
    @Deprecated(
        message = """
  Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size'
      instead.
  """,
    )
    @JvmName("gcbifkjtckvmtsrx")
    public suspend fun nodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeCount = mapped
    }

    /**
     * @param value Each node name consists of a prefix, its private network IP, and a suffix, separated by commas. The input format is `customized,,ip,`.
     * - The prefix and suffix can be composed of one or more parts separated by '.', each part can use lowercase letters, numbers and '-', and the beginning and end of the node name must be lowercase letters and numbers.
     * - The node IP address is the complete private IP address of the node.
     * - For example, if the string `customized,aliyun,ip,com` is passed in (where 'customized' and 'ip' are fixed strings, 'aliyun' is the prefix, and 'com' is the suffix), the name of the node is `aliyun192.168.xxx.xxxcom`.
     */
    @JvmName("ftcdpcdchiqpqloo")
    public suspend fun nodeNameMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeNameMode = mapped
    }

    /**
     * @param value The name of node pool.
     */
    @JvmName("bnwjbfddekugsxam")
    public suspend fun nodePoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodePoolName = mapped
    }

    /**
     * @param value The minimum number of pay-as-you-go instances that must be kept in the scaling group. Valid values: 0 to 1000. If the number of pay-as-you-go instances is less than the value of this parameter, Auto Scaling preferably creates pay-as-you-go instances.
     */
    @JvmName("xjnbdhvvsofkkgwg")
    public suspend fun onDemandBaseCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemandBaseCapacity = mapped
    }

    /**
     * @param value The percentage of pay-as-you-go instances among the extra instances that exceed the number specified by `on_demand_base_capacity`. Valid values: 0 to 100.
     */
    @JvmName("crgnsqihyprtcmxb")
    public suspend fun onDemandPercentageAboveBaseCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemandPercentageAboveBaseCapacity = mapped
    }

    /**
     * @param value The password of ssh login. You have to specify one of `password` and `key_name` fields. The password rule is 8 to 30 characters and contains at least three items (upper and lower case letters, numbers, and special symbols).
     */
    @JvmName("qlgpbtsesnupydtv")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Node payment period. Its valid value is one of {1, 2, 3, 6, 12}.
     */
    @JvmName("lrbqoijmkufihyak")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value Node payment period unit, valid value: `Month`. Default is `Month`.
     */
    @JvmName("djcpksktetrdmkge")
    public suspend fun periodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodUnit = mapped
    }

    /**
     * @param value Operating system release, using `image_type` instead.
     */
    @Deprecated(
        message = """
  Field 'platform' has been deprecated from provider version 1.145.0. Operating system release,
      using `image_type` instead.
  """,
    )
    @JvmName("imekaxhjqtdexcrs")
    public suspend fun platform(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param value Private node pool configuration. See `private_pool_options` below.
     */
    @JvmName("ifxnisrlkrqotuam")
    public suspend fun privatePoolOptions(`value`: NodePoolPrivatePoolOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privatePoolOptions = mapped
    }

    /**
     * @param argument Private node pool configuration. See `private_pool_options` below.
     */
    @JvmName("acfiocdrsvopebad")
    public suspend fun privatePoolOptions(argument: suspend NodePoolPrivatePoolOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = NodePoolPrivatePoolOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privatePoolOptions = mapped
    }

    /**
     * @param value The list of RDS instances.
     */
    @JvmName("ibkramswrgofvirn")
    public suspend fun rdsInstances(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rdsInstances = mapped
    }

    /**
     * @param values The list of RDS instances.
     */
    @JvmName("iwgrkdaopptipqmf")
    public suspend fun rdsInstances(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rdsInstances = mapped
    }

    /**
     * @param value The ID of the resource group
     */
    @JvmName("mdhafyafxixtprif")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Rotary configuration. See `rolling_policy` below.
     */
    @JvmName("mysxvxxcanwlcyhd")
    public suspend fun rollingPolicy(`value`: NodePoolRollingPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rollingPolicy = mapped
    }

    /**
     * @param argument Rotary configuration. See `rolling_policy` below.
     */
    @JvmName("jhuyupvyficpixho")
    public suspend fun rollingPolicy(argument: suspend NodePoolRollingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = NodePoolRollingPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rollingPolicy = mapped
    }

    /**
     * @param value The runtime name of containers. If not set, the cluster runtime will be used as the node pool runtime. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm).
     */
    @JvmName("bfdihbchjwjslivk")
    public suspend fun runtimeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeName = mapped
    }

    /**
     * @param value The runtime version of containers. If not set, the cluster runtime will be used as the node pool runtime.
     */
    @JvmName("fragarmldboujtrj")
    public suspend fun runtimeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeVersion = mapped
    }

    /**
     * @param value Automatic scaling configuration. See `scaling_config` below.
     */
    @JvmName("rbaqrsbcoyflxkfx")
    public suspend fun scalingConfig(`value`: NodePoolScalingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingConfig = mapped
    }

    /**
     * @param argument Automatic scaling configuration. See `scaling_config` below.
     */
    @JvmName("lyheeqkydaswohvo")
    public suspend fun scalingConfig(argument: suspend NodePoolScalingConfigArgsBuilder.() -> Unit) {
        val toBeMapped = NodePoolScalingConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scalingConfig = mapped
    }

    /**
     * @param value Scaling group mode, default value: `release`. Valid values:
     */
    @JvmName("gncwinjeboucwuff")
    public suspend fun scalingPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingPolicy = mapped
    }

    /**
     * @param value The security group ID of the node pool. This field has been replaced by `security_group_ids`, please use the `security_group_ids` field instead.
     */
    @Deprecated(
        message = """
  Field 'security_group_id' has been deprecated from provider version 1.145.0. The security group ID
      of the node pool. This field has been replaced by `security_group_ids`, please use the
      `security_group_ids` field instead.
  """,
    )
    @JvmName("xmqsexmawxrfgoha")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
     */
    @JvmName("ovocvkgjhyekfsdh")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
     */
    @JvmName("wxwaxqsoablqjaph")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value Alibaba Cloud OS security reinforcement. Default value: `false`. Value:
     */
    @JvmName("anqunqjkydatuqhq")
    public suspend fun securityHardeningOs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityHardeningOs = mapped
    }

    /**
     * @param value Whether enable worker node to support soc security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [SOC Reinforcement](https://help.aliyun.com/document_detail/196148.html).
     * > **NOTE:**  It is forbidden to set both `security_hardening_os` and `soc_enabled` to `true` at the same time.
     */
    @JvmName("nrvrhkbqqfdokvgl")
    public suspend fun socEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.socEnabled = mapped
    }

    /**
     * @param value The number of instance types that are available. Auto Scaling creates preemptible instances of multiple instance types that are available at the lowest cost. Valid values: 1 to 10.
     */
    @JvmName("ayifwlchlosyvubw")
    public suspend fun spotInstancePools(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotInstancePools = mapped
    }

    /**
     * @param value Specifies whether to supplement preemptible instances when the number of preemptible instances drops below the specified minimum number. If you set the value to true, Auto Scaling attempts to create a new preemptible instance when the system notifies that an existing preemptible instance is about to be reclaimed. Valid values: `true`: enables the supplementation of preemptible instances. `false`: disables the supplementation of preemptible instances.
     */
    @JvmName("qbmnlodiurgxoeos")
    public suspend fun spotInstanceRemedy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotInstanceRemedy = mapped
    }

    /**
     * @param value The current single preemptible instance type market price range configuration. See `spot_price_limit` below.
     */
    @JvmName("dglxderujyabbbma")
    public suspend fun spotPriceLimits(`value`: List<NodePoolSpotPriceLimitArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotPriceLimits = mapped
    }

    /**
     * @param argument The current single preemptible instance type market price range configuration. See `spot_price_limit` below.
     */
    @JvmName("qhoaqcareaebrdtk")
    public suspend fun spotPriceLimits(argument: List<suspend NodePoolSpotPriceLimitArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NodePoolSpotPriceLimitArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.spotPriceLimits = mapped
    }

    /**
     * @param argument The current single preemptible instance type market price range configuration. See `spot_price_limit` below.
     */
    @JvmName("mbvsabfavmpkroox")
    public suspend fun spotPriceLimits(vararg argument: suspend NodePoolSpotPriceLimitArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NodePoolSpotPriceLimitArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.spotPriceLimits = mapped
    }

    /**
     * @param argument The current single preemptible instance type market price range configuration. See `spot_price_limit` below.
     */
    @JvmName("hadiryvnvgecupqs")
    public suspend fun spotPriceLimits(argument: suspend NodePoolSpotPriceLimitArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NodePoolSpotPriceLimitArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.spotPriceLimits = mapped
    }

    /**
     * @param values The current single preemptible instance type market price range configuration. See `spot_price_limit` below.
     */
    @JvmName("yyfiqiewlnirixvh")
    public suspend fun spotPriceLimits(vararg values: NodePoolSpotPriceLimitArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.spotPriceLimits = mapped
    }

    /**
     * @param value The preemptible instance type. Value:
     * - `NoSpot` : Non-preemptible instance.
     * - `SpotWithPriceLimit` : Set the upper limit of the preemptible instance price.
     * - `SpotAsPriceGo` : The system automatically bids, following the actual price of the current market.
     */
    @JvmName("fjvjnibfqvmsvuvw")
    public suspend fun spotStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotStrategy = mapped
    }

    /**
     * @param value Specifies whether to enable the burst feature for system disks. Valid values:`true`: enables the burst feature. `false`: disables the burst feature. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
     */
    @JvmName("uvrklvupsuxqjquv")
    public suspend fun systemDiskBurstingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskBurstingEnabled = mapped
    }

    /**
     * @param value The multi-disk categories of the system disk. When a high-priority disk type cannot be used, Auto Scaling automatically tries to create a system disk with the next priority disk category. Valid values: `cloud`: cloud disk. `cloud_efficiency`: a high-efficiency cloud disk. `cloud_ssd`:SSD cloud disk. `cloud_essd`: ESSD cloud disk.
     */
    @JvmName("otjlqeedxwbfrlpk")
    public suspend fun systemDiskCategories(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskCategories = mapped
    }

    /**
     * @param values The multi-disk categories of the system disk. When a high-priority disk type cannot be used, Auto Scaling automatically tries to create a system disk with the next priority disk category. Valid values: `cloud`: cloud disk. `cloud_efficiency`: a high-efficiency cloud disk. `cloud_ssd`:SSD cloud disk. `cloud_essd`: ESSD cloud disk.
     */
    @JvmName("kotingtduqtcihje")
    public suspend fun systemDiskCategories(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.systemDiskCategories = mapped
    }

    /**
     * @param value The system disk category of worker node. Its valid value are `cloud_ssd`, `cloud_efficiency`, `cloud_essd` and `cloud_auto`.
     */
    @JvmName("qtostvbskpkyhbtj")
    public suspend fun systemDiskCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskCategory = mapped
    }

    /**
     * @param value The encryption algorithm used by the system disk. Value range: aes-256.
     */
    @JvmName("lwrpdmhnnqwxfrfk")
    public suspend fun systemDiskEncryptAlgorithm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskEncryptAlgorithm = mapped
    }

    /**
     * @param value Whether to encrypt the system disk. Value range: `true`: encryption. `false`: Do not encrypt.
     */
    @JvmName("ekfbbaljxlnwpmdy")
    public suspend fun systemDiskEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskEncrypted = mapped
    }

    /**
     * @param value The ID of the KMS key used by the system disk.
     */
    @JvmName("tsmxdrxcakirufhd")
    public suspend fun systemDiskKmsKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskKmsKey = mapped
    }

    /**
     * @param value The system disk performance of the node takes effect only for the ESSD disk.
     * - `PL0`: maximum random read/write IOPS 10000 for a single disk.
     * - `PL1`: maximum random read/write IOPS 50000 for a single disk.
     * - `PL2`: highest random read/write IOPS 100000 for a single disk.
     * - `PL3`: maximum random read/write IOPS 1 million for a single disk.
     */
    @JvmName("djhnktpctmkrnylw")
    public suspend fun systemDiskPerformanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskPerformanceLevel = mapped
    }

    /**
     * @param value The predefined IOPS of a system disk. Valid values: 0 to min{50,000, 1,000 × Capacity - Baseline IOPS}. Baseline IOPS = min{1,800 + 50 × Capacity, 50,000}. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
     */
    @JvmName("dyfisivojgjdedwq")
    public suspend fun systemDiskProvisionedIops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskProvisionedIops = mapped
    }

    /**
     * @param value The system disk category of worker node. Its valid value range [40~500] in GB. Default to `120`.
     */
    @JvmName("rwfqlxbwkomkwnyo")
    public suspend fun systemDiskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskSize = mapped
    }

    /**
     * @param value The ID of the automatic snapshot policy used by the system disk.
     */
    @JvmName("xuxvqphfiuruclid")
    public suspend fun systemDiskSnapshotPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskSnapshotPolicyId = mapped
    }

    /**
     * @param value Add tags only for ECS instances. The maximum length of the tag key is 128 characters. The tag key and value cannot start with aliyun or acs:, or contain https:// or http://".
     */
    @JvmName("gbsvmpvauidvidbv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Add tags only for ECS instances. The maximum length of the tag key is 128 characters. The tag key and value cannot start with aliyun or acs:, or contain https:// or http://".
     */
    @JvmName("bvqnmitxdiqmxltg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
     */
    @JvmName("emgltpshyqlsdcnu")
    public suspend fun taints(`value`: List<NodePoolTaintArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taints = mapped
    }

    /**
     * @param argument A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
     */
    @JvmName("qpswloufktudyvks")
    public suspend fun taints(argument: List<suspend NodePoolTaintArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NodePoolTaintArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.taints = mapped
    }

    /**
     * @param argument A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
     */
    @JvmName("rwrwynryclyhjwri")
    public suspend fun taints(vararg argument: suspend NodePoolTaintArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NodePoolTaintArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.taints = mapped
    }

    /**
     * @param argument A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
     */
    @JvmName("nqubulijwxvihbih")
    public suspend fun taints(argument: suspend NodePoolTaintArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NodePoolTaintArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.taints = mapped
    }

    /**
     * @param values A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
     */
    @JvmName("xfhyxtjuhstvexyn")
    public suspend fun taints(vararg values: NodePoolTaintArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taints = mapped
    }

    /**
     * @param value The configuration about confidential computing for the cluster. See `tee_config` below.
     */
    @JvmName("jcbwwgnympusmhjc")
    public suspend fun teeConfig(`value`: NodePoolTeeConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.teeConfig = mapped
    }

    /**
     * @param argument The configuration about confidential computing for the cluster. See `tee_config` below.
     */
    @JvmName("sryhkcakpypfjmoo")
    public suspend fun teeConfig(argument: suspend NodePoolTeeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = NodePoolTeeConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.teeConfig = mapped
    }

    /**
     * @param value Whether the node after expansion can be scheduled.
     */
    @JvmName("jkwlsrhcogbcxhxr")
    public suspend fun unschedulable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unschedulable = mapped
    }

    /**
     * @param value Synchronously update node labels and taints.
     */
    @JvmName("kpqlcixbgngriyay")
    public suspend fun updateNodes(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateNodes = mapped
    }

    /**
     * @param value Node custom data.
     */
    @JvmName("dwvtnyxuyrgwceld")
    public suspend fun userData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userData = mapped
    }

    /**
     * @param value The vswitches used by node pool workers.
     */
    @JvmName("oswmwlkmpekxariy")
    public suspend fun vswitchIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchIds = mapped
    }

    /**
     * @param values The vswitches used by node pool workers.
     */
    @JvmName("lwwlvuiqbqijqeng")
    public suspend fun vswitchIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitchIds = mapped
    }

    internal fun build(): NodePoolArgs = NodePoolArgs(
        autoRenew = autoRenew,
        autoRenewPeriod = autoRenewPeriod,
        cisEnabled = cisEnabled,
        clusterId = clusterId,
        compensateWithOnDemand = compensateWithOnDemand,
        cpuPolicy = cpuPolicy,
        dataDisks = dataDisks,
        deploymentSetId = deploymentSetId,
        desiredSize = desiredSize,
        forceDelete = forceDelete,
        formatDisk = formatDisk,
        imageId = imageId,
        imageType = imageType,
        installCloudMonitor = installCloudMonitor,
        instanceChargeType = instanceChargeType,
        instanceTypes = instanceTypes,
        instances = instances,
        internetChargeType = internetChargeType,
        internetMaxBandwidthOut = internetMaxBandwidthOut,
        keepInstanceName = keepInstanceName,
        keyName = keyName,
        kmsEncryptedPassword = kmsEncryptedPassword,
        kmsEncryptionContext = kmsEncryptionContext,
        kubeletConfiguration = kubeletConfiguration,
        labels = labels,
        loginAsNonRoot = loginAsNonRoot,
        management = management,
        multiAzPolicy = multiAzPolicy,
        name = name,
        nodeCount = nodeCount,
        nodeNameMode = nodeNameMode,
        nodePoolName = nodePoolName,
        onDemandBaseCapacity = onDemandBaseCapacity,
        onDemandPercentageAboveBaseCapacity = onDemandPercentageAboveBaseCapacity,
        password = password,
        period = period,
        periodUnit = periodUnit,
        platform = platform,
        privatePoolOptions = privatePoolOptions,
        rdsInstances = rdsInstances,
        resourceGroupId = resourceGroupId,
        rollingPolicy = rollingPolicy,
        runtimeName = runtimeName,
        runtimeVersion = runtimeVersion,
        scalingConfig = scalingConfig,
        scalingPolicy = scalingPolicy,
        securityGroupId = securityGroupId,
        securityGroupIds = securityGroupIds,
        securityHardeningOs = securityHardeningOs,
        socEnabled = socEnabled,
        spotInstancePools = spotInstancePools,
        spotInstanceRemedy = spotInstanceRemedy,
        spotPriceLimits = spotPriceLimits,
        spotStrategy = spotStrategy,
        systemDiskBurstingEnabled = systemDiskBurstingEnabled,
        systemDiskCategories = systemDiskCategories,
        systemDiskCategory = systemDiskCategory,
        systemDiskEncryptAlgorithm = systemDiskEncryptAlgorithm,
        systemDiskEncrypted = systemDiskEncrypted,
        systemDiskKmsKey = systemDiskKmsKey,
        systemDiskPerformanceLevel = systemDiskPerformanceLevel,
        systemDiskProvisionedIops = systemDiskProvisionedIops,
        systemDiskSize = systemDiskSize,
        systemDiskSnapshotPolicyId = systemDiskSnapshotPolicyId,
        tags = tags,
        taints = taints,
        teeConfig = teeConfig,
        unschedulable = unschedulable,
        updateNodes = updateNodes,
        userData = userData,
        vswitchIds = vswitchIds,
    )
}
