@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.RegistryEnterpriseNamespaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This resource will help you to manager Container Registry Enterprise Edition namespaces.
 * For information about Container Registry Enterprise Edition namespaces and how to use it, see [Create a Namespace](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createnamespace)
 * > **NOTE:** Available since v1.86.0.
 * > **NOTE:** You need to set your registry password in Container Registry Enterprise Edition console before use this resource.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example-name";
 * const example = new alicloud.cr.RegistryEnterpriseInstance("example", {
 *     paymentType: "Subscription",
 *     period: 1,
 *     renewPeriod: 0,
 *     renewalStatus: "ManualRenewal",
 *     instanceType: "Advanced",
 *     instanceName: name,
 * });
 * const exampleRegistryEnterpriseNamespace = new alicloud.cs.RegistryEnterpriseNamespace("example", {
 *     instanceId: example.id,
 *     name: name,
 *     autoCreate: false,
 *     defaultVisibility: "PUBLIC",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example-name"
 * example = alicloud.cr.RegistryEnterpriseInstance("example",
 *     payment_type="Subscription",
 *     period=1,
 *     renew_period=0,
 *     renewal_status="ManualRenewal",
 *     instance_type="Advanced",
 *     instance_name=name)
 * example_registry_enterprise_namespace = alicloud.cs.RegistryEnterpriseNamespace("example",
 *     instance_id=example.id,
 *     name=name,
 *     auto_create=False,
 *     default_visibility="PUBLIC")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example-name";
 *     var example = new AliCloud.CR.RegistryEnterpriseInstance("example", new()
 *     {
 *         PaymentType = "Subscription",
 *         Period = 1,
 *         RenewPeriod = 0,
 *         RenewalStatus = "ManualRenewal",
 *         InstanceType = "Advanced",
 *         InstanceName = name,
 *     });
 *     var exampleRegistryEnterpriseNamespace = new AliCloud.CS.RegistryEnterpriseNamespace("example", new()
 *     {
 *         InstanceId = example.Id,
 *         Name = name,
 *         AutoCreate = false,
 *         DefaultVisibility = "PUBLIC",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example-name"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := cr.NewRegistryEnterpriseInstance(ctx, "example", &cr.RegistryEnterpriseInstanceArgs{
 * 			PaymentType:   pulumi.String("Subscription"),
 * 			Period:        pulumi.Int(1),
 * 			RenewPeriod:   pulumi.Int(0),
 * 			RenewalStatus: pulumi.String("ManualRenewal"),
 * 			InstanceType:  pulumi.String("Advanced"),
 * 			InstanceName:  pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cs.NewRegistryEnterpriseNamespace(ctx, "example", &cs.RegistryEnterpriseNamespaceArgs{
 * 			InstanceId:        example.ID(),
 * 			Name:              pulumi.String(name),
 * 			AutoCreate:        pulumi.Bool(false),
 * 			DefaultVisibility: pulumi.String("PUBLIC"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstance;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstanceArgs;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseNamespace;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseNamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example-name");
 *         var example = new RegistryEnterpriseInstance("example", RegistryEnterpriseInstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .period(1)
 *             .renewPeriod(0)
 *             .renewalStatus("ManualRenewal")
 *             .instanceType("Advanced")
 *             .instanceName(name)
 *             .build());
 *         var exampleRegistryEnterpriseNamespace = new RegistryEnterpriseNamespace("exampleRegistryEnterpriseNamespace", RegistryEnterpriseNamespaceArgs.builder()
 *             .instanceId(example.id())
 *             .name(name)
 *             .autoCreate(false)
 *             .defaultVisibility("PUBLIC")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example-name
 * resources:
 *   example:
 *     type: alicloud:cr:RegistryEnterpriseInstance
 *     properties:
 *       paymentType: Subscription
 *       period: 1
 *       renewPeriod: 0
 *       renewalStatus: ManualRenewal
 *       instanceType: Advanced
 *       instanceName: ${name}
 *   exampleRegistryEnterpriseNamespace:
 *     type: alicloud:cs:RegistryEnterpriseNamespace
 *     name: example
 *     properties:
 *       instanceId: ${example.id}
 *       name: ${name}
 *       autoCreate: false
 *       defaultVisibility: PUBLIC
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Container Registry Enterprise Edition namespace can be imported using the `{instance_id}:{namespace}`, e.g.
 * ```sh
 * $ pulumi import alicloud:cs/registryEnterpriseNamespace:RegistryEnterpriseNamespace default cri-xxx:my-namespace
 * ```
 * @property autoCreate Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
 * @property defaultVisibility `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
 * @property instanceId ID of Container Registry Enterprise Edition instance.
 * @property name Name of Container Registry Enterprise Edition namespace. It can contain 2 to 30 characters.
 */
public data class RegistryEnterpriseNamespaceArgs(
    public val autoCreate: Output<Boolean>? = null,
    public val defaultVisibility: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.RegistryEnterpriseNamespaceArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.RegistryEnterpriseNamespaceArgs =
        com.pulumi.alicloud.cs.RegistryEnterpriseNamespaceArgs.builder()
            .autoCreate(autoCreate?.applyValue({ args0 -> args0 }))
            .defaultVisibility(defaultVisibility?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryEnterpriseNamespaceArgs].
 */
@PulumiTagMarker
public class RegistryEnterpriseNamespaceArgsBuilder internal constructor() {
    private var autoCreate: Output<Boolean>? = null

    private var defaultVisibility: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
     */
    @JvmName("sqappitbystlvord")
    public suspend fun autoCreate(`value`: Output<Boolean>) {
        this.autoCreate = value
    }

    /**
     * @param value `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
     */
    @JvmName("gxhyguesltcvyiym")
    public suspend fun defaultVisibility(`value`: Output<String>) {
        this.defaultVisibility = value
    }

    /**
     * @param value ID of Container Registry Enterprise Edition instance.
     */
    @JvmName("lxwunbyvxhbowmep")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Name of Container Registry Enterprise Edition namespace. It can contain 2 to 30 characters.
     */
    @JvmName("ckyhbswhvdrxroku")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
     */
    @JvmName("ocecdfxtqqcohkcd")
    public suspend fun autoCreate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoCreate = mapped
    }

    /**
     * @param value `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
     */
    @JvmName("tigurqtvrxcbudvp")
    public suspend fun defaultVisibility(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultVisibility = mapped
    }

    /**
     * @param value ID of Container Registry Enterprise Edition instance.
     */
    @JvmName("wrarvabadefjfetx")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Name of Container Registry Enterprise Edition namespace. It can contain 2 to 30 characters.
     */
    @JvmName("hqjxksujyrbqoxcg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): RegistryEnterpriseNamespaceArgs = RegistryEnterpriseNamespaceArgs(
        autoCreate = autoCreate,
        defaultVisibility = defaultVisibility,
        instanceId = instanceId,
        name = name,
    )
}
