@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RegistryEnterpriseRepo].
 */
@PulumiTagMarker
public class RegistryEnterpriseRepoResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegistryEnterpriseRepoArgs = RegistryEnterpriseRepoArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegistryEnterpriseRepoArgsBuilder.() -> Unit) {
        val builder = RegistryEnterpriseRepoArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RegistryEnterpriseRepo {
        val builtJavaResource = com.pulumi.alicloud.cs.RegistryEnterpriseRepo(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RegistryEnterpriseRepo(builtJavaResource)
    }
}

/**
 * This resource will help you to manager Container Registry Enterprise Edition repositories.
 * For information about Container Registry Enterprise Edition repository and how to use it, see [Create a Repository](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createrepository)
 * > **NOTE:** Available since v1.86.0.
 * > **NOTE:** You need to set your registry password in Container Registry Enterprise Edition console before use this resource.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const example = new alicloud.cr.RegistryEnterpriseInstance("example", {
 *     paymentType: "Subscription",
 *     period: 1,
 *     renewPeriod: 0,
 *     renewalStatus: "ManualRenewal",
 *     instanceType: "Advanced",
 *     instanceName: name,
 * });
 * const exampleRegistryEnterpriseNamespace = new alicloud.cs.RegistryEnterpriseNamespace("example", {
 *     instanceId: example.id,
 *     name: name,
 *     autoCreate: false,
 *     defaultVisibility: "PUBLIC",
 * });
 * const exampleRegistryEnterpriseRepo = new alicloud.cs.RegistryEnterpriseRepo("example", {
 *     instanceId: example.id,
 *     namespace: exampleRegistryEnterpriseNamespace.name,
 *     name: name,
 *     summary: "this is summary of my new repo",
 *     repoType: "PUBLIC",
 *     detail: "this is a public repo",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * example = alicloud.cr.RegistryEnterpriseInstance("example",
 *     payment_type="Subscription",
 *     period=1,
 *     renew_period=0,
 *     renewal_status="ManualRenewal",
 *     instance_type="Advanced",
 *     instance_name=name)
 * example_registry_enterprise_namespace = alicloud.cs.RegistryEnterpriseNamespace("example",
 *     instance_id=example.id,
 *     name=name,
 *     auto_create=False,
 *     default_visibility="PUBLIC")
 * example_registry_enterprise_repo = alicloud.cs.RegistryEnterpriseRepo("example",
 *     instance_id=example.id,
 *     namespace=example_registry_enterprise_namespace.name,
 *     name=name,
 *     summary="this is summary of my new repo",
 *     repo_type="PUBLIC",
 *     detail="this is a public repo")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var example = new AliCloud.CR.RegistryEnterpriseInstance("example", new()
 *     {
 *         PaymentType = "Subscription",
 *         Period = 1,
 *         RenewPeriod = 0,
 *         RenewalStatus = "ManualRenewal",
 *         InstanceType = "Advanced",
 *         InstanceName = name,
 *     });
 *     var exampleRegistryEnterpriseNamespace = new AliCloud.CS.RegistryEnterpriseNamespace("example", new()
 *     {
 *         InstanceId = example.Id,
 *         Name = name,
 *         AutoCreate = false,
 *         DefaultVisibility = "PUBLIC",
 *     });
 *     var exampleRegistryEnterpriseRepo = new AliCloud.CS.RegistryEnterpriseRepo("example", new()
 *     {
 *         InstanceId = example.Id,
 *         Namespace = exampleRegistryEnterpriseNamespace.Name,
 *         Name = name,
 *         Summary = "this is summary of my new repo",
 *         RepoType = "PUBLIC",
 *         Detail = "this is a public repo",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := cr.NewRegistryEnterpriseInstance(ctx, "example", &cr.RegistryEnterpriseInstanceArgs{
 * 			PaymentType:   pulumi.String("Subscription"),
 * 			Period:        pulumi.Int(1),
 * 			RenewPeriod:   pulumi.Int(0),
 * 			RenewalStatus: pulumi.String("ManualRenewal"),
 * 			InstanceType:  pulumi.String("Advanced"),
 * 			InstanceName:  pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRegistryEnterpriseNamespace, err := cs.NewRegistryEnterpriseNamespace(ctx, "example", &cs.RegistryEnterpriseNamespaceArgs{
 * 			InstanceId:        example.ID(),
 * 			Name:              pulumi.String(name),
 * 			AutoCreate:        pulumi.Bool(false),
 * 			DefaultVisibility: pulumi.String("PUBLIC"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cs.NewRegistryEnterpriseRepo(ctx, "example", &cs.RegistryEnterpriseRepoArgs{
 * 			InstanceId: example.ID(),
 * 			Namespace:  exampleRegistryEnterpriseNamespace.Name,
 * 			Name:       pulumi.String(name),
 * 			Summary:    pulumi.String("this is summary of my new repo"),
 * 			RepoType:   pulumi.String("PUBLIC"),
 * 			Detail:     pulumi.String("this is a public repo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstance;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstanceArgs;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseNamespace;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseNamespaceArgs;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseRepo;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseRepoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var example = new RegistryEnterpriseInstance("example", RegistryEnterpriseInstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .period(1)
 *             .renewPeriod(0)
 *             .renewalStatus("ManualRenewal")
 *             .instanceType("Advanced")
 *             .instanceName(name)
 *             .build());
 *         var exampleRegistryEnterpriseNamespace = new RegistryEnterpriseNamespace("exampleRegistryEnterpriseNamespace", RegistryEnterpriseNamespaceArgs.builder()
 *             .instanceId(example.id())
 *             .name(name)
 *             .autoCreate(false)
 *             .defaultVisibility("PUBLIC")
 *             .build());
 *         var exampleRegistryEnterpriseRepo = new RegistryEnterpriseRepo("exampleRegistryEnterpriseRepo", RegistryEnterpriseRepoArgs.builder()
 *             .instanceId(example.id())
 *             .namespace(exampleRegistryEnterpriseNamespace.name())
 *             .name(name)
 *             .summary("this is summary of my new repo")
 *             .repoType("PUBLIC")
 *             .detail("this is a public repo")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   example:
 *     type: alicloud:cr:RegistryEnterpriseInstance
 *     properties:
 *       paymentType: Subscription
 *       period: 1
 *       renewPeriod: 0
 *       renewalStatus: ManualRenewal
 *       instanceType: Advanced
 *       instanceName: ${name}
 *   exampleRegistryEnterpriseNamespace:
 *     type: alicloud:cs:RegistryEnterpriseNamespace
 *     name: example
 *     properties:
 *       instanceId: ${example.id}
 *       name: ${name}
 *       autoCreate: false
 *       defaultVisibility: PUBLIC
 *   exampleRegistryEnterpriseRepo:
 *     type: alicloud:cs:RegistryEnterpriseRepo
 *     name: example
 *     properties:
 *       instanceId: ${example.id}
 *       namespace: ${exampleRegistryEnterpriseNamespace.name}
 *       name: ${name}
 *       summary: this is summary of my new repo
 *       repoType: PUBLIC
 *       detail: this is a public repo
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Container Registry Enterprise Edition repository can be imported using the `{instance_id}:{namespace}:{repository}`, e.g.
 * ```sh
 * $ pulumi import alicloud:cs/registryEnterpriseRepo:RegistryEnterpriseRepo default `cri-xxx:my-namespace:my-repo`
 * ```
 */
public class RegistryEnterpriseRepo internal constructor(
    override val javaResource: com.pulumi.alicloud.cs.RegistryEnterpriseRepo,
) : KotlinCustomResource(javaResource, RegistryEnterpriseRepoMapper) {
    /**
     * The repository specific information. MarkDown format is supported, and the length limit is 2000.
     */
    public val detail: Output<String>?
        get() = javaResource.detail().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ID of Container Registry Enterprise Edition instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * Name of Container Registry Enterprise Edition repository. It can contain 2 to 64 characters.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Name of Container Registry Enterprise Edition namespace where repository is located. It can contain 2 to 30 characters.
     */
    public val namespace: Output<String>
        get() = javaResource.namespace().applyValue({ args0 -> args0 })

    /**
     * The uuid of Container Registry Enterprise Edition repository.
     */
    public val repoId: Output<String>
        get() = javaResource.repoId().applyValue({ args0 -> args0 })

    /**
     * `PUBLIC` or `PRIVATE`, repo's visibility.
     */
    public val repoType: Output<String>
        get() = javaResource.repoType().applyValue({ args0 -> args0 })

    /**
     * The repository general information. It can contain 1 to 100 characters.
     */
    public val summary: Output<String>
        get() = javaResource.summary().applyValue({ args0 -> args0 })
}

public object RegistryEnterpriseRepoMapper : ResourceMapper<RegistryEnterpriseRepo> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cs.RegistryEnterpriseRepo::class == javaResource::class

    override fun map(javaResource: Resource): RegistryEnterpriseRepo =
        RegistryEnterpriseRepo(javaResource as com.pulumi.alicloud.cs.RegistryEnterpriseRepo)
}

/**
 * @see [RegistryEnterpriseRepo].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegistryEnterpriseRepo].
 */
public suspend fun registryEnterpriseRepo(
    name: String,
    block: suspend RegistryEnterpriseRepoResourceBuilder.() -> Unit,
): RegistryEnterpriseRepo {
    val builder = RegistryEnterpriseRepoResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegistryEnterpriseRepo].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registryEnterpriseRepo(name: String): RegistryEnterpriseRepo {
    val builder = RegistryEnterpriseRepoResourceBuilder()
    builder.name(name)
    return builder.build()
}
