@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.RegistryEnterpriseRepoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This resource will help you to manager Container Registry Enterprise Edition repositories.
 * For information about Container Registry Enterprise Edition repository and how to use it, see [Create a Repository](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createrepository)
 * > **NOTE:** Available since v1.86.0.
 * > **NOTE:** You need to set your registry password in Container Registry Enterprise Edition console before use this resource.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const example = new alicloud.cr.RegistryEnterpriseInstance("example", {
 *     paymentType: "Subscription",
 *     period: 1,
 *     renewPeriod: 0,
 *     renewalStatus: "ManualRenewal",
 *     instanceType: "Advanced",
 *     instanceName: name,
 * });
 * const exampleRegistryEnterpriseNamespace = new alicloud.cs.RegistryEnterpriseNamespace("example", {
 *     instanceId: example.id,
 *     name: name,
 *     autoCreate: false,
 *     defaultVisibility: "PUBLIC",
 * });
 * const exampleRegistryEnterpriseRepo = new alicloud.cs.RegistryEnterpriseRepo("example", {
 *     instanceId: example.id,
 *     namespace: exampleRegistryEnterpriseNamespace.name,
 *     name: name,
 *     summary: "this is summary of my new repo",
 *     repoType: "PUBLIC",
 *     detail: "this is a public repo",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * example = alicloud.cr.RegistryEnterpriseInstance("example",
 *     payment_type="Subscription",
 *     period=1,
 *     renew_period=0,
 *     renewal_status="ManualRenewal",
 *     instance_type="Advanced",
 *     instance_name=name)
 * example_registry_enterprise_namespace = alicloud.cs.RegistryEnterpriseNamespace("example",
 *     instance_id=example.id,
 *     name=name,
 *     auto_create=False,
 *     default_visibility="PUBLIC")
 * example_registry_enterprise_repo = alicloud.cs.RegistryEnterpriseRepo("example",
 *     instance_id=example.id,
 *     namespace=example_registry_enterprise_namespace.name,
 *     name=name,
 *     summary="this is summary of my new repo",
 *     repo_type="PUBLIC",
 *     detail="this is a public repo")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var example = new AliCloud.CR.RegistryEnterpriseInstance("example", new()
 *     {
 *         PaymentType = "Subscription",
 *         Period = 1,
 *         RenewPeriod = 0,
 *         RenewalStatus = "ManualRenewal",
 *         InstanceType = "Advanced",
 *         InstanceName = name,
 *     });
 *     var exampleRegistryEnterpriseNamespace = new AliCloud.CS.RegistryEnterpriseNamespace("example", new()
 *     {
 *         InstanceId = example.Id,
 *         Name = name,
 *         AutoCreate = false,
 *         DefaultVisibility = "PUBLIC",
 *     });
 *     var exampleRegistryEnterpriseRepo = new AliCloud.CS.RegistryEnterpriseRepo("example", new()
 *     {
 *         InstanceId = example.Id,
 *         Namespace = exampleRegistryEnterpriseNamespace.Name,
 *         Name = name,
 *         Summary = "this is summary of my new repo",
 *         RepoType = "PUBLIC",
 *         Detail = "this is a public repo",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := cr.NewRegistryEnterpriseInstance(ctx, "example", &cr.RegistryEnterpriseInstanceArgs{
 * 			PaymentType:   pulumi.String("Subscription"),
 * 			Period:        pulumi.Int(1),
 * 			RenewPeriod:   pulumi.Int(0),
 * 			RenewalStatus: pulumi.String("ManualRenewal"),
 * 			InstanceType:  pulumi.String("Advanced"),
 * 			InstanceName:  pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRegistryEnterpriseNamespace, err := cs.NewRegistryEnterpriseNamespace(ctx, "example", &cs.RegistryEnterpriseNamespaceArgs{
 * 			InstanceId:        example.ID(),
 * 			Name:              pulumi.String(name),
 * 			AutoCreate:        pulumi.Bool(false),
 * 			DefaultVisibility: pulumi.String("PUBLIC"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cs.NewRegistryEnterpriseRepo(ctx, "example", &cs.RegistryEnterpriseRepoArgs{
 * 			InstanceId: example.ID(),
 * 			Namespace:  exampleRegistryEnterpriseNamespace.Name,
 * 			Name:       pulumi.String(name),
 * 			Summary:    pulumi.String("this is summary of my new repo"),
 * 			RepoType:   pulumi.String("PUBLIC"),
 * 			Detail:     pulumi.String("this is a public repo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstance;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstanceArgs;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseNamespace;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseNamespaceArgs;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseRepo;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseRepoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var example = new RegistryEnterpriseInstance("example", RegistryEnterpriseInstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .period(1)
 *             .renewPeriod(0)
 *             .renewalStatus("ManualRenewal")
 *             .instanceType("Advanced")
 *             .instanceName(name)
 *             .build());
 *         var exampleRegistryEnterpriseNamespace = new RegistryEnterpriseNamespace("exampleRegistryEnterpriseNamespace", RegistryEnterpriseNamespaceArgs.builder()
 *             .instanceId(example.id())
 *             .name(name)
 *             .autoCreate(false)
 *             .defaultVisibility("PUBLIC")
 *             .build());
 *         var exampleRegistryEnterpriseRepo = new RegistryEnterpriseRepo("exampleRegistryEnterpriseRepo", RegistryEnterpriseRepoArgs.builder()
 *             .instanceId(example.id())
 *             .namespace(exampleRegistryEnterpriseNamespace.name())
 *             .name(name)
 *             .summary("this is summary of my new repo")
 *             .repoType("PUBLIC")
 *             .detail("this is a public repo")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   example:
 *     type: alicloud:cr:RegistryEnterpriseInstance
 *     properties:
 *       paymentType: Subscription
 *       period: 1
 *       renewPeriod: 0
 *       renewalStatus: ManualRenewal
 *       instanceType: Advanced
 *       instanceName: ${name}
 *   exampleRegistryEnterpriseNamespace:
 *     type: alicloud:cs:RegistryEnterpriseNamespace
 *     name: example
 *     properties:
 *       instanceId: ${example.id}
 *       name: ${name}
 *       autoCreate: false
 *       defaultVisibility: PUBLIC
 *   exampleRegistryEnterpriseRepo:
 *     type: alicloud:cs:RegistryEnterpriseRepo
 *     name: example
 *     properties:
 *       instanceId: ${example.id}
 *       namespace: ${exampleRegistryEnterpriseNamespace.name}
 *       name: ${name}
 *       summary: this is summary of my new repo
 *       repoType: PUBLIC
 *       detail: this is a public repo
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Container Registry Enterprise Edition repository can be imported using the `{instance_id}:{namespace}:{repository}`, e.g.
 * ```sh
 * $ pulumi import alicloud:cs/registryEnterpriseRepo:RegistryEnterpriseRepo default `cri-xxx:my-namespace:my-repo`
 * ```
 * @property detail The repository specific information. MarkDown format is supported, and the length limit is 2000.
 * @property instanceId ID of Container Registry Enterprise Edition instance.
 * @property name Name of Container Registry Enterprise Edition repository. It can contain 2 to 64 characters.
 * @property namespace Name of Container Registry Enterprise Edition namespace where repository is located. It can contain 2 to 30 characters.
 * @property repoType `PUBLIC` or `PRIVATE`, repo's visibility.
 * @property summary The repository general information. It can contain 1 to 100 characters.
 */
public data class RegistryEnterpriseRepoArgs(
    public val detail: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namespace: Output<String>? = null,
    public val repoType: Output<String>? = null,
    public val summary: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.RegistryEnterpriseRepoArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.RegistryEnterpriseRepoArgs =
        com.pulumi.alicloud.cs.RegistryEnterpriseRepoArgs.builder()
            .detail(detail?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .repoType(repoType?.applyValue({ args0 -> args0 }))
            .summary(summary?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryEnterpriseRepoArgs].
 */
@PulumiTagMarker
public class RegistryEnterpriseRepoArgsBuilder internal constructor() {
    private var detail: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var name: Output<String>? = null

    private var namespace: Output<String>? = null

    private var repoType: Output<String>? = null

    private var summary: Output<String>? = null

    /**
     * @param value The repository specific information. MarkDown format is supported, and the length limit is 2000.
     */
    @JvmName("hyrfdxnjglrohkgf")
    public suspend fun detail(`value`: Output<String>) {
        this.detail = value
    }

    /**
     * @param value ID of Container Registry Enterprise Edition instance.
     */
    @JvmName("njstjsbywqwtimml")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Name of Container Registry Enterprise Edition repository. It can contain 2 to 64 characters.
     */
    @JvmName("ehcpnmabaqutgcyh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of Container Registry Enterprise Edition namespace where repository is located. It can contain 2 to 30 characters.
     */
    @JvmName("adlnllcycpvqhfca")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value `PUBLIC` or `PRIVATE`, repo's visibility.
     */
    @JvmName("rftbpyunvowxqree")
    public suspend fun repoType(`value`: Output<String>) {
        this.repoType = value
    }

    /**
     * @param value The repository general information. It can contain 1 to 100 characters.
     */
    @JvmName("mknnutmesndhktap")
    public suspend fun summary(`value`: Output<String>) {
        this.summary = value
    }

    /**
     * @param value The repository specific information. MarkDown format is supported, and the length limit is 2000.
     */
    @JvmName("khqqthsasltrwpgd")
    public suspend fun detail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detail = mapped
    }

    /**
     * @param value ID of Container Registry Enterprise Edition instance.
     */
    @JvmName("tghempcuqvnwdrbg")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Name of Container Registry Enterprise Edition repository. It can contain 2 to 64 characters.
     */
    @JvmName("towhyohsiarmxdrt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of Container Registry Enterprise Edition namespace where repository is located. It can contain 2 to 30 characters.
     */
    @JvmName("cqcwngeqlfnpmnsf")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value `PUBLIC` or `PRIVATE`, repo's visibility.
     */
    @JvmName("aqyfxwhvbeloeqxk")
    public suspend fun repoType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repoType = mapped
    }

    /**
     * @param value The repository general information. It can contain 1 to 100 characters.
     */
    @JvmName("rvkuokvdirwknoug")
    public suspend fun summary(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.summary = mapped
    }

    internal fun build(): RegistryEnterpriseRepoArgs = RegistryEnterpriseRepoArgs(
        detail = detail,
        instanceId = instanceId,
        name = name,
        namespace = namespace,
        repoType = repoType,
        summary = summary,
    )
}
