@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RegistryEnterpriseSyncRule].
 */
@PulumiTagMarker
public class RegistryEnterpriseSyncRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegistryEnterpriseSyncRuleArgs = RegistryEnterpriseSyncRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegistryEnterpriseSyncRuleArgsBuilder.() -> Unit) {
        val builder = RegistryEnterpriseSyncRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RegistryEnterpriseSyncRule {
        val builtJavaResource =
            com.pulumi.alicloud.cs.RegistryEnterpriseSyncRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RegistryEnterpriseSyncRule(builtJavaResource)
    }
}

/**
 * This resource will help you to manager Container Registry Enterprise Edition sync rules.
 * For information about Container Registry Enterprise Edition sync rules and how to use it, see [Create a Sync Rule](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createreposynctaskbyrule)
 * > **NOTE:** Available since v1.90.0.
 * > **NOTE:** You need to set your registry password in Container Registry Enterprise Edition console before use this resource.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const source = new alicloud.cr.RegistryEnterpriseInstance("source", {
 *     paymentType: "Subscription",
 *     period: 1,
 *     renewPeriod: 0,
 *     renewalStatus: "ManualRenewal",
 *     instanceType: "Advanced",
 *     instanceName: `${name}-source`,
 * });
 * const target = new alicloud.cr.RegistryEnterpriseInstance("target", {
 *     paymentType: "Subscription",
 *     period: 1,
 *     renewPeriod: 0,
 *     renewalStatus: "ManualRenewal",
 *     instanceType: "Advanced",
 *     instanceName: `${name}-target`,
 * });
 * const sourceRegistryEnterpriseNamespace = new alicloud.cs.RegistryEnterpriseNamespace("source", {
 *     instanceId: source.id,
 *     name: name,
 *     autoCreate: false,
 *     defaultVisibility: "PUBLIC",
 * });
 * const targetRegistryEnterpriseNamespace = new alicloud.cs.RegistryEnterpriseNamespace("target", {
 *     instanceId: target.id,
 *     name: name,
 *     autoCreate: false,
 *     defaultVisibility: "PUBLIC",
 * });
 * const sourceRegistryEnterpriseRepo = new alicloud.cs.RegistryEnterpriseRepo("source", {
 *     instanceId: source.id,
 *     namespace: sourceRegistryEnterpriseNamespace.name,
 *     name: name,
 *     summary: "this is summary of my new repo",
 *     repoType: "PUBLIC",
 *     detail: "this is a public repo",
 * });
 * const targetRegistryEnterpriseRepo = new alicloud.cs.RegistryEnterpriseRepo("target", {
 *     instanceId: target.id,
 *     namespace: targetRegistryEnterpriseNamespace.name,
 *     name: name,
 *     summary: "this is summary of my new repo",
 *     repoType: "PUBLIC",
 *     detail: "this is a public repo",
 * });
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultRegistryEnterpriseSyncRule = new alicloud.cs.RegistryEnterpriseSyncRule("default", {
 *     instanceId: source.id,
 *     namespaceName: sourceRegistryEnterpriseNamespace.name,
 *     name: name,
 *     targetRegionId: _default.then(_default => _default.regions?.[0]?.id),
 *     targetInstanceId: target.id,
 *     targetNamespaceName: targetRegistryEnterpriseNamespace.name,
 *     tagFilter: ".*",
 *     repoName: sourceRegistryEnterpriseRepo.name,
 *     targetRepoName: targetRegistryEnterpriseRepo.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * source = alicloud.cr.RegistryEnterpriseInstance("source",
 *     payment_type="Subscription",
 *     period=1,
 *     renew_period=0,
 *     renewal_status="ManualRenewal",
 *     instance_type="Advanced",
 *     instance_name=f"{name}-source")
 * target = alicloud.cr.RegistryEnterpriseInstance("target",
 *     payment_type="Subscription",
 *     period=1,
 *     renew_period=0,
 *     renewal_status="ManualRenewal",
 *     instance_type="Advanced",
 *     instance_name=f"{name}-target")
 * source_registry_enterprise_namespace = alicloud.cs.RegistryEnterpriseNamespace("source",
 *     instance_id=source.id,
 *     name=name,
 *     auto_create=False,
 *     default_visibility="PUBLIC")
 * target_registry_enterprise_namespace = alicloud.cs.RegistryEnterpriseNamespace("target",
 *     instance_id=target.id,
 *     name=name,
 *     auto_create=False,
 *     default_visibility="PUBLIC")
 * source_registry_enterprise_repo = alicloud.cs.RegistryEnterpriseRepo("source",
 *     instance_id=source.id,
 *     namespace=source_registry_enterprise_namespace.name,
 *     name=name,
 *     summary="this is summary of my new repo",
 *     repo_type="PUBLIC",
 *     detail="this is a public repo")
 * target_registry_enterprise_repo = alicloud.cs.RegistryEnterpriseRepo("target",
 *     instance_id=target.id,
 *     namespace=target_registry_enterprise_namespace.name,
 *     name=name,
 *     summary="this is summary of my new repo",
 *     repo_type="PUBLIC",
 *     detail="this is a public repo")
 * default = alicloud.get_regions(current=True)
 * default_registry_enterprise_sync_rule = alicloud.cs.RegistryEnterpriseSyncRule("default",
 *     instance_id=source.id,
 *     namespace_name=source_registry_enterprise_namespace.name,
 *     name=name,
 *     target_region_id=default.regions[0].id,
 *     target_instance_id=target.id,
 *     target_namespace_name=target_registry_enterprise_namespace.name,
 *     tag_filter=".*",
 *     repo_name=source_registry_enterprise_repo.name,
 *     target_repo_name=target_registry_enterprise_repo.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var source = new AliCloud.CR.RegistryEnterpriseInstance("source", new()
 *     {
 *         PaymentType = "Subscription",
 *         Period = 1,
 *         RenewPeriod = 0,
 *         RenewalStatus = "ManualRenewal",
 *         InstanceType = "Advanced",
 *         InstanceName = $"{name}-source",
 *     });
 *     var target = new AliCloud.CR.RegistryEnterpriseInstance("target", new()
 *     {
 *         PaymentType = "Subscription",
 *         Period = 1,
 *         RenewPeriod = 0,
 *         RenewalStatus = "ManualRenewal",
 *         InstanceType = "Advanced",
 *         InstanceName = $"{name}-target",
 *     });
 *     var sourceRegistryEnterpriseNamespace = new AliCloud.CS.RegistryEnterpriseNamespace("source", new()
 *     {
 *         InstanceId = source.Id,
 *         Name = name,
 *         AutoCreate = false,
 *         DefaultVisibility = "PUBLIC",
 *     });
 *     var targetRegistryEnterpriseNamespace = new AliCloud.CS.RegistryEnterpriseNamespace("target", new()
 *     {
 *         InstanceId = target.Id,
 *         Name = name,
 *         AutoCreate = false,
 *         DefaultVisibility = "PUBLIC",
 *     });
 *     var sourceRegistryEnterpriseRepo = new AliCloud.CS.RegistryEnterpriseRepo("source", new()
 *     {
 *         InstanceId = source.Id,
 *         Namespace = sourceRegistryEnterpriseNamespace.Name,
 *         Name = name,
 *         Summary = "this is summary of my new repo",
 *         RepoType = "PUBLIC",
 *         Detail = "this is a public repo",
 *     });
 *     var targetRegistryEnterpriseRepo = new AliCloud.CS.RegistryEnterpriseRepo("target", new()
 *     {
 *         InstanceId = target.Id,
 *         Namespace = targetRegistryEnterpriseNamespace.Name,
 *         Name = name,
 *         Summary = "this is summary of my new repo",
 *         RepoType = "PUBLIC",
 *         Detail = "this is a public repo",
 *     });
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultRegistryEnterpriseSyncRule = new AliCloud.CS.RegistryEnterpriseSyncRule("default", new()
 *     {
 *         InstanceId = source.Id,
 *         NamespaceName = sourceRegistryEnterpriseNamespace.Name,
 *         Name = name,
 *         TargetRegionId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         TargetInstanceId = target.Id,
 *         TargetNamespaceName = targetRegistryEnterpriseNamespace.Name,
 *         TagFilter = ".*",
 *         RepoName = sourceRegistryEnterpriseRepo.Name,
 *         TargetRepoName = targetRegistryEnterpriseRepo.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		source, err := cr.NewRegistryEnterpriseInstance(ctx, "source", &cr.RegistryEnterpriseInstanceArgs{
 * 			PaymentType:   pulumi.String("Subscription"),
 * 			Period:        pulumi.Int(1),
 * 			RenewPeriod:   pulumi.Int(0),
 * 			RenewalStatus: pulumi.String("ManualRenewal"),
 * 			InstanceType:  pulumi.String("Advanced"),
 * 			InstanceName:  pulumi.Sprintf("%v-source", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		target, err := cr.NewRegistryEnterpriseInstance(ctx, "target", &cr.RegistryEnterpriseInstanceArgs{
 * 			PaymentType:   pulumi.String("Subscription"),
 * 			Period:        pulumi.Int(1),
 * 			RenewPeriod:   pulumi.Int(0),
 * 			RenewalStatus: pulumi.String("ManualRenewal"),
 * 			InstanceType:  pulumi.String("Advanced"),
 * 			InstanceName:  pulumi.Sprintf("%v-target", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		sourceRegistryEnterpriseNamespace, err := cs.NewRegistryEnterpriseNamespace(ctx, "source", &cs.RegistryEnterpriseNamespaceArgs{
 * 			InstanceId:        source.ID(),
 * 			Name:              pulumi.String(name),
 * 			AutoCreate:        pulumi.Bool(false),
 * 			DefaultVisibility: pulumi.String("PUBLIC"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		targetRegistryEnterpriseNamespace, err := cs.NewRegistryEnterpriseNamespace(ctx, "target", &cs.RegistryEnterpriseNamespaceArgs{
 * 			InstanceId:        target.ID(),
 * 			Name:              pulumi.String(name),
 * 			AutoCreate:        pulumi.Bool(false),
 * 			DefaultVisibility: pulumi.String("PUBLIC"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		sourceRegistryEnterpriseRepo, err := cs.NewRegistryEnterpriseRepo(ctx, "source", &cs.RegistryEnterpriseRepoArgs{
 * 			InstanceId: source.ID(),
 * 			Namespace:  sourceRegistryEnterpriseNamespace.Name,
 * 			Name:       pulumi.String(name),
 * 			Summary:    pulumi.String("this is summary of my new repo"),
 * 			RepoType:   pulumi.String("PUBLIC"),
 * 			Detail:     pulumi.String("this is a public repo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		targetRegistryEnterpriseRepo, err := cs.NewRegistryEnterpriseRepo(ctx, "target", &cs.RegistryEnterpriseRepoArgs{
 * 			InstanceId: target.ID(),
 * 			Namespace:  targetRegistryEnterpriseNamespace.Name,
 * 			Name:       pulumi.String(name),
 * 			Summary:    pulumi.String("this is summary of my new repo"),
 * 			RepoType:   pulumi.String("PUBLIC"),
 * 			Detail:     pulumi.String("this is a public repo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cs.NewRegistryEnterpriseSyncRule(ctx, "default", &cs.RegistryEnterpriseSyncRuleArgs{
 * 			InstanceId:          source.ID(),
 * 			NamespaceName:       sourceRegistryEnterpriseNamespace.Name,
 * 			Name:                pulumi.String(name),
 * 			TargetRegionId:      pulumi.String(_default.Regions[0].Id),
 * 			TargetInstanceId:    target.ID(),
 * 			TargetNamespaceName: targetRegistryEnterpriseNamespace.Name,
 * 			TagFilter:           pulumi.String(".*"),
 * 			RepoName:            sourceRegistryEnterpriseRepo.Name,
 * 			TargetRepoName:      targetRegistryEnterpriseRepo.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstance;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstanceArgs;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseNamespace;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseNamespaceArgs;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseRepo;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseRepoArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseSyncRule;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseSyncRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var source = new RegistryEnterpriseInstance("source", RegistryEnterpriseInstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .period(1)
 *             .renewPeriod(0)
 *             .renewalStatus("ManualRenewal")
 *             .instanceType("Advanced")
 *             .instanceName(String.format("%s-source", name))
 *             .build());
 *         var target = new RegistryEnterpriseInstance("target", RegistryEnterpriseInstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .period(1)
 *             .renewPeriod(0)
 *             .renewalStatus("ManualRenewal")
 *             .instanceType("Advanced")
 *             .instanceName(String.format("%s-target", name))
 *             .build());
 *         var sourceRegistryEnterpriseNamespace = new RegistryEnterpriseNamespace("sourceRegistryEnterpriseNamespace", RegistryEnterpriseNamespaceArgs.builder()
 *             .instanceId(source.id())
 *             .name(name)
 *             .autoCreate(false)
 *             .defaultVisibility("PUBLIC")
 *             .build());
 *         var targetRegistryEnterpriseNamespace = new RegistryEnterpriseNamespace("targetRegistryEnterpriseNamespace", RegistryEnterpriseNamespaceArgs.builder()
 *             .instanceId(target.id())
 *             .name(name)
 *             .autoCreate(false)
 *             .defaultVisibility("PUBLIC")
 *             .build());
 *         var sourceRegistryEnterpriseRepo = new RegistryEnterpriseRepo("sourceRegistryEnterpriseRepo", RegistryEnterpriseRepoArgs.builder()
 *             .instanceId(source.id())
 *             .namespace(sourceRegistryEnterpriseNamespace.name())
 *             .name(name)
 *             .summary("this is summary of my new repo")
 *             .repoType("PUBLIC")
 *             .detail("this is a public repo")
 *             .build());
 *         var targetRegistryEnterpriseRepo = new RegistryEnterpriseRepo("targetRegistryEnterpriseRepo", RegistryEnterpriseRepoArgs.builder()
 *             .instanceId(target.id())
 *             .namespace(targetRegistryEnterpriseNamespace.name())
 *             .name(name)
 *             .summary("this is summary of my new repo")
 *             .repoType("PUBLIC")
 *             .detail("this is a public repo")
 *             .build());
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var defaultRegistryEnterpriseSyncRule = new RegistryEnterpriseSyncRule("defaultRegistryEnterpriseSyncRule", RegistryEnterpriseSyncRuleArgs.builder()
 *             .instanceId(source.id())
 *             .namespaceName(sourceRegistryEnterpriseNamespace.name())
 *             .name(name)
 *             .targetRegionId(default_.regions()[0].id())
 *             .targetInstanceId(target.id())
 *             .targetNamespaceName(targetRegistryEnterpriseNamespace.name())
 *             .tagFilter(".*")
 *             .repoName(sourceRegistryEnterpriseRepo.name())
 *             .targetRepoName(targetRegistryEnterpriseRepo.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   source:
 *     type: alicloud:cr:RegistryEnterpriseInstance
 *     properties:
 *       paymentType: Subscription
 *       period: 1
 *       renewPeriod: 0
 *       renewalStatus: ManualRenewal
 *       instanceType: Advanced
 *       instanceName: ${name}-source
 *   target:
 *     type: alicloud:cr:RegistryEnterpriseInstance
 *     properties:
 *       paymentType: Subscription
 *       period: 1
 *       renewPeriod: 0
 *       renewalStatus: ManualRenewal
 *       instanceType: Advanced
 *       instanceName: ${name}-target
 *   sourceRegistryEnterpriseNamespace:
 *     type: alicloud:cs:RegistryEnterpriseNamespace
 *     name: source
 *     properties:
 *       instanceId: ${source.id}
 *       name: ${name}
 *       autoCreate: false
 *       defaultVisibility: PUBLIC
 *   targetRegistryEnterpriseNamespace:
 *     type: alicloud:cs:RegistryEnterpriseNamespace
 *     name: target
 *     properties:
 *       instanceId: ${target.id}
 *       name: ${name}
 *       autoCreate: false
 *       defaultVisibility: PUBLIC
 *   sourceRegistryEnterpriseRepo:
 *     type: alicloud:cs:RegistryEnterpriseRepo
 *     name: source
 *     properties:
 *       instanceId: ${source.id}
 *       namespace: ${sourceRegistryEnterpriseNamespace.name}
 *       name: ${name}
 *       summary: this is summary of my new repo
 *       repoType: PUBLIC
 *       detail: this is a public repo
 *   targetRegistryEnterpriseRepo:
 *     type: alicloud:cs:RegistryEnterpriseRepo
 *     name: target
 *     properties:
 *       instanceId: ${target.id}
 *       namespace: ${targetRegistryEnterpriseNamespace.name}
 *       name: ${name}
 *       summary: this is summary of my new repo
 *       repoType: PUBLIC
 *       detail: this is a public repo
 *   defaultRegistryEnterpriseSyncRule:
 *     type: alicloud:cs:RegistryEnterpriseSyncRule
 *     name: default
 *     properties:
 *       instanceId: ${source.id}
 *       namespaceName: ${sourceRegistryEnterpriseNamespace.name}
 *       name: ${name}
 *       targetRegionId: ${default.regions[0].id}
 *       targetInstanceId: ${target.id}
 *       targetNamespaceName: ${targetRegistryEnterpriseNamespace.name}
 *       tagFilter: .*
 *       repoName: ${sourceRegistryEnterpriseRepo.name}
 *       targetRepoName: ${targetRegistryEnterpriseRepo.name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Container Registry Enterprise Edition sync rule can be imported using the id. Format to `{instance_id}:{namespace_name}:{rule_id}`, e.g.
 * ```sh
 * $ pulumi import alicloud:cs/registryEnterpriseSyncRule:RegistryEnterpriseSyncRule default `cri-xxx:my-namespace:crsr-yyy`
 * ```
 */
public class RegistryEnterpriseSyncRule internal constructor(
    override val javaResource: com.pulumi.alicloud.cs.RegistryEnterpriseSyncRule,
) : KotlinCustomResource(javaResource, RegistryEnterpriseSyncRuleMapper) {
    /**
     * ID of Container Registry Enterprise Edition source instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * Name of Container Registry Enterprise Edition sync rule.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Name of Container Registry Enterprise Edition source namespace. It can contain 2 to 30 characters.
     */
    public val namespaceName: Output<String>
        get() = javaResource.namespaceName().applyValue({ args0 -> args0 })

    /**
     * Name of the source repository which should be set together with `target_repo_name`, if empty means that the synchronization scope is the entire namespace level.
     */
    public val repoName: Output<String>?
        get() = javaResource.repoName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The uuid of Container Registry Enterprise Edition sync rule.
     */
    public val ruleId: Output<String>
        get() = javaResource.ruleId().applyValue({ args0 -> args0 })

    /**
     * `FROM` or `TO`, the direction of synchronization. `FROM` means source instance, `TO` means target instance.
     */
    public val syncDirection: Output<String>
        get() = javaResource.syncDirection().applyValue({ args0 -> args0 })

    /**
     * `REPO` or `NAMESPACE`,the scope that the synchronization rule applies.
     */
    public val syncScope: Output<String>
        get() = javaResource.syncScope().applyValue({ args0 -> args0 })

    /**
     * The regular expression used to filter image tags for synchronization in the source repository.
     */
    public val tagFilter: Output<String>
        get() = javaResource.tagFilter().applyValue({ args0 -> args0 })

    /**
     * ID of Container Registry Enterprise Edition target instance to be synchronized.
     */
    public val targetInstanceId: Output<String>
        get() = javaResource.targetInstanceId().applyValue({ args0 -> args0 })

    /**
     * Name of Container Registry Enterprise Edition target namespace to be synchronized. It can contain 2 to 30 characters.
     */
    public val targetNamespaceName: Output<String>
        get() = javaResource.targetNamespaceName().applyValue({ args0 -> args0 })

    /**
     * The target region to be synchronized.
     */
    public val targetRegionId: Output<String>
        get() = javaResource.targetRegionId().applyValue({ args0 -> args0 })

    /**
     * Name of the target repository.
     */
    public val targetRepoName: Output<String>?
        get() = javaResource.targetRepoName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object RegistryEnterpriseSyncRuleMapper : ResourceMapper<RegistryEnterpriseSyncRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cs.RegistryEnterpriseSyncRule::class == javaResource::class

    override fun map(javaResource: Resource): RegistryEnterpriseSyncRule =
        RegistryEnterpriseSyncRule(javaResource as com.pulumi.alicloud.cs.RegistryEnterpriseSyncRule)
}

/**
 * @see [RegistryEnterpriseSyncRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegistryEnterpriseSyncRule].
 */
public suspend fun registryEnterpriseSyncRule(
    name: String,
    block: suspend RegistryEnterpriseSyncRuleResourceBuilder.() -> Unit,
): RegistryEnterpriseSyncRule {
    val builder = RegistryEnterpriseSyncRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegistryEnterpriseSyncRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registryEnterpriseSyncRule(name: String): RegistryEnterpriseSyncRule {
    val builder = RegistryEnterpriseSyncRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
