@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.RegistryEnterpriseSyncRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This resource will help you to manager Container Registry Enterprise Edition sync rules.
 * For information about Container Registry Enterprise Edition sync rules and how to use it, see [Create a Sync Rule](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createreposynctaskbyrule)
 * > **NOTE:** Available since v1.90.0.
 * > **NOTE:** You need to set your registry password in Container Registry Enterprise Edition console before use this resource.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const source = new alicloud.cr.RegistryEnterpriseInstance("source", {
 *     paymentType: "Subscription",
 *     period: 1,
 *     renewPeriod: 0,
 *     renewalStatus: "ManualRenewal",
 *     instanceType: "Advanced",
 *     instanceName: `${name}-source`,
 * });
 * const target = new alicloud.cr.RegistryEnterpriseInstance("target", {
 *     paymentType: "Subscription",
 *     period: 1,
 *     renewPeriod: 0,
 *     renewalStatus: "ManualRenewal",
 *     instanceType: "Advanced",
 *     instanceName: `${name}-target`,
 * });
 * const sourceRegistryEnterpriseNamespace = new alicloud.cs.RegistryEnterpriseNamespace("source", {
 *     instanceId: source.id,
 *     name: name,
 *     autoCreate: false,
 *     defaultVisibility: "PUBLIC",
 * });
 * const targetRegistryEnterpriseNamespace = new alicloud.cs.RegistryEnterpriseNamespace("target", {
 *     instanceId: target.id,
 *     name: name,
 *     autoCreate: false,
 *     defaultVisibility: "PUBLIC",
 * });
 * const sourceRegistryEnterpriseRepo = new alicloud.cs.RegistryEnterpriseRepo("source", {
 *     instanceId: source.id,
 *     namespace: sourceRegistryEnterpriseNamespace.name,
 *     name: name,
 *     summary: "this is summary of my new repo",
 *     repoType: "PUBLIC",
 *     detail: "this is a public repo",
 * });
 * const targetRegistryEnterpriseRepo = new alicloud.cs.RegistryEnterpriseRepo("target", {
 *     instanceId: target.id,
 *     namespace: targetRegistryEnterpriseNamespace.name,
 *     name: name,
 *     summary: "this is summary of my new repo",
 *     repoType: "PUBLIC",
 *     detail: "this is a public repo",
 * });
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultRegistryEnterpriseSyncRule = new alicloud.cs.RegistryEnterpriseSyncRule("default", {
 *     instanceId: source.id,
 *     namespaceName: sourceRegistryEnterpriseNamespace.name,
 *     name: name,
 *     targetRegionId: _default.then(_default => _default.regions?.[0]?.id),
 *     targetInstanceId: target.id,
 *     targetNamespaceName: targetRegistryEnterpriseNamespace.name,
 *     tagFilter: ".*",
 *     repoName: sourceRegistryEnterpriseRepo.name,
 *     targetRepoName: targetRegistryEnterpriseRepo.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * source = alicloud.cr.RegistryEnterpriseInstance("source",
 *     payment_type="Subscription",
 *     period=1,
 *     renew_period=0,
 *     renewal_status="ManualRenewal",
 *     instance_type="Advanced",
 *     instance_name=f"{name}-source")
 * target = alicloud.cr.RegistryEnterpriseInstance("target",
 *     payment_type="Subscription",
 *     period=1,
 *     renew_period=0,
 *     renewal_status="ManualRenewal",
 *     instance_type="Advanced",
 *     instance_name=f"{name}-target")
 * source_registry_enterprise_namespace = alicloud.cs.RegistryEnterpriseNamespace("source",
 *     instance_id=source.id,
 *     name=name,
 *     auto_create=False,
 *     default_visibility="PUBLIC")
 * target_registry_enterprise_namespace = alicloud.cs.RegistryEnterpriseNamespace("target",
 *     instance_id=target.id,
 *     name=name,
 *     auto_create=False,
 *     default_visibility="PUBLIC")
 * source_registry_enterprise_repo = alicloud.cs.RegistryEnterpriseRepo("source",
 *     instance_id=source.id,
 *     namespace=source_registry_enterprise_namespace.name,
 *     name=name,
 *     summary="this is summary of my new repo",
 *     repo_type="PUBLIC",
 *     detail="this is a public repo")
 * target_registry_enterprise_repo = alicloud.cs.RegistryEnterpriseRepo("target",
 *     instance_id=target.id,
 *     namespace=target_registry_enterprise_namespace.name,
 *     name=name,
 *     summary="this is summary of my new repo",
 *     repo_type="PUBLIC",
 *     detail="this is a public repo")
 * default = alicloud.get_regions(current=True)
 * default_registry_enterprise_sync_rule = alicloud.cs.RegistryEnterpriseSyncRule("default",
 *     instance_id=source.id,
 *     namespace_name=source_registry_enterprise_namespace.name,
 *     name=name,
 *     target_region_id=default.regions[0].id,
 *     target_instance_id=target.id,
 *     target_namespace_name=target_registry_enterprise_namespace.name,
 *     tag_filter=".*",
 *     repo_name=source_registry_enterprise_repo.name,
 *     target_repo_name=target_registry_enterprise_repo.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var source = new AliCloud.CR.RegistryEnterpriseInstance("source", new()
 *     {
 *         PaymentType = "Subscription",
 *         Period = 1,
 *         RenewPeriod = 0,
 *         RenewalStatus = "ManualRenewal",
 *         InstanceType = "Advanced",
 *         InstanceName = $"{name}-source",
 *     });
 *     var target = new AliCloud.CR.RegistryEnterpriseInstance("target", new()
 *     {
 *         PaymentType = "Subscription",
 *         Period = 1,
 *         RenewPeriod = 0,
 *         RenewalStatus = "ManualRenewal",
 *         InstanceType = "Advanced",
 *         InstanceName = $"{name}-target",
 *     });
 *     var sourceRegistryEnterpriseNamespace = new AliCloud.CS.RegistryEnterpriseNamespace("source", new()
 *     {
 *         InstanceId = source.Id,
 *         Name = name,
 *         AutoCreate = false,
 *         DefaultVisibility = "PUBLIC",
 *     });
 *     var targetRegistryEnterpriseNamespace = new AliCloud.CS.RegistryEnterpriseNamespace("target", new()
 *     {
 *         InstanceId = target.Id,
 *         Name = name,
 *         AutoCreate = false,
 *         DefaultVisibility = "PUBLIC",
 *     });
 *     var sourceRegistryEnterpriseRepo = new AliCloud.CS.RegistryEnterpriseRepo("source", new()
 *     {
 *         InstanceId = source.Id,
 *         Namespace = sourceRegistryEnterpriseNamespace.Name,
 *         Name = name,
 *         Summary = "this is summary of my new repo",
 *         RepoType = "PUBLIC",
 *         Detail = "this is a public repo",
 *     });
 *     var targetRegistryEnterpriseRepo = new AliCloud.CS.RegistryEnterpriseRepo("target", new()
 *     {
 *         InstanceId = target.Id,
 *         Namespace = targetRegistryEnterpriseNamespace.Name,
 *         Name = name,
 *         Summary = "this is summary of my new repo",
 *         RepoType = "PUBLIC",
 *         Detail = "this is a public repo",
 *     });
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultRegistryEnterpriseSyncRule = new AliCloud.CS.RegistryEnterpriseSyncRule("default", new()
 *     {
 *         InstanceId = source.Id,
 *         NamespaceName = sourceRegistryEnterpriseNamespace.Name,
 *         Name = name,
 *         TargetRegionId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         TargetInstanceId = target.Id,
 *         TargetNamespaceName = targetRegistryEnterpriseNamespace.Name,
 *         TagFilter = ".*",
 *         RepoName = sourceRegistryEnterpriseRepo.Name,
 *         TargetRepoName = targetRegistryEnterpriseRepo.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		source, err := cr.NewRegistryEnterpriseInstance(ctx, "source", &cr.RegistryEnterpriseInstanceArgs{
 * 			PaymentType:   pulumi.String("Subscription"),
 * 			Period:        pulumi.Int(1),
 * 			RenewPeriod:   pulumi.Int(0),
 * 			RenewalStatus: pulumi.String("ManualRenewal"),
 * 			InstanceType:  pulumi.String("Advanced"),
 * 			InstanceName:  pulumi.Sprintf("%v-source", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		target, err := cr.NewRegistryEnterpriseInstance(ctx, "target", &cr.RegistryEnterpriseInstanceArgs{
 * 			PaymentType:   pulumi.String("Subscription"),
 * 			Period:        pulumi.Int(1),
 * 			RenewPeriod:   pulumi.Int(0),
 * 			RenewalStatus: pulumi.String("ManualRenewal"),
 * 			InstanceType:  pulumi.String("Advanced"),
 * 			InstanceName:  pulumi.Sprintf("%v-target", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		sourceRegistryEnterpriseNamespace, err := cs.NewRegistryEnterpriseNamespace(ctx, "source", &cs.RegistryEnterpriseNamespaceArgs{
 * 			InstanceId:        source.ID(),
 * 			Name:              pulumi.String(name),
 * 			AutoCreate:        pulumi.Bool(false),
 * 			DefaultVisibility: pulumi.String("PUBLIC"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		targetRegistryEnterpriseNamespace, err := cs.NewRegistryEnterpriseNamespace(ctx, "target", &cs.RegistryEnterpriseNamespaceArgs{
 * 			InstanceId:        target.ID(),
 * 			Name:              pulumi.String(name),
 * 			AutoCreate:        pulumi.Bool(false),
 * 			DefaultVisibility: pulumi.String("PUBLIC"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		sourceRegistryEnterpriseRepo, err := cs.NewRegistryEnterpriseRepo(ctx, "source", &cs.RegistryEnterpriseRepoArgs{
 * 			InstanceId: source.ID(),
 * 			Namespace:  sourceRegistryEnterpriseNamespace.Name,
 * 			Name:       pulumi.String(name),
 * 			Summary:    pulumi.String("this is summary of my new repo"),
 * 			RepoType:   pulumi.String("PUBLIC"),
 * 			Detail:     pulumi.String("this is a public repo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		targetRegistryEnterpriseRepo, err := cs.NewRegistryEnterpriseRepo(ctx, "target", &cs.RegistryEnterpriseRepoArgs{
 * 			InstanceId: target.ID(),
 * 			Namespace:  targetRegistryEnterpriseNamespace.Name,
 * 			Name:       pulumi.String(name),
 * 			Summary:    pulumi.String("this is summary of my new repo"),
 * 			RepoType:   pulumi.String("PUBLIC"),
 * 			Detail:     pulumi.String("this is a public repo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cs.NewRegistryEnterpriseSyncRule(ctx, "default", &cs.RegistryEnterpriseSyncRuleArgs{
 * 			InstanceId:          source.ID(),
 * 			NamespaceName:       sourceRegistryEnterpriseNamespace.Name,
 * 			Name:                pulumi.String(name),
 * 			TargetRegionId:      pulumi.String(_default.Regions[0].Id),
 * 			TargetInstanceId:    target.ID(),
 * 			TargetNamespaceName: targetRegistryEnterpriseNamespace.Name,
 * 			TagFilter:           pulumi.String(".*"),
 * 			RepoName:            sourceRegistryEnterpriseRepo.Name,
 * 			TargetRepoName:      targetRegistryEnterpriseRepo.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstance;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstanceArgs;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseNamespace;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseNamespaceArgs;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseRepo;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseRepoArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseSyncRule;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseSyncRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var source = new RegistryEnterpriseInstance("source", RegistryEnterpriseInstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .period(1)
 *             .renewPeriod(0)
 *             .renewalStatus("ManualRenewal")
 *             .instanceType("Advanced")
 *             .instanceName(String.format("%s-source", name))
 *             .build());
 *         var target = new RegistryEnterpriseInstance("target", RegistryEnterpriseInstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .period(1)
 *             .renewPeriod(0)
 *             .renewalStatus("ManualRenewal")
 *             .instanceType("Advanced")
 *             .instanceName(String.format("%s-target", name))
 *             .build());
 *         var sourceRegistryEnterpriseNamespace = new RegistryEnterpriseNamespace("sourceRegistryEnterpriseNamespace", RegistryEnterpriseNamespaceArgs.builder()
 *             .instanceId(source.id())
 *             .name(name)
 *             .autoCreate(false)
 *             .defaultVisibility("PUBLIC")
 *             .build());
 *         var targetRegistryEnterpriseNamespace = new RegistryEnterpriseNamespace("targetRegistryEnterpriseNamespace", RegistryEnterpriseNamespaceArgs.builder()
 *             .instanceId(target.id())
 *             .name(name)
 *             .autoCreate(false)
 *             .defaultVisibility("PUBLIC")
 *             .build());
 *         var sourceRegistryEnterpriseRepo = new RegistryEnterpriseRepo("sourceRegistryEnterpriseRepo", RegistryEnterpriseRepoArgs.builder()
 *             .instanceId(source.id())
 *             .namespace(sourceRegistryEnterpriseNamespace.name())
 *             .name(name)
 *             .summary("this is summary of my new repo")
 *             .repoType("PUBLIC")
 *             .detail("this is a public repo")
 *             .build());
 *         var targetRegistryEnterpriseRepo = new RegistryEnterpriseRepo("targetRegistryEnterpriseRepo", RegistryEnterpriseRepoArgs.builder()
 *             .instanceId(target.id())
 *             .namespace(targetRegistryEnterpriseNamespace.name())
 *             .name(name)
 *             .summary("this is summary of my new repo")
 *             .repoType("PUBLIC")
 *             .detail("this is a public repo")
 *             .build());
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var defaultRegistryEnterpriseSyncRule = new RegistryEnterpriseSyncRule("defaultRegistryEnterpriseSyncRule", RegistryEnterpriseSyncRuleArgs.builder()
 *             .instanceId(source.id())
 *             .namespaceName(sourceRegistryEnterpriseNamespace.name())
 *             .name(name)
 *             .targetRegionId(default_.regions()[0].id())
 *             .targetInstanceId(target.id())
 *             .targetNamespaceName(targetRegistryEnterpriseNamespace.name())
 *             .tagFilter(".*")
 *             .repoName(sourceRegistryEnterpriseRepo.name())
 *             .targetRepoName(targetRegistryEnterpriseRepo.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   source:
 *     type: alicloud:cr:RegistryEnterpriseInstance
 *     properties:
 *       paymentType: Subscription
 *       period: 1
 *       renewPeriod: 0
 *       renewalStatus: ManualRenewal
 *       instanceType: Advanced
 *       instanceName: ${name}-source
 *   target:
 *     type: alicloud:cr:RegistryEnterpriseInstance
 *     properties:
 *       paymentType: Subscription
 *       period: 1
 *       renewPeriod: 0
 *       renewalStatus: ManualRenewal
 *       instanceType: Advanced
 *       instanceName: ${name}-target
 *   sourceRegistryEnterpriseNamespace:
 *     type: alicloud:cs:RegistryEnterpriseNamespace
 *     name: source
 *     properties:
 *       instanceId: ${source.id}
 *       name: ${name}
 *       autoCreate: false
 *       defaultVisibility: PUBLIC
 *   targetRegistryEnterpriseNamespace:
 *     type: alicloud:cs:RegistryEnterpriseNamespace
 *     name: target
 *     properties:
 *       instanceId: ${target.id}
 *       name: ${name}
 *       autoCreate: false
 *       defaultVisibility: PUBLIC
 *   sourceRegistryEnterpriseRepo:
 *     type: alicloud:cs:RegistryEnterpriseRepo
 *     name: source
 *     properties:
 *       instanceId: ${source.id}
 *       namespace: ${sourceRegistryEnterpriseNamespace.name}
 *       name: ${name}
 *       summary: this is summary of my new repo
 *       repoType: PUBLIC
 *       detail: this is a public repo
 *   targetRegistryEnterpriseRepo:
 *     type: alicloud:cs:RegistryEnterpriseRepo
 *     name: target
 *     properties:
 *       instanceId: ${target.id}
 *       namespace: ${targetRegistryEnterpriseNamespace.name}
 *       name: ${name}
 *       summary: this is summary of my new repo
 *       repoType: PUBLIC
 *       detail: this is a public repo
 *   defaultRegistryEnterpriseSyncRule:
 *     type: alicloud:cs:RegistryEnterpriseSyncRule
 *     name: default
 *     properties:
 *       instanceId: ${source.id}
 *       namespaceName: ${sourceRegistryEnterpriseNamespace.name}
 *       name: ${name}
 *       targetRegionId: ${default.regions[0].id}
 *       targetInstanceId: ${target.id}
 *       targetNamespaceName: ${targetRegistryEnterpriseNamespace.name}
 *       tagFilter: .*
 *       repoName: ${sourceRegistryEnterpriseRepo.name}
 *       targetRepoName: ${targetRegistryEnterpriseRepo.name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Container Registry Enterprise Edition sync rule can be imported using the id. Format to `{instance_id}:{namespace_name}:{rule_id}`, e.g.
 * ```sh
 * $ pulumi import alicloud:cs/registryEnterpriseSyncRule:RegistryEnterpriseSyncRule default `cri-xxx:my-namespace:crsr-yyy`
 * ```
 * @property instanceId ID of Container Registry Enterprise Edition source instance.
 * @property name Name of Container Registry Enterprise Edition sync rule.
 * @property namespaceName Name of Container Registry Enterprise Edition source namespace. It can contain 2 to 30 characters.
 * @property repoName Name of the source repository which should be set together with `target_repo_name`, if empty means that the synchronization scope is the entire namespace level.
 * @property tagFilter The regular expression used to filter image tags for synchronization in the source repository.
 * @property targetInstanceId ID of Container Registry Enterprise Edition target instance to be synchronized.
 * @property targetNamespaceName Name of Container Registry Enterprise Edition target namespace to be synchronized. It can contain 2 to 30 characters.
 * @property targetRegionId The target region to be synchronized.
 * @property targetRepoName Name of the target repository.
 */
public data class RegistryEnterpriseSyncRuleArgs(
    public val instanceId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val repoName: Output<String>? = null,
    public val tagFilter: Output<String>? = null,
    public val targetInstanceId: Output<String>? = null,
    public val targetNamespaceName: Output<String>? = null,
    public val targetRegionId: Output<String>? = null,
    public val targetRepoName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.RegistryEnterpriseSyncRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.RegistryEnterpriseSyncRuleArgs =
        com.pulumi.alicloud.cs.RegistryEnterpriseSyncRuleArgs.builder()
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .repoName(repoName?.applyValue({ args0 -> args0 }))
            .tagFilter(tagFilter?.applyValue({ args0 -> args0 }))
            .targetInstanceId(targetInstanceId?.applyValue({ args0 -> args0 }))
            .targetNamespaceName(targetNamespaceName?.applyValue({ args0 -> args0 }))
            .targetRegionId(targetRegionId?.applyValue({ args0 -> args0 }))
            .targetRepoName(targetRepoName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryEnterpriseSyncRuleArgs].
 */
@PulumiTagMarker
public class RegistryEnterpriseSyncRuleArgsBuilder internal constructor() {
    private var instanceId: Output<String>? = null

    private var name: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var repoName: Output<String>? = null

    private var tagFilter: Output<String>? = null

    private var targetInstanceId: Output<String>? = null

    private var targetNamespaceName: Output<String>? = null

    private var targetRegionId: Output<String>? = null

    private var targetRepoName: Output<String>? = null

    /**
     * @param value ID of Container Registry Enterprise Edition source instance.
     */
    @JvmName("jvnrbeuwkqreypis")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Name of Container Registry Enterprise Edition sync rule.
     */
    @JvmName("cpgdlmbeerwhxsve")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of Container Registry Enterprise Edition source namespace. It can contain 2 to 30 characters.
     */
    @JvmName("vpmhgdnujnkodmwg")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Name of the source repository which should be set together with `target_repo_name`, if empty means that the synchronization scope is the entire namespace level.
     */
    @JvmName("gsglvhsxtmxxlrrf")
    public suspend fun repoName(`value`: Output<String>) {
        this.repoName = value
    }

    /**
     * @param value The regular expression used to filter image tags for synchronization in the source repository.
     */
    @JvmName("dexpjykasgyxyhea")
    public suspend fun tagFilter(`value`: Output<String>) {
        this.tagFilter = value
    }

    /**
     * @param value ID of Container Registry Enterprise Edition target instance to be synchronized.
     */
    @JvmName("bagofcnknpdncrmw")
    public suspend fun targetInstanceId(`value`: Output<String>) {
        this.targetInstanceId = value
    }

    /**
     * @param value Name of Container Registry Enterprise Edition target namespace to be synchronized. It can contain 2 to 30 characters.
     */
    @JvmName("dimroygrpagkoyxc")
    public suspend fun targetNamespaceName(`value`: Output<String>) {
        this.targetNamespaceName = value
    }

    /**
     * @param value The target region to be synchronized.
     */
    @JvmName("bcjlggissoqstgjh")
    public suspend fun targetRegionId(`value`: Output<String>) {
        this.targetRegionId = value
    }

    /**
     * @param value Name of the target repository.
     */
    @JvmName("ttpsplplpcwvplrw")
    public suspend fun targetRepoName(`value`: Output<String>) {
        this.targetRepoName = value
    }

    /**
     * @param value ID of Container Registry Enterprise Edition source instance.
     */
    @JvmName("hefeivkekqljyayf")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Name of Container Registry Enterprise Edition sync rule.
     */
    @JvmName("nstgxuypbtmrjoro")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of Container Registry Enterprise Edition source namespace. It can contain 2 to 30 characters.
     */
    @JvmName("bjsnjovcdnbvxhtl")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the source repository which should be set together with `target_repo_name`, if empty means that the synchronization scope is the entire namespace level.
     */
    @JvmName("hlycfcalifaesohp")
    public suspend fun repoName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repoName = mapped
    }

    /**
     * @param value The regular expression used to filter image tags for synchronization in the source repository.
     */
    @JvmName("onwnuuviiumnmkpg")
    public suspend fun tagFilter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagFilter = mapped
    }

    /**
     * @param value ID of Container Registry Enterprise Edition target instance to be synchronized.
     */
    @JvmName("jkuniedvmanrbrvn")
    public suspend fun targetInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetInstanceId = mapped
    }

    /**
     * @param value Name of Container Registry Enterprise Edition target namespace to be synchronized. It can contain 2 to 30 characters.
     */
    @JvmName("pqbulsfxgqnkycwp")
    public suspend fun targetNamespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetNamespaceName = mapped
    }

    /**
     * @param value The target region to be synchronized.
     */
    @JvmName("khymfbmjkksbhiwu")
    public suspend fun targetRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetRegionId = mapped
    }

    /**
     * @param value Name of the target repository.
     */
    @JvmName("ckeeorsebfshwgqj")
    public suspend fun targetRepoName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetRepoName = mapped
    }

    internal fun build(): RegistryEnterpriseSyncRuleArgs = RegistryEnterpriseSyncRuleArgs(
        instanceId = instanceId,
        name = name,
        namespaceName = namespaceName,
        repoName = repoName,
        tagFilter = tagFilter,
        targetInstanceId = targetInstanceId,
        targetNamespaceName = targetNamespaceName,
        targetRegionId = targetRegionId,
        targetRepoName = targetRepoName,
    )
}
