@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.kotlin.outputs.ServerlessKubernetesAddon
import com.pulumi.alicloud.cs.kotlin.outputs.ServerlessKubernetesRrsaMetadata
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.cs.kotlin.outputs.ServerlessKubernetesAddon.Companion.toKotlin as serverlessKubernetesAddonToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.ServerlessKubernetesRrsaMetadata.Companion.toKotlin as serverlessKubernetesRrsaMetadataToKotlin

/**
 * Builder for [ServerlessKubernetes].
 */
@PulumiTagMarker
public class ServerlessKubernetesResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerlessKubernetesArgs = ServerlessKubernetesArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerlessKubernetesArgsBuilder.() -> Unit) {
        val builder = ServerlessKubernetesArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerlessKubernetes {
        val builtJavaResource = com.pulumi.alicloud.cs.ServerlessKubernetes(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServerlessKubernetes(builtJavaResource)
    }
}

/**
 * This resource will help you to manager a Serverless Kubernetes Cluster, see [What is serverless kubernetes](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/developer-reference/create-a-dedicated-kubernetes-cluster-that-supports-sandboxed-containers). The cluster is same as container service created by web console.
 * > **NOTE:** Available since v1.58.0.
 * > **NOTE:** Serverless Kubernetes cluster only supports VPC network and it can access internet while creating kubernetes cluster.
 * A Nat Gateway and configuring a SNAT for it can ensure one VPC network access internet. If there is no nat gateway in the
 * VPC, you can set `new_nat_gateway` to "true" to create one automatically.
 * > **NOTE:** Creating serverless kubernetes cluster need to install several packages and it will cost about 5 minutes. Please be patient.
 * > **NOTE:** The provider supports to download kube config, client certificate, client key and cluster ca certificate
 * after creating cluster successfully, and you can put them into the specified location, like '~/.kube/config'.
 * > **NOTE:** If you want to manage serverless Kubernetes, you can use Kubernetes Provider.
 * > **NOTE:** You need to activate several other products and confirm Authorization Policy used by Container Service before using this resource.
 * Please refer to the `Authorization management` and `Cluster management` sections in the [Document Center](https://www.alibabacloud.com/help/doc-detail/86488.htm).
 * > **NOTE:** From version 1.162.0, support for creating professional serverless cluster.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "ask-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.1.0.0/21",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "10.1.1.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const serverless = new alicloud.cs.ServerlessKubernetes("serverless", {
 *     namePrefix: name,
 *     clusterSpec: "ack.pro.small",
 *     vpcId: defaultNetwork.id,
 *     vswitchIds: [defaultSwitch&#46;id],
 *     newNatGateway: true,
 *     endpointPublicAccessEnabled: true,
 *     deletionProtection: false,
 *     loadBalancerSpec: "slb.s2.small",
 *     timeZone: "Asia/Shanghai",
 *     serviceCidr: "172.21.0.0/20",
 *     serviceDiscoveryTypes: ["PrivateZone"],
 *     loggingType: "SLS",
 *     tags: {
 *         "k-aa": "v-aa",
 *         "k-bb": "v-aa",
 *     },
 *     addons: [
 *         {
 *             name: "alb-ingress-controller",
 *         },
 *         {
 *             name: "metrics-server",
 *         },
 *         {
 *             name: "knative",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "ask-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.1.0.0/21")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     vpc_id=default_network.id,
 *     cidr_block="10.1.1.0/24",
 *     zone_id=default.zones[0].id)
 * serverless = alicloud.cs.ServerlessKubernetes("serverless",
 *     name_prefix=name,
 *     cluster_spec="ack.pro.small",
 *     vpc_id=default_network.id,
 *     vswitch_ids=[default_switch&#46;id],
 *     new_nat_gateway=True,
 *     endpoint_public_access_enabled=True,
 *     deletion_protection=False,
 *     load_balancer_spec="slb.s2.small",
 *     time_zone="Asia/Shanghai",
 *     service_cidr="172.21.0.0/20",
 *     service_discovery_types=["PrivateZone"],
 *     logging_type="SLS",
 *     tags={
 *         "k-aa": "v-aa",
 *         "k-bb": "v-aa",
 *     },
 *     addons=[
 *         {
 *             "name": "alb-ingress-controller",
 *         },
 *         {
 *             "name": "metrics-server",
 *         },
 *         {
 *             "name": "knative",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "ask-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.1.0.0/21",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "10.1.1.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var serverless = new AliCloud.CS.ServerlessKubernetes("serverless", new()
 *     {
 *         NamePrefix = name,
 *         ClusterSpec = "ack.pro.small",
 *         VpcId = defaultNetwork.Id,
 *         VswitchIds = new[]
 *         {
 *             defaultSwitch.Id,
 *         },
 *         NewNatGateway = true,
 *         EndpointPublicAccessEnabled = true,
 *         DeletionProtection = false,
 *         LoadBalancerSpec = "slb.s2.small",
 *         TimeZone = "Asia/Shanghai",
 *         ServiceCidr = "172.21.0.0/20",
 *         ServiceDiscoveryTypes = new[]
 *         {
 *             "PrivateZone",
 *         },
 *         LoggingType = "SLS",
 *         Tags =
 *         {
 *             { "k-aa", "v-aa" },
 *             { "k-bb", "v-aa" },
 *         },
 *         Addons = new[]
 *         {
 *             new AliCloud.CS.Inputs.ServerlessKubernetesAddonArgs
 *             {
 *                 Name = "alb-ingress-controller",
 *             },
 *             new AliCloud.CS.Inputs.ServerlessKubernetesAddonArgs
 *             {
 *                 Name = "metrics-server",
 *             },
 *             new AliCloud.CS.Inputs.ServerlessKubernetesAddonArgs
 *             {
 *                 Name = "knative",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "ask-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.1.0.0/21"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("10.1.1.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cs.NewServerlessKubernetes(ctx, "serverless", &cs.ServerlessKubernetesArgs{
 * 			NamePrefix:  pulumi.String(name),
 * 			ClusterSpec: pulumi.String("ack.pro.small"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			VswitchIds: pulumi.StringArray{
 * 				defaultSwitch.ID(),
 * 			},
 * 			NewNatGateway:               pulumi.Bool(true),
 * 			EndpointPublicAccessEnabled: pulumi.Bool(true),
 * 			DeletionProtection:          pulumi.Bool(false),
 * 			LoadBalancerSpec:            pulumi.String("slb.s2.small"),
 * 			TimeZone:                    pulumi.String("Asia/Shanghai"),
 * 			ServiceCidr:                 pulumi.String("172.21.0.0/20"),
 * 			ServiceDiscoveryTypes: pulumi.StringArray{
 * 				pulumi.String("PrivateZone"),
 * 			},
 * 			LoggingType: pulumi.String("SLS"),
 * 			Tags: pulumi.StringMap{
 * 				"k-aa": pulumi.String("v-aa"),
 * 				"k-bb": pulumi.String("v-aa"),
 * 			},
 * 			Addons: cs.ServerlessKubernetesAddonArray{
 * 				&cs.ServerlessKubernetesAddonArgs{
 * 					Name: pulumi.String("alb-ingress-controller"),
 * 				},
 * 				&cs.ServerlessKubernetesAddonArgs{
 * 					Name: pulumi.String("metrics-server"),
 * 				},
 * 				&cs.ServerlessKubernetesAddonArgs{
 * 					Name: pulumi.String("knative"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.cs.ServerlessKubernetes;
 * import com.pulumi.alicloud.cs.ServerlessKubernetesArgs;
 * import com.pulumi.alicloud.cs.inputs.ServerlessKubernetesAddonArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("ask-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.1.0.0/21")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("10.1.1.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var serverless = new ServerlessKubernetes("serverless", ServerlessKubernetesArgs.builder()
 *             .namePrefix(name)
 *             .clusterSpec("ack.pro.small")
 *             .vpcId(defaultNetwork.id())
 *             .vswitchIds(defaultSwitch.id())
 *             .newNatGateway(true)
 *             .endpointPublicAccessEnabled(true)
 *             .deletionProtection(false)
 *             .loadBalancerSpec("slb.s2.small")
 *             .timeZone("Asia/Shanghai")
 *             .serviceCidr("172.21.0.0/20")
 *             .serviceDiscoveryTypes("PrivateZone")
 *             .loggingType("SLS")
 *             .tags(Map.ofEntries(
 *                 Map.entry("k-aa", "v-aa"),
 *                 Map.entry("k-bb", "v-aa")
 *             ))
 *             .addons(
 *                 ServerlessKubernetesAddonArgs.builder()
 *                     .name("alb-ingress-controller")
 *                     .build(),
 *                 ServerlessKubernetesAddonArgs.builder()
 *                     .name("metrics-server")
 *                     .build(),
 *                 ServerlessKubernetesAddonArgs.builder()
 *                     .name("knative")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: ask-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.1.0.0/21
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 10.1.1.0/24
 *       zoneId: ${default.zones[0].id}
 *   serverless:
 *     type: alicloud:cs:ServerlessKubernetes
 *     properties:
 *       namePrefix: ${name}
 *       clusterSpec: ack.pro.small
 *       vpcId: ${defaultNetwork.id}
 *       vswitchIds:
 *         - ${defaultSwitch.id}
 *       newNatGateway: true
 *       endpointPublicAccessEnabled: true
 *       deletionProtection: false
 *       loadBalancerSpec: slb.s2.small
 *       timeZone: Asia/Shanghai
 *       serviceCidr: 172.21.0.0/20
 *       serviceDiscoveryTypes:
 *         - PrivateZone
 *       loggingType: SLS
 *       tags:
 *         k-aa: v-aa
 *         k-bb: v-aa
 *       addons:
 *         - name: alb-ingress-controller
 *         - name: metrics-server
 *         - name: knative
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Serverless Kubernetes cluster can be imported using the id, e.g. Then complete the main.tf accords to the result of `pulumi preview`.
 * ```sh
 * $ pulumi import alicloud:cs/serverlessKubernetes:ServerlessKubernetes main ce4273f9156874b46bb
 * ```
 */
public class ServerlessKubernetes internal constructor(
    override val javaResource: com.pulumi.alicloud.cs.ServerlessKubernetes,
) : KotlinCustomResource(javaResource, ServerlessKubernetesMapper) {
    /**
     * You can specific network plugin,log component,ingress component and so on. See `addons` below.
     */
    public val addons: Output<List<ServerlessKubernetesAddon>>
        get() = javaResource.addons().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serverlessKubernetesAddonToKotlin(args0)
                })
            })
        })

    /**
     * The path of client certificate, like `~/.kube/client-cert.pem`.
     */
    public val clientCert: Output<String>?
        get() = javaResource.clientCert().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The path of client key, like `~/.kube/client-key.pem`.
     */
    public val clientKey: Output<String>?
        get() = javaResource.clientKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
     */
    public val clusterCaCert: Output<String>?
        get() = javaResource.clusterCaCert().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The cluster specifications of serverless kubernetes cluster, which can be empty. Valid values:
     * - ack.standard: Standard serverless clusters.
     * - ack.pro.small: Professional serverless clusters.
     */
    public val clusterSpec: Output<String>
        get() = javaResource.clusterSpec().applyValue({ args0 -> args0 })

    /**
     * whether to create a v2 version cluster.
     * *Removed params*
     */
    public val createV2Cluster: Output<Boolean>
        get() = javaResource.createV2Cluster().applyValue({ args0 -> args0 })

    /**
     * Whether enable the deletion protection or not.
     * - true: Enable deletion protection.
     * - false: Disable deletion protection.
     */
    public val deletionProtection: Output<Boolean>?
        get() = javaResource.deletionProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enable cluster to support RRSA for version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
     */
    public val enableRrsa: Output<Boolean>?
        get() = javaResource.enableRrsa().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to create internet  eip for API Server. Default to false.
     */
    public val endpointPublicAccessEnabled: Output<Boolean>?
        get() = javaResource.endpointPublicAccessEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Default false, when you want to change `vpc_id` and `vswitch_id`, you have to set this field to true, then the cluster will be recreated.
     */
    public val forceUpdate: Output<Boolean>?
        get() = javaResource.forceUpdate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The path of kube config, like `~/.kube/config`.
     */
    @Deprecated(
        message = """
  Field 'kube_config' has been deprecated from provider version 1.187.0. New DataSource
      'alicloud_cs_cluster_credential' manage your cluster's kube config.
  """,
    )
    public val kubeConfig: Output<String>?
        get() = javaResource.kubeConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The cluster api server load balance instance specification, default `slb.s2.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
     */
    public val loadBalancerSpec: Output<String>
        get() = javaResource.loadBalancerSpec().applyValue({ args0 -> args0 })

    /**
     * Enable log service, Valid value `SLS`.
     */
    public val loggingType: Output<String>?
        get() = javaResource.loggingType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The kubernetes cluster's name. It is the only in one Alicloud account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val namePrefix: Output<String>?
        get() = javaResource.namePrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to create a new nat gateway while creating kubernetes cluster. SNAT must be configured when a new VPC is automatically created. Default is `true`.
     */
    public val newNatGateway: Output<Boolean>?
        get() = javaResource.newNatGateway().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Has been deprecated from provider version 1.123.1. `PrivateZone` is used as the enumeration value of `service_discovery_types`.
     */
    @Deprecated(
        message = """
  Field 'private_zone' has been deprecated from provider version 1.123.1. New field
      'service_discovery_types' replace it.
  """,
    )
    public val privateZone: Output<Boolean>?
        get() = javaResource.privateZone().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    public val retainResources: Output<List<String>>?
        get() = javaResource.retainResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Nested attribute containing RRSA related data for your cluster. See `rrsa_metadata` below.
     */
    public val rrsaMetadata: Output<ServerlessKubernetesRrsaMetadata>
        get() = javaResource.rrsaMetadata().applyValue({ args0 ->
            args0.let({ args0 ->
                serverlessKubernetesRrsaMetadataToKotlin(args0)
            })
        })

    /**
     * The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
     */
    public val securityGroupId: Output<String>
        get() = javaResource.securityGroupId().applyValue({ args0 -> args0 })

    /**
     * CIDR block of the service network. The specified CIDR block cannot overlap with that of the VPC or those of the ACK clusters that are deployed in the VPC. The CIDR block cannot be modified after the cluster is created.
     */
    public val serviceCidr: Output<String>?
        get() = javaResource.serviceCidr().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Service discovery type. If the value is empty, it means that service discovery is not enabled. Valid values are `CoreDNS` and `PrivateZone`.
     */
    public val serviceDiscoveryTypes: Output<List<String>>?
        get() = javaResource.serviceDiscoveryTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * If you use an existing SLS project, you must specify `sls_project_name`.
     */
    public val slsProjectName: Output<String>
        get() = javaResource.slsProjectName().applyValue({ args0 -> args0 })

    /**
     * Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The time zone of the cluster.
     */
    public val timeZone: Output<String>
        get() = javaResource.timeZone().applyValue({ args0 -> args0 })

    /**
     * Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })

    /**
     * The vpc where new kubernetes cluster will be located. Specify one vpc's id, if it is not specified, a new VPC  will be built.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The vswitch where new kubernetes cluster will be located. Specify one vswitch's id, if it is not specified, a new VPC and VSwicth will be built. It must be in the zone which `availability_zone` specified.
     */
    @Deprecated(
        message = """
  Field 'vswitch_id' has been deprecated from provider version 1.91.0. New field 'vswitch_ids'
      replace it.
  """,
    )
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })

    /**
     * The vswitches where new kubernetes cluster will be located.
     */
    public val vswitchIds: Output<List<String>>
        get() = javaResource.vswitchIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * When creating a cluster using automatic VPC creation, you need to specify the zone where the VPC is located.
     */
    public val zoneId: Output<String>?
        get() = javaResource.zoneId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ServerlessKubernetesMapper : ResourceMapper<ServerlessKubernetes> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cs.ServerlessKubernetes::class == javaResource::class

    override fun map(javaResource: Resource): ServerlessKubernetes = ServerlessKubernetes(
        javaResource
            as com.pulumi.alicloud.cs.ServerlessKubernetes,
    )
}

/**
 * @see [ServerlessKubernetes].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerlessKubernetes].
 */
public suspend fun serverlessKubernetes(
    name: String,
    block: suspend ServerlessKubernetesResourceBuilder.() -> Unit,
): ServerlessKubernetes {
    val builder = ServerlessKubernetesResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerlessKubernetes].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverlessKubernetes(name: String): ServerlessKubernetes {
    val builder = ServerlessKubernetesResourceBuilder()
    builder.name(name)
    return builder.build()
}
