@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.ServerlessKubernetesArgs.builder
import com.pulumi.alicloud.cs.kotlin.inputs.ServerlessKubernetesAddonArgs
import com.pulumi.alicloud.cs.kotlin.inputs.ServerlessKubernetesAddonArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.ServerlessKubernetesRrsaMetadataArgs
import com.pulumi.alicloud.cs.kotlin.inputs.ServerlessKubernetesRrsaMetadataArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * This resource will help you to manager a Serverless Kubernetes Cluster, see [What is serverless kubernetes](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/developer-reference/create-a-dedicated-kubernetes-cluster-that-supports-sandboxed-containers). The cluster is same as container service created by web console.
 * > **NOTE:** Available since v1.58.0.
 * > **NOTE:** Serverless Kubernetes cluster only supports VPC network and it can access internet while creating kubernetes cluster.
 * A Nat Gateway and configuring a SNAT for it can ensure one VPC network access internet. If there is no nat gateway in the
 * VPC, you can set `new_nat_gateway` to "true" to create one automatically.
 * > **NOTE:** Creating serverless kubernetes cluster need to install several packages and it will cost about 5 minutes. Please be patient.
 * > **NOTE:** The provider supports to download kube config, client certificate, client key and cluster ca certificate
 * after creating cluster successfully, and you can put them into the specified location, like '~/.kube/config'.
 * > **NOTE:** If you want to manage serverless Kubernetes, you can use Kubernetes Provider.
 * > **NOTE:** You need to activate several other products and confirm Authorization Policy used by Container Service before using this resource.
 * Please refer to the `Authorization management` and `Cluster management` sections in the [Document Center](https://www.alibabacloud.com/help/doc-detail/86488.htm).
 * > **NOTE:** From version 1.162.0, support for creating professional serverless cluster.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "ask-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.1.0.0/21",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "10.1.1.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const serverless = new alicloud.cs.ServerlessKubernetes("serverless", {
 *     namePrefix: name,
 *     clusterSpec: "ack.pro.small",
 *     vpcId: defaultNetwork.id,
 *     vswitchIds: [defaultSwitch&#46;id],
 *     newNatGateway: true,
 *     endpointPublicAccessEnabled: true,
 *     deletionProtection: false,
 *     loadBalancerSpec: "slb.s2.small",
 *     timeZone: "Asia/Shanghai",
 *     serviceCidr: "172.21.0.0/20",
 *     serviceDiscoveryTypes: ["PrivateZone"],
 *     loggingType: "SLS",
 *     tags: {
 *         "k-aa": "v-aa",
 *         "k-bb": "v-aa",
 *     },
 *     addons: [
 *         {
 *             name: "alb-ingress-controller",
 *         },
 *         {
 *             name: "metrics-server",
 *         },
 *         {
 *             name: "knative",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "ask-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.1.0.0/21")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     vpc_id=default_network.id,
 *     cidr_block="10.1.1.0/24",
 *     zone_id=default.zones[0].id)
 * serverless = alicloud.cs.ServerlessKubernetes("serverless",
 *     name_prefix=name,
 *     cluster_spec="ack.pro.small",
 *     vpc_id=default_network.id,
 *     vswitch_ids=[default_switch&#46;id],
 *     new_nat_gateway=True,
 *     endpoint_public_access_enabled=True,
 *     deletion_protection=False,
 *     load_balancer_spec="slb.s2.small",
 *     time_zone="Asia/Shanghai",
 *     service_cidr="172.21.0.0/20",
 *     service_discovery_types=["PrivateZone"],
 *     logging_type="SLS",
 *     tags={
 *         "k-aa": "v-aa",
 *         "k-bb": "v-aa",
 *     },
 *     addons=[
 *         {
 *             "name": "alb-ingress-controller",
 *         },
 *         {
 *             "name": "metrics-server",
 *         },
 *         {
 *             "name": "knative",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "ask-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.1.0.0/21",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "10.1.1.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var serverless = new AliCloud.CS.ServerlessKubernetes("serverless", new()
 *     {
 *         NamePrefix = name,
 *         ClusterSpec = "ack.pro.small",
 *         VpcId = defaultNetwork.Id,
 *         VswitchIds = new[]
 *         {
 *             defaultSwitch.Id,
 *         },
 *         NewNatGateway = true,
 *         EndpointPublicAccessEnabled = true,
 *         DeletionProtection = false,
 *         LoadBalancerSpec = "slb.s2.small",
 *         TimeZone = "Asia/Shanghai",
 *         ServiceCidr = "172.21.0.0/20",
 *         ServiceDiscoveryTypes = new[]
 *         {
 *             "PrivateZone",
 *         },
 *         LoggingType = "SLS",
 *         Tags =
 *         {
 *             { "k-aa", "v-aa" },
 *             { "k-bb", "v-aa" },
 *         },
 *         Addons = new[]
 *         {
 *             new AliCloud.CS.Inputs.ServerlessKubernetesAddonArgs
 *             {
 *                 Name = "alb-ingress-controller",
 *             },
 *             new AliCloud.CS.Inputs.ServerlessKubernetesAddonArgs
 *             {
 *                 Name = "metrics-server",
 *             },
 *             new AliCloud.CS.Inputs.ServerlessKubernetesAddonArgs
 *             {
 *                 Name = "knative",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "ask-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.1.0.0/21"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("10.1.1.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cs.NewServerlessKubernetes(ctx, "serverless", &cs.ServerlessKubernetesArgs{
 * 			NamePrefix:  pulumi.String(name),
 * 			ClusterSpec: pulumi.String("ack.pro.small"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			VswitchIds: pulumi.StringArray{
 * 				defaultSwitch.ID(),
 * 			},
 * 			NewNatGateway:               pulumi.Bool(true),
 * 			EndpointPublicAccessEnabled: pulumi.Bool(true),
 * 			DeletionProtection:          pulumi.Bool(false),
 * 			LoadBalancerSpec:            pulumi.String("slb.s2.small"),
 * 			TimeZone:                    pulumi.String("Asia/Shanghai"),
 * 			ServiceCidr:                 pulumi.String("172.21.0.0/20"),
 * 			ServiceDiscoveryTypes: pulumi.StringArray{
 * 				pulumi.String("PrivateZone"),
 * 			},
 * 			LoggingType: pulumi.String("SLS"),
 * 			Tags: pulumi.StringMap{
 * 				"k-aa": pulumi.String("v-aa"),
 * 				"k-bb": pulumi.String("v-aa"),
 * 			},
 * 			Addons: cs.ServerlessKubernetesAddonArray{
 * 				&cs.ServerlessKubernetesAddonArgs{
 * 					Name: pulumi.String("alb-ingress-controller"),
 * 				},
 * 				&cs.ServerlessKubernetesAddonArgs{
 * 					Name: pulumi.String("metrics-server"),
 * 				},
 * 				&cs.ServerlessKubernetesAddonArgs{
 * 					Name: pulumi.String("knative"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.cs.ServerlessKubernetes;
 * import com.pulumi.alicloud.cs.ServerlessKubernetesArgs;
 * import com.pulumi.alicloud.cs.inputs.ServerlessKubernetesAddonArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("ask-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.1.0.0/21")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("10.1.1.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var serverless = new ServerlessKubernetes("serverless", ServerlessKubernetesArgs.builder()
 *             .namePrefix(name)
 *             .clusterSpec("ack.pro.small")
 *             .vpcId(defaultNetwork.id())
 *             .vswitchIds(defaultSwitch.id())
 *             .newNatGateway(true)
 *             .endpointPublicAccessEnabled(true)
 *             .deletionProtection(false)
 *             .loadBalancerSpec("slb.s2.small")
 *             .timeZone("Asia/Shanghai")
 *             .serviceCidr("172.21.0.0/20")
 *             .serviceDiscoveryTypes("PrivateZone")
 *             .loggingType("SLS")
 *             .tags(Map.ofEntries(
 *                 Map.entry("k-aa", "v-aa"),
 *                 Map.entry("k-bb", "v-aa")
 *             ))
 *             .addons(
 *                 ServerlessKubernetesAddonArgs.builder()
 *                     .name("alb-ingress-controller")
 *                     .build(),
 *                 ServerlessKubernetesAddonArgs.builder()
 *                     .name("metrics-server")
 *                     .build(),
 *                 ServerlessKubernetesAddonArgs.builder()
 *                     .name("knative")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: ask-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.1.0.0/21
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 10.1.1.0/24
 *       zoneId: ${default.zones[0].id}
 *   serverless:
 *     type: alicloud:cs:ServerlessKubernetes
 *     properties:
 *       namePrefix: ${name}
 *       clusterSpec: ack.pro.small
 *       vpcId: ${defaultNetwork.id}
 *       vswitchIds:
 *         - ${defaultSwitch.id}
 *       newNatGateway: true
 *       endpointPublicAccessEnabled: true
 *       deletionProtection: false
 *       loadBalancerSpec: slb.s2.small
 *       timeZone: Asia/Shanghai
 *       serviceCidr: 172.21.0.0/20
 *       serviceDiscoveryTypes:
 *         - PrivateZone
 *       loggingType: SLS
 *       tags:
 *         k-aa: v-aa
 *         k-bb: v-aa
 *       addons:
 *         - name: alb-ingress-controller
 *         - name: metrics-server
 *         - name: knative
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Serverless Kubernetes cluster can be imported using the id, e.g. Then complete the main.tf accords to the result of `pulumi preview`.
 * ```sh
 * $ pulumi import alicloud:cs/serverlessKubernetes:ServerlessKubernetes main ce4273f9156874b46bb
 * ```
 * @property addons You can specific network plugin,log component,ingress component and so on. See `addons` below.
 * @property clientCert The path of client certificate, like `~/.kube/client-cert.pem`.
 * @property clientKey The path of client key, like `~/.kube/client-key.pem`.
 * @property clusterCaCert The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
 * @property clusterSpec The cluster specifications of serverless kubernetes cluster, which can be empty. Valid values:
 * - ack.standard: Standard serverless clusters.
 * - ack.pro.small: Professional serverless clusters.
 * @property createV2Cluster whether to create a v2 version cluster.
 * *Removed params*
 * @property deletionProtection Whether enable the deletion protection or not.
 * - true: Enable deletion protection.
 * - false: Disable deletion protection.
 * @property enableRrsa Whether to enable cluster to support RRSA for version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
 * @property endpointPublicAccessEnabled Whether to create internet  eip for API Server. Default to false.
 * @property forceUpdate Default false, when you want to change `vpc_id` and `vswitch_id`, you have to set this field to true, then the cluster will be recreated.
 * @property kubeConfig The path of kube config, like `~/.kube/config`.
 * @property loadBalancerSpec The cluster api server load balance instance specification, default `slb.s2.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
 * @property loggingType Enable log service, Valid value `SLS`.
 * @property name The kubernetes cluster's name. It is the only in one Alicloud account.
 * @property namePrefix
 * @property newNatGateway Whether to create a new nat gateway while creating kubernetes cluster. SNAT must be configured when a new VPC is automatically created. Default is `true`.
 * @property privateZone Has been deprecated from provider version 1.123.1. `PrivateZone` is used as the enumeration value of `service_discovery_types`.
 * @property resourceGroupId The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
 * @property retainResources
 * @property rrsaMetadata Nested attribute containing RRSA related data for your cluster. See `rrsa_metadata` below.
 * @property securityGroupId The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
 * @property serviceCidr CIDR block of the service network. The specified CIDR block cannot overlap with that of the VPC or those of the ACK clusters that are deployed in the VPC. The CIDR block cannot be modified after the cluster is created.
 * @property serviceDiscoveryTypes Service discovery type. If the value is empty, it means that service discovery is not enabled. Valid values are `CoreDNS` and `PrivateZone`.
 * @property slsProjectName If you use an existing SLS project, you must specify `sls_project_name`.
 * @property tags Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
 * @property timeZone The time zone of the cluster.
 * @property version Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used.
 * @property vpcId The vpc where new kubernetes cluster will be located. Specify one vpc's id, if it is not specified, a new VPC  will be built.
 * @property vswitchId The vswitch where new kubernetes cluster will be located. Specify one vswitch's id, if it is not specified, a new VPC and VSwicth will be built. It must be in the zone which `availability_zone` specified.
 * @property vswitchIds The vswitches where new kubernetes cluster will be located.
 * @property zoneId When creating a cluster using automatic VPC creation, you need to specify the zone where the VPC is located.
 */
public data class ServerlessKubernetesArgs(
    public val addons: Output<List<ServerlessKubernetesAddonArgs>>? = null,
    public val clientCert: Output<String>? = null,
    public val clientKey: Output<String>? = null,
    public val clusterCaCert: Output<String>? = null,
    public val clusterSpec: Output<String>? = null,
    public val createV2Cluster: Output<Boolean>? = null,
    public val deletionProtection: Output<Boolean>? = null,
    public val enableRrsa: Output<Boolean>? = null,
    public val endpointPublicAccessEnabled: Output<Boolean>? = null,
    public val forceUpdate: Output<Boolean>? = null,
    @Deprecated(
        message = """
  Field 'kube_config' has been deprecated from provider version 1.187.0. New DataSource
      'alicloud_cs_cluster_credential' manage your cluster's kube config.
  """,
    )
    public val kubeConfig: Output<String>? = null,
    public val loadBalancerSpec: Output<String>? = null,
    public val loggingType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val newNatGateway: Output<Boolean>? = null,
    @Deprecated(
        message = """
  Field 'private_zone' has been deprecated from provider version 1.123.1. New field
      'service_discovery_types' replace it.
  """,
    )
    public val privateZone: Output<Boolean>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val retainResources: Output<List<String>>? = null,
    public val rrsaMetadata: Output<ServerlessKubernetesRrsaMetadataArgs>? = null,
    public val securityGroupId: Output<String>? = null,
    public val serviceCidr: Output<String>? = null,
    public val serviceDiscoveryTypes: Output<List<String>>? = null,
    public val slsProjectName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeZone: Output<String>? = null,
    public val version: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'vswitch_id' has been deprecated from provider version 1.91.0. New field 'vswitch_ids'
      replace it.
  """,
    )
    public val vswitchId: Output<String>? = null,
    public val vswitchIds: Output<List<String>>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.ServerlessKubernetesArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.ServerlessKubernetesArgs =
        com.pulumi.alicloud.cs.ServerlessKubernetesArgs.builder()
            .addons(addons?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .clientCert(clientCert?.applyValue({ args0 -> args0 }))
            .clientKey(clientKey?.applyValue({ args0 -> args0 }))
            .clusterCaCert(clusterCaCert?.applyValue({ args0 -> args0 }))
            .clusterSpec(clusterSpec?.applyValue({ args0 -> args0 }))
            .createV2Cluster(createV2Cluster?.applyValue({ args0 -> args0 }))
            .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
            .enableRrsa(enableRrsa?.applyValue({ args0 -> args0 }))
            .endpointPublicAccessEnabled(endpointPublicAccessEnabled?.applyValue({ args0 -> args0 }))
            .forceUpdate(forceUpdate?.applyValue({ args0 -> args0 }))
            .kubeConfig(kubeConfig?.applyValue({ args0 -> args0 }))
            .loadBalancerSpec(loadBalancerSpec?.applyValue({ args0 -> args0 }))
            .loggingType(loggingType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .newNatGateway(newNatGateway?.applyValue({ args0 -> args0 }))
            .privateZone(privateZone?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .retainResources(retainResources?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .rrsaMetadata(rrsaMetadata?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .serviceCidr(serviceCidr?.applyValue({ args0 -> args0 }))
            .serviceDiscoveryTypes(serviceDiscoveryTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .slsProjectName(slsProjectName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .vswitchIds(vswitchIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerlessKubernetesArgs].
 */
@PulumiTagMarker
public class ServerlessKubernetesArgsBuilder internal constructor() {
    private var addons: Output<List<ServerlessKubernetesAddonArgs>>? = null

    private var clientCert: Output<String>? = null

    private var clientKey: Output<String>? = null

    private var clusterCaCert: Output<String>? = null

    private var clusterSpec: Output<String>? = null

    private var createV2Cluster: Output<Boolean>? = null

    private var deletionProtection: Output<Boolean>? = null

    private var enableRrsa: Output<Boolean>? = null

    private var endpointPublicAccessEnabled: Output<Boolean>? = null

    private var forceUpdate: Output<Boolean>? = null

    private var kubeConfig: Output<String>? = null

    private var loadBalancerSpec: Output<String>? = null

    private var loggingType: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var newNatGateway: Output<Boolean>? = null

    private var privateZone: Output<Boolean>? = null

    private var resourceGroupId: Output<String>? = null

    private var retainResources: Output<List<String>>? = null

    private var rrsaMetadata: Output<ServerlessKubernetesRrsaMetadataArgs>? = null

    private var securityGroupId: Output<String>? = null

    private var serviceCidr: Output<String>? = null

    private var serviceDiscoveryTypes: Output<List<String>>? = null

    private var slsProjectName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeZone: Output<String>? = null

    private var version: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var vswitchIds: Output<List<String>>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value You can specific network plugin,log component,ingress component and so on. See `addons` below.
     */
    @JvmName("ktipatfrmpkrslaf")
    public suspend fun addons(`value`: Output<List<ServerlessKubernetesAddonArgs>>) {
        this.addons = value
    }

    @JvmName("pdqlowmhtungwmgb")
    public suspend fun addons(vararg values: Output<ServerlessKubernetesAddonArgs>) {
        this.addons = Output.all(values.asList())
    }

    /**
     * @param values You can specific network plugin,log component,ingress component and so on. See `addons` below.
     */
    @JvmName("agfyrjhsmyxutmfs")
    public suspend fun addons(values: List<Output<ServerlessKubernetesAddonArgs>>) {
        this.addons = Output.all(values)
    }

    /**
     * @param value The path of client certificate, like `~/.kube/client-cert.pem`.
     */
    @JvmName("kxoyixqakjiviorp")
    public suspend fun clientCert(`value`: Output<String>) {
        this.clientCert = value
    }

    /**
     * @param value The path of client key, like `~/.kube/client-key.pem`.
     */
    @JvmName("yvnexnhoqufwgvxu")
    public suspend fun clientKey(`value`: Output<String>) {
        this.clientKey = value
    }

    /**
     * @param value The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
     */
    @JvmName("rlrstfnogqdlaaxk")
    public suspend fun clusterCaCert(`value`: Output<String>) {
        this.clusterCaCert = value
    }

    /**
     * @param value The cluster specifications of serverless kubernetes cluster, which can be empty. Valid values:
     * - ack.standard: Standard serverless clusters.
     * - ack.pro.small: Professional serverless clusters.
     */
    @JvmName("dvgisyakpdqmlhsp")
    public suspend fun clusterSpec(`value`: Output<String>) {
        this.clusterSpec = value
    }

    /**
     * @param value whether to create a v2 version cluster.
     * *Removed params*
     */
    @JvmName("chfdoyivvhbhpjwq")
    public suspend fun createV2Cluster(`value`: Output<Boolean>) {
        this.createV2Cluster = value
    }

    /**
     * @param value Whether enable the deletion protection or not.
     * - true: Enable deletion protection.
     * - false: Disable deletion protection.
     */
    @JvmName("bkifysgyqbcwhfpt")
    public suspend fun deletionProtection(`value`: Output<Boolean>) {
        this.deletionProtection = value
    }

    /**
     * @param value Whether to enable cluster to support RRSA for version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
     */
    @JvmName("cqoybhnopleakgxa")
    public suspend fun enableRrsa(`value`: Output<Boolean>) {
        this.enableRrsa = value
    }

    /**
     * @param value Whether to create internet  eip for API Server. Default to false.
     */
    @JvmName("udadeoxlduwkswpc")
    public suspend fun endpointPublicAccessEnabled(`value`: Output<Boolean>) {
        this.endpointPublicAccessEnabled = value
    }

    /**
     * @param value Default false, when you want to change `vpc_id` and `vswitch_id`, you have to set this field to true, then the cluster will be recreated.
     */
    @JvmName("qmmbvbjejowwohua")
    public suspend fun forceUpdate(`value`: Output<Boolean>) {
        this.forceUpdate = value
    }

    /**
     * @param value The path of kube config, like `~/.kube/config`.
     */
    @Deprecated(
        message = """
  Field 'kube_config' has been deprecated from provider version 1.187.0. New DataSource
      'alicloud_cs_cluster_credential' manage your cluster's kube config.
  """,
    )
    @JvmName("hoirasaimrjiatya")
    public suspend fun kubeConfig(`value`: Output<String>) {
        this.kubeConfig = value
    }

    /**
     * @param value The cluster api server load balance instance specification, default `slb.s2.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
     */
    @JvmName("xifxpytoxgnlfxyu")
    public suspend fun loadBalancerSpec(`value`: Output<String>) {
        this.loadBalancerSpec = value
    }

    /**
     * @param value Enable log service, Valid value `SLS`.
     */
    @JvmName("tsvhfoyfvbgoseij")
    public suspend fun loggingType(`value`: Output<String>) {
        this.loggingType = value
    }

    /**
     * @param value The kubernetes cluster's name. It is the only in one Alicloud account.
     */
    @JvmName("bdscjobytxnukcng")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("pgeyqbqisqbjftme")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Whether to create a new nat gateway while creating kubernetes cluster. SNAT must be configured when a new VPC is automatically created. Default is `true`.
     */
    @JvmName("jsjtpafdasrwhrnx")
    public suspend fun newNatGateway(`value`: Output<Boolean>) {
        this.newNatGateway = value
    }

    /**
     * @param value Has been deprecated from provider version 1.123.1. `PrivateZone` is used as the enumeration value of `service_discovery_types`.
     */
    @Deprecated(
        message = """
  Field 'private_zone' has been deprecated from provider version 1.123.1. New field
      'service_discovery_types' replace it.
  """,
    )
    @JvmName("vaskhyirstlynyje")
    public suspend fun privateZone(`value`: Output<Boolean>) {
        this.privateZone = value
    }

    /**
     * @param value The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
     */
    @JvmName("hupmdvafdrggtgnr")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value
     */
    @JvmName("edwvtuyojbgofjxf")
    public suspend fun retainResources(`value`: Output<List<String>>) {
        this.retainResources = value
    }

    @JvmName("draqopucmmkmxksd")
    public suspend fun retainResources(vararg values: Output<String>) {
        this.retainResources = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("hhnrydnwcioatktd")
    public suspend fun retainResources(values: List<Output<String>>) {
        this.retainResources = Output.all(values)
    }

    /**
     * @param value Nested attribute containing RRSA related data for your cluster. See `rrsa_metadata` below.
     */
    @JvmName("ksceixhyqsvylcxw")
    public suspend fun rrsaMetadata(`value`: Output<ServerlessKubernetesRrsaMetadataArgs>) {
        this.rrsaMetadata = value
    }

    /**
     * @param value The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
     */
    @JvmName("fbitbydmlkpynpcx")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value CIDR block of the service network. The specified CIDR block cannot overlap with that of the VPC or those of the ACK clusters that are deployed in the VPC. The CIDR block cannot be modified after the cluster is created.
     */
    @JvmName("sdqcwqjigaytmywi")
    public suspend fun serviceCidr(`value`: Output<String>) {
        this.serviceCidr = value
    }

    /**
     * @param value Service discovery type. If the value is empty, it means that service discovery is not enabled. Valid values are `CoreDNS` and `PrivateZone`.
     */
    @JvmName("bvbxynunbyjehskq")
    public suspend fun serviceDiscoveryTypes(`value`: Output<List<String>>) {
        this.serviceDiscoveryTypes = value
    }

    @JvmName("hymuvnpiktetoomd")
    public suspend fun serviceDiscoveryTypes(vararg values: Output<String>) {
        this.serviceDiscoveryTypes = Output.all(values.asList())
    }

    /**
     * @param values Service discovery type. If the value is empty, it means that service discovery is not enabled. Valid values are `CoreDNS` and `PrivateZone`.
     */
    @JvmName("jhakdxicrgqecruk")
    public suspend fun serviceDiscoveryTypes(values: List<Output<String>>) {
        this.serviceDiscoveryTypes = Output.all(values)
    }

    /**
     * @param value If you use an existing SLS project, you must specify `sls_project_name`.
     */
    @JvmName("tadiinaiwpbcrxtp")
    public suspend fun slsProjectName(`value`: Output<String>) {
        this.slsProjectName = value
    }

    /**
     * @param value Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
     */
    @JvmName("vkgrlifpuqmbojki")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The time zone of the cluster.
     */
    @JvmName("limxycpoebfsotva")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used.
     */
    @JvmName("qwmcjbnbykevvhst")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The vpc where new kubernetes cluster will be located. Specify one vpc's id, if it is not specified, a new VPC  will be built.
     */
    @JvmName("aevraarnciloxpnq")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The vswitch where new kubernetes cluster will be located. Specify one vswitch's id, if it is not specified, a new VPC and VSwicth will be built. It must be in the zone which `availability_zone` specified.
     */
    @Deprecated(
        message = """
  Field 'vswitch_id' has been deprecated from provider version 1.91.0. New field 'vswitch_ids'
      replace it.
  """,
    )
    @JvmName("vjahitiqadbadvdj")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The vswitches where new kubernetes cluster will be located.
     */
    @JvmName("nnomgyfolwephstx")
    public suspend fun vswitchIds(`value`: Output<List<String>>) {
        this.vswitchIds = value
    }

    @JvmName("lsnlopsrjxcudrfw")
    public suspend fun vswitchIds(vararg values: Output<String>) {
        this.vswitchIds = Output.all(values.asList())
    }

    /**
     * @param values The vswitches where new kubernetes cluster will be located.
     */
    @JvmName("gcxrambgpgxkjobw")
    public suspend fun vswitchIds(values: List<Output<String>>) {
        this.vswitchIds = Output.all(values)
    }

    /**
     * @param value When creating a cluster using automatic VPC creation, you need to specify the zone where the VPC is located.
     */
    @JvmName("wqkbrmuncowxrbty")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value You can specific network plugin,log component,ingress component and so on. See `addons` below.
     */
    @JvmName("kdmrxvvgjonlwoud")
    public suspend fun addons(`value`: List<ServerlessKubernetesAddonArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addons = mapped
    }

    /**
     * @param argument You can specific network plugin,log component,ingress component and so on. See `addons` below.
     */
    @JvmName("qscktoxyvocuprkb")
    public suspend fun addons(argument: List<suspend ServerlessKubernetesAddonArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServerlessKubernetesAddonArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.addons = mapped
    }

    /**
     * @param argument You can specific network plugin,log component,ingress component and so on. See `addons` below.
     */
    @JvmName("psmeiiwinhhcwtrs")
    public suspend fun addons(vararg argument: suspend ServerlessKubernetesAddonArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServerlessKubernetesAddonArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.addons = mapped
    }

    /**
     * @param argument You can specific network plugin,log component,ingress component and so on. See `addons` below.
     */
    @JvmName("dlxvxwqdjchbnjnk")
    public suspend fun addons(argument: suspend ServerlessKubernetesAddonArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServerlessKubernetesAddonArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.addons = mapped
    }

    /**
     * @param values You can specific network plugin,log component,ingress component and so on. See `addons` below.
     */
    @JvmName("puwmroisnauflhug")
    public suspend fun addons(vararg values: ServerlessKubernetesAddonArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addons = mapped
    }

    /**
     * @param value The path of client certificate, like `~/.kube/client-cert.pem`.
     */
    @JvmName("kesnbudmxbvbmowy")
    public suspend fun clientCert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCert = mapped
    }

    /**
     * @param value The path of client key, like `~/.kube/client-key.pem`.
     */
    @JvmName("ygovekcewldjvoua")
    public suspend fun clientKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientKey = mapped
    }

    /**
     * @param value The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
     */
    @JvmName("vttthbvsvvwimycb")
    public suspend fun clusterCaCert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterCaCert = mapped
    }

    /**
     * @param value The cluster specifications of serverless kubernetes cluster, which can be empty. Valid values:
     * - ack.standard: Standard serverless clusters.
     * - ack.pro.small: Professional serverless clusters.
     */
    @JvmName("hbxrgodwnburesvx")
    public suspend fun clusterSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterSpec = mapped
    }

    /**
     * @param value whether to create a v2 version cluster.
     * *Removed params*
     */
    @JvmName("yqwjxjonllkoauto")
    public suspend fun createV2Cluster(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createV2Cluster = mapped
    }

    /**
     * @param value Whether enable the deletion protection or not.
     * - true: Enable deletion protection.
     * - false: Disable deletion protection.
     */
    @JvmName("aslgjxmmrjdubkod")
    public suspend fun deletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value Whether to enable cluster to support RRSA for version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
     */
    @JvmName("slrldxxrwsoelcal")
    public suspend fun enableRrsa(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRrsa = mapped
    }

    /**
     * @param value Whether to create internet  eip for API Server. Default to false.
     */
    @JvmName("rypckidogflmfatj")
    public suspend fun endpointPublicAccessEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointPublicAccessEnabled = mapped
    }

    /**
     * @param value Default false, when you want to change `vpc_id` and `vswitch_id`, you have to set this field to true, then the cluster will be recreated.
     */
    @JvmName("tnjcledbvasnrpvh")
    public suspend fun forceUpdate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpdate = mapped
    }

    /**
     * @param value The path of kube config, like `~/.kube/config`.
     */
    @Deprecated(
        message = """
  Field 'kube_config' has been deprecated from provider version 1.187.0. New DataSource
      'alicloud_cs_cluster_credential' manage your cluster's kube config.
  """,
    )
    @JvmName("rwkfrirfymwjtqfr")
    public suspend fun kubeConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubeConfig = mapped
    }

    /**
     * @param value The cluster api server load balance instance specification, default `slb.s2.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
     */
    @JvmName("tivruejnfhuoseqo")
    public suspend fun loadBalancerSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerSpec = mapped
    }

    /**
     * @param value Enable log service, Valid value `SLS`.
     */
    @JvmName("kwdadmddoppxqpde")
    public suspend fun loggingType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingType = mapped
    }

    /**
     * @param value The kubernetes cluster's name. It is the only in one Alicloud account.
     */
    @JvmName("wdtotvlartefxtyp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("ammylddeyotrirmb")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Whether to create a new nat gateway while creating kubernetes cluster. SNAT must be configured when a new VPC is automatically created. Default is `true`.
     */
    @JvmName("otkjnsoojbambojx")
    public suspend fun newNatGateway(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newNatGateway = mapped
    }

    /**
     * @param value Has been deprecated from provider version 1.123.1. `PrivateZone` is used as the enumeration value of `service_discovery_types`.
     */
    @Deprecated(
        message = """
  Field 'private_zone' has been deprecated from provider version 1.123.1. New field
      'service_discovery_types' replace it.
  """,
    )
    @JvmName("ggaopihybjuchwxf")
    public suspend fun privateZone(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateZone = mapped
    }

    /**
     * @param value The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
     */
    @JvmName("smmwlgxwtcnaxrhh")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("odwhdfrfnxvcdiju")
    public suspend fun retainResources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retainResources = mapped
    }

    /**
     * @param values
     */
    @JvmName("adsfquglprkhtwip")
    public suspend fun retainResources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retainResources = mapped
    }

    /**
     * @param value Nested attribute containing RRSA related data for your cluster. See `rrsa_metadata` below.
     */
    @JvmName("hsydkxgmkijbjiig")
    public suspend fun rrsaMetadata(`value`: ServerlessKubernetesRrsaMetadataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rrsaMetadata = mapped
    }

    /**
     * @param argument Nested attribute containing RRSA related data for your cluster. See `rrsa_metadata` below.
     */
    @JvmName("myyruiqusfpvuvnv")
    public suspend fun rrsaMetadata(argument: suspend ServerlessKubernetesRrsaMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = ServerlessKubernetesRrsaMetadataArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rrsaMetadata = mapped
    }

    /**
     * @param value The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
     */
    @JvmName("ogllrvwhedkbfxfo")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value CIDR block of the service network. The specified CIDR block cannot overlap with that of the VPC or those of the ACK clusters that are deployed in the VPC. The CIDR block cannot be modified after the cluster is created.
     */
    @JvmName("drtakhqiafyyswfh")
    public suspend fun serviceCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceCidr = mapped
    }

    /**
     * @param value Service discovery type. If the value is empty, it means that service discovery is not enabled. Valid values are `CoreDNS` and `PrivateZone`.
     */
    @JvmName("upatriuiauenjfsj")
    public suspend fun serviceDiscoveryTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceDiscoveryTypes = mapped
    }

    /**
     * @param values Service discovery type. If the value is empty, it means that service discovery is not enabled. Valid values are `CoreDNS` and `PrivateZone`.
     */
    @JvmName("oobouqvkybrkgvss")
    public suspend fun serviceDiscoveryTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceDiscoveryTypes = mapped
    }

    /**
     * @param value If you use an existing SLS project, you must specify `sls_project_name`.
     */
    @JvmName("ogmxturkafheyfed")
    public suspend fun slsProjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slsProjectName = mapped
    }

    /**
     * @param value Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
     */
    @JvmName("bciiwbjisamridvp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
     */
    @JvmName("kwcmngetbnpljwgx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The time zone of the cluster.
     */
    @JvmName("qarucpvckghnrhap")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    /**
     * @param value Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used.
     */
    @JvmName("tvehbjxoaicoattl")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value The vpc where new kubernetes cluster will be located. Specify one vpc's id, if it is not specified, a new VPC  will be built.
     */
    @JvmName("gexwnxfxxodsxubh")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The vswitch where new kubernetes cluster will be located. Specify one vswitch's id, if it is not specified, a new VPC and VSwicth will be built. It must be in the zone which `availability_zone` specified.
     */
    @Deprecated(
        message = """
  Field 'vswitch_id' has been deprecated from provider version 1.91.0. New field 'vswitch_ids'
      replace it.
  """,
    )
    @JvmName("meqnyklvwcgmsnbt")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The vswitches where new kubernetes cluster will be located.
     */
    @JvmName("oollqentlaavcamc")
    public suspend fun vswitchIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchIds = mapped
    }

    /**
     * @param values The vswitches where new kubernetes cluster will be located.
     */
    @JvmName("cabbtpwcfhupjydr")
    public suspend fun vswitchIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitchIds = mapped
    }

    /**
     * @param value When creating a cluster using automatic VPC creation, you need to specify the zone where the VPC is located.
     */
    @JvmName("yplbufllyjecjpwa")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): ServerlessKubernetesArgs = ServerlessKubernetesArgs(
        addons = addons,
        clientCert = clientCert,
        clientKey = clientKey,
        clusterCaCert = clusterCaCert,
        clusterSpec = clusterSpec,
        createV2Cluster = createV2Cluster,
        deletionProtection = deletionProtection,
        enableRrsa = enableRrsa,
        endpointPublicAccessEnabled = endpointPublicAccessEnabled,
        forceUpdate = forceUpdate,
        kubeConfig = kubeConfig,
        loadBalancerSpec = loadBalancerSpec,
        loggingType = loggingType,
        name = name,
        namePrefix = namePrefix,
        newNatGateway = newNatGateway,
        privateZone = privateZone,
        resourceGroupId = resourceGroupId,
        retainResources = retainResources,
        rrsaMetadata = rrsaMetadata,
        securityGroupId = securityGroupId,
        serviceCidr = serviceCidr,
        serviceDiscoveryTypes = serviceDiscoveryTypes,
        slsProjectName = slsProjectName,
        tags = tags,
        timeZone = timeZone,
        version = version,
        vpcId = vpcId,
        vswitchId = vswitchId,
        vswitchIds = vswitchIds,
        zoneId = zoneId,
    )
}
