@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.EdgeKubernetesLogConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property project Log Service project name, cluster logs will output to this project.
 * @property type Type of collecting logs, only `SLS` are supported currently.
 */
public data class EdgeKubernetesLogConfigArgs(
    public val project: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.EdgeKubernetesLogConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.EdgeKubernetesLogConfigArgs =
        com.pulumi.alicloud.cs.inputs.EdgeKubernetesLogConfigArgs.builder()
            .project(project?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EdgeKubernetesLogConfigArgs].
 */
@PulumiTagMarker
public class EdgeKubernetesLogConfigArgsBuilder internal constructor() {
    private var project: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Log Service project name, cluster logs will output to this project.
     */
    @JvmName("myvocmelvgvfjtwn")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Type of collecting logs, only `SLS` are supported currently.
     */
    @JvmName("yummtftujinqenjg")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Log Service project name, cluster logs will output to this project.
     */
    @JvmName("pnjeojokbneqinwl")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Type of collecting logs, only `SLS` are supported currently.
     */
    @JvmName("psyrstohweoqkdof")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EdgeKubernetesLogConfigArgs = EdgeKubernetesLogConfigArgs(
        project = project,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
