@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.EdgeKubernetesRuntimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the runtime. Supported runtimes can be queried by data source alicloud_cs_kubernetes_version.
 * @property version The version of the runtime.
 * The following example is the definition of runtime block:
 * ```
 * runtime = {
 * name = "containerd"
 * version = "1.6.28"
 * }
 * ```
 */
public data class EdgeKubernetesRuntimeArgs(
    public val name: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.EdgeKubernetesRuntimeArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.EdgeKubernetesRuntimeArgs =
        com.pulumi.alicloud.cs.inputs.EdgeKubernetesRuntimeArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EdgeKubernetesRuntimeArgs].
 */
@PulumiTagMarker
public class EdgeKubernetesRuntimeArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value The name of the runtime. Supported runtimes can be queried by data source alicloud_cs_kubernetes_version.
     */
    @JvmName("gapjiheyclrqlexi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The version of the runtime.
     * The following example is the definition of runtime block:
     * ```
     * runtime = {
     * name = "containerd"
     * version = "1.6.28"
     * }
     * ```
     */
    @JvmName("booslmnkwpkixgtm")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The name of the runtime. Supported runtimes can be queried by data source alicloud_cs_kubernetes_version.
     */
    @JvmName("sqowujhfjkysqnch")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The version of the runtime.
     * The following example is the definition of runtime block:
     * ```
     * runtime = {
     * name = "containerd"
     * version = "1.6.28"
     * }
     * ```
     */
    @JvmName("tkobaeyefsjiqxsf")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): EdgeKubernetesRuntimeArgs = EdgeKubernetesRuntimeArgs(
        name = name,
        version = version,
    )
}
