@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.EdgeKubernetesWorkerDataDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property autoSnapshotPolicyId Worker node data disk auto snapshot policy.
 * @property category The type of the data disks. Valid values: `cloud`, `cloud_efficiency`, `cloud_ssd` and `cloud_essd`. Default to `cloud_efficiency`.
 * @property device The device of the data disks.
 * @property encrypted Specifies whether to encrypt data disks. Valid values: true and false. Default is `false`.
 * @property kmsKeyId The id of the kms key.
 * @property name The name of the data disks.
 * @property performanceLevel Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
 * @property size The size of a data disk, at least 40. Unit: GiB.
 * @property snapshotId The id of snapshot.
 */
public data class EdgeKubernetesWorkerDataDiskArgs(
    public val autoSnapshotPolicyId: Output<String>? = null,
    public val category: Output<String>? = null,
    public val device: Output<String>? = null,
    public val encrypted: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val performanceLevel: Output<String>? = null,
    public val size: Output<String>? = null,
    public val snapshotId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.EdgeKubernetesWorkerDataDiskArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.EdgeKubernetesWorkerDataDiskArgs =
        com.pulumi.alicloud.cs.inputs.EdgeKubernetesWorkerDataDiskArgs.builder()
            .autoSnapshotPolicyId(autoSnapshotPolicyId?.applyValue({ args0 -> args0 }))
            .category(category?.applyValue({ args0 -> args0 }))
            .device(device?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .performanceLevel(performanceLevel?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EdgeKubernetesWorkerDataDiskArgs].
 */
@PulumiTagMarker
public class EdgeKubernetesWorkerDataDiskArgsBuilder internal constructor() {
    private var autoSnapshotPolicyId: Output<String>? = null

    private var category: Output<String>? = null

    private var device: Output<String>? = null

    private var encrypted: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var performanceLevel: Output<String>? = null

    private var size: Output<String>? = null

    private var snapshotId: Output<String>? = null

    /**
     * @param value Worker node data disk auto snapshot policy.
     */
    @JvmName("hdmnxcudaudrufrw")
    public suspend fun autoSnapshotPolicyId(`value`: Output<String>) {
        this.autoSnapshotPolicyId = value
    }

    /**
     * @param value The type of the data disks. Valid values: `cloud`, `cloud_efficiency`, `cloud_ssd` and `cloud_essd`. Default to `cloud_efficiency`.
     */
    @JvmName("tjppbmgvbxurxvyc")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value The device of the data disks.
     */
    @JvmName("tnaxsyewwglqsppu")
    public suspend fun device(`value`: Output<String>) {
        this.device = value
    }

    /**
     * @param value Specifies whether to encrypt data disks. Valid values: true and false. Default is `false`.
     */
    @JvmName("nkbxrykxubqvehwb")
    public suspend fun encrypted(`value`: Output<String>) {
        this.encrypted = value
    }

    /**
     * @param value The id of the kms key.
     */
    @JvmName("fcothgpbknmsdehd")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The name of the data disks.
     */
    @JvmName("kovavhltjhftimoh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
     */
    @JvmName("pqjjvavtvpbqcxiy")
    public suspend fun performanceLevel(`value`: Output<String>) {
        this.performanceLevel = value
    }

    /**
     * @param value The size of a data disk, at least 40. Unit: GiB.
     */
    @JvmName("exuyvrujhrxlnpki")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value The id of snapshot.
     */
    @JvmName("bgramdexegquvtht")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value Worker node data disk auto snapshot policy.
     */
    @JvmName("qwctbifwvvnedqhd")
    public suspend fun autoSnapshotPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoSnapshotPolicyId = mapped
    }

    /**
     * @param value The type of the data disks. Valid values: `cloud`, `cloud_efficiency`, `cloud_ssd` and `cloud_essd`. Default to `cloud_efficiency`.
     */
    @JvmName("wbowslfgesgcluby")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The device of the data disks.
     */
    @JvmName("mcruxwwigpfpyubu")
    public suspend fun device(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.device = mapped
    }

    /**
     * @param value Specifies whether to encrypt data disks. Valid values: true and false. Default is `false`.
     */
    @JvmName("ithaydunjtmwwxem")
    public suspend fun encrypted(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value The id of the kms key.
     */
    @JvmName("hbhnujgtaomvkmsi")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The name of the data disks.
     */
    @JvmName("sfldunqsgdvsybml")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
     */
    @JvmName("poglirwsbujjfxxr")
    public suspend fun performanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceLevel = mapped
    }

    /**
     * @param value The size of a data disk, at least 40. Unit: GiB.
     */
    @JvmName("aykrqndtdmawrgwc")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The id of snapshot.
     */
    @JvmName("oxvrpfmmqnfatrdb")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    internal fun build(): EdgeKubernetesWorkerDataDiskArgs = EdgeKubernetesWorkerDataDiskArgs(
        autoSnapshotPolicyId = autoSnapshotPolicyId,
        category = category,
        device = device,
        encrypted = encrypted,
        kmsKeyId = kmsKeyId,
        name = name,
        performanceLevel = performanceLevel,
        size = size,
        snapshotId = snapshotId,
    )
}
