@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.GetAckServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAckService.
 * @property enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
 * @property type Types of services opened. Valid values: `propayasgo`: Container service ack Pro managed version, `edgepayasgo`: Edge container service, `gspayasgo`: Gene computing services.
 * > **NOTE:** Setting `enable = "On"` to open the Container Service (CS) service that means you have read and agreed the [Container Service (CS) Terms of Service](https://help.aliyun.com/document_detail/157971.html). The service can not closed once it is opened.
 */
public data class GetAckServicePlainArgs(
    public val enable: String? = null,
    public val type: String,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.GetAckServicePlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.GetAckServicePlainArgs =
        com.pulumi.alicloud.cs.inputs.GetAckServicePlainArgs.builder()
            .enable(enable?.let({ args0 -> args0 }))
            .type(type.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAckServicePlainArgs].
 */
@PulumiTagMarker
public class GetAckServicePlainArgsBuilder internal constructor() {
    private var enable: String? = null

    private var type: String? = null

    /**
     * @param value Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
     */
    @JvmName("xpajjmmeblllnfcw")
    public suspend fun enable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enable = mapped
    }

    /**
     * @param value Types of services opened. Valid values: `propayasgo`: Container service ack Pro managed version, `edgepayasgo`: Edge container service, `gspayasgo`: Gene computing services.
     * > **NOTE:** Setting `enable = "On"` to open the Container Service (CS) service that means you have read and agreed the [Container Service (CS) Terms of Service](https://help.aliyun.com/document_detail/157971.html). The service can not closed once it is opened.
     */
    @JvmName("tybglkgdeywuqoca")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetAckServicePlainArgs = GetAckServicePlainArgs(
        enable = enable,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
