@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.GetClusterCredentialPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getClusterCredential.
 * @property clusterId The id of target cluster.
 * @property outputFile File name where to save the returned KubeConfig (after running `pulumi preview`).
 * @property temporaryDurationMinutes Automatic expiration time of the returned credential. The valid value between `15` and `4320`, in minutes. When this field is omitted, the expiration time will be determined by the system automatically and the result will be in the attributed field `expiration`.
 */
public data class GetClusterCredentialPlainArgs(
    public val clusterId: String,
    public val outputFile: String? = null,
    public val temporaryDurationMinutes: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.GetClusterCredentialPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.GetClusterCredentialPlainArgs =
        com.pulumi.alicloud.cs.inputs.GetClusterCredentialPlainArgs.builder()
            .clusterId(clusterId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .temporaryDurationMinutes(temporaryDurationMinutes?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetClusterCredentialPlainArgs].
 */
@PulumiTagMarker
public class GetClusterCredentialPlainArgsBuilder internal constructor() {
    private var clusterId: String? = null

    private var outputFile: String? = null

    private var temporaryDurationMinutes: Int? = null

    /**
     * @param value The id of target cluster.
     */
    @JvmName("uttgrmkatttjfuku")
    public suspend fun clusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterId = mapped
    }

    /**
     * @param value File name where to save the returned KubeConfig (after running `pulumi preview`).
     */
    @JvmName("opngjraxuhriwgnw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Automatic expiration time of the returned credential. The valid value between `15` and `4320`, in minutes. When this field is omitted, the expiration time will be determined by the system automatically and the result will be in the attributed field `expiration`.
     */
    @JvmName("jvxgvbsvprbwycir")
    public suspend fun temporaryDurationMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.temporaryDurationMinutes = mapped
    }

    internal fun build(): GetClusterCredentialPlainArgs = GetClusterCredentialPlainArgs(
        clusterId = clusterId ?: throw PulumiNullFieldException("clusterId"),
        outputFile = outputFile,
        temporaryDurationMinutes = temporaryDurationMinutes,
    )
}
