@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.GetKubernetesAddonMetadataPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getKubernetesAddonMetadata.
 * @property clusterId The id of kubernetes cluster.
 * @property name The name of the cluster addon. You can get a list of available addons that the cluster can install by using data source `alicloud.cs.getKubernetesAddons`.
 * @property version The version of the cluster addon.
 */
public data class GetKubernetesAddonMetadataPlainArgs(
    public val clusterId: String,
    public val name: String,
    public val version: String,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.GetKubernetesAddonMetadataPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.GetKubernetesAddonMetadataPlainArgs =
        com.pulumi.alicloud.cs.inputs.GetKubernetesAddonMetadataPlainArgs.builder()
            .clusterId(clusterId.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .version(version.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKubernetesAddonMetadataPlainArgs].
 */
@PulumiTagMarker
public class GetKubernetesAddonMetadataPlainArgsBuilder internal constructor() {
    private var clusterId: String? = null

    private var name: String? = null

    private var version: String? = null

    /**
     * @param value The id of kubernetes cluster.
     */
    @JvmName("duwlydwauhkklidq")
    public suspend fun clusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterId = mapped
    }

    /**
     * @param value The name of the cluster addon. You can get a list of available addons that the cluster can install by using data source `alicloud.cs.getKubernetesAddons`.
     */
    @JvmName("gqsueyxthdajwbyt")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The version of the cluster addon.
     */
    @JvmName("rrbipjlcattgksno")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.version = mapped
    }

    internal fun build(): GetKubernetesAddonMetadataPlainArgs = GetKubernetesAddonMetadataPlainArgs(
        clusterId = clusterId ?: throw PulumiNullFieldException("clusterId"),
        name = name ?: throw PulumiNullFieldException("name"),
        version = version ?: throw PulumiNullFieldException("version"),
    )
}
