@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.GetKubernetesAddonsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getKubernetesAddons.
 * @property clusterId The id of kubernetes cluster.
 * @property ids A list of addon IDs. The id of addon consists of the cluster id and the addon name, with the structure <cluster_ud>:<addon_name>.
 * @property nameRegex A regex string to filter results by addon name.
 */
public data class GetKubernetesAddonsPlainArgs(
    public val clusterId: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.GetKubernetesAddonsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.GetKubernetesAddonsPlainArgs =
        com.pulumi.alicloud.cs.inputs.GetKubernetesAddonsPlainArgs.builder()
            .clusterId(clusterId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKubernetesAddonsPlainArgs].
 */
@PulumiTagMarker
public class GetKubernetesAddonsPlainArgsBuilder internal constructor() {
    private var clusterId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    /**
     * @param value The id of kubernetes cluster.
     */
    @JvmName("riljrheltuhfqdkr")
    public suspend fun clusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterId = mapped
    }

    /**
     * @param value A list of addon IDs. The id of addon consists of the cluster id and the addon name, with the structure <cluster_ud>:<addon_name>.
     */
    @JvmName("emsmvbywdyugymdm")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of addon IDs. The id of addon consists of the cluster id and the addon name, with the structure <cluster_ud>:<addon_name>.
     */
    @JvmName("eytfjnleoarxqvmu")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by addon name.
     */
    @JvmName("jkjwmtatwtvrgioc")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    internal fun build(): GetKubernetesAddonsPlainArgs = GetKubernetesAddonsPlainArgs(
        clusterId = clusterId ?: throw PulumiNullFieldException("clusterId"),
        ids = ids,
        nameRegex = nameRegex,
    )
}
