@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.GetKubernetesPermissionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getKubernetesPermission.
 * @property uid The ID of the RAM user. If you want to query the permissions of a RAM role, specify the ID of the RAM role.
 */
public data class GetKubernetesPermissionPlainArgs(
    public val uid: String,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.GetKubernetesPermissionPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.GetKubernetesPermissionPlainArgs =
        com.pulumi.alicloud.cs.inputs.GetKubernetesPermissionPlainArgs.builder()
            .uid(uid.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKubernetesPermissionPlainArgs].
 */
@PulumiTagMarker
public class GetKubernetesPermissionPlainArgsBuilder internal constructor() {
    private var uid: String? = null

    /**
     * @param value The ID of the RAM user. If you want to query the permissions of a RAM role, specify the ID of the RAM role.
     */
    @JvmName("ojleumewjybtrvlc")
    public suspend fun uid(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.uid = mapped
    }

    internal fun build(): GetKubernetesPermissionPlainArgs = GetKubernetesPermissionPlainArgs(
        uid = uid ?: throw PulumiNullFieldException("uid"),
    )
}
