@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.GetKubernetesVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getKubernetesVersion.
 * @property clusterType The type of cluster. Its valid value are `Kubernetes` and `ManagedKubernetes`.
 * @property kubernetesVersion The ACK released kubernetes version.
 * @property profile The profile of cluster. Its valid value are `Default`, `Serverless` and `Edge`.
 */
public data class GetKubernetesVersionPlainArgs(
    public val clusterType: String,
    public val kubernetesVersion: String? = null,
    public val profile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.GetKubernetesVersionPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.GetKubernetesVersionPlainArgs =
        com.pulumi.alicloud.cs.inputs.GetKubernetesVersionPlainArgs.builder()
            .clusterType(clusterType.let({ args0 -> args0 }))
            .kubernetesVersion(kubernetesVersion?.let({ args0 -> args0 }))
            .profile(profile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKubernetesVersionPlainArgs].
 */
@PulumiTagMarker
public class GetKubernetesVersionPlainArgsBuilder internal constructor() {
    private var clusterType: String? = null

    private var kubernetesVersion: String? = null

    private var profile: String? = null

    /**
     * @param value The type of cluster. Its valid value are `Kubernetes` and `ManagedKubernetes`.
     */
    @JvmName("stfdaefmopnssdac")
    public suspend fun clusterType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterType = mapped
    }

    /**
     * @param value The ACK released kubernetes version.
     */
    @JvmName("kyhdeypquwiqqjom")
    public suspend fun kubernetesVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.kubernetesVersion = mapped
    }

    /**
     * @param value The profile of cluster. Its valid value are `Default`, `Serverless` and `Edge`.
     */
    @JvmName("qonmfcwfrmojrlyy")
    public suspend fun profile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.profile = mapped
    }

    internal fun build(): GetKubernetesVersionPlainArgs = GetKubernetesVersionPlainArgs(
        clusterType = clusterType ?: throw PulumiNullFieldException("clusterType"),
        kubernetesVersion = kubernetesVersion,
        profile = profile,
    )
}
