@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.GetManagedKubernetesClustersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getManagedKubernetesClusters.
 * @property enableDetails
 * @property ids Cluster IDs to filter.
 * @property kubeConfigFilePrefix The path prefix of kube config. You could store kube config in a specified directory by specifying this field, like `~/.kube/managed`, then it will be named with `~/.kube/managed-clusterID-kubeconfig`. From version 1.187.0+, kube_config will not export kube_config if this field is not set.
 * @property nameRegex A regex string to filter results by cluster name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetManagedKubernetesClustersPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val kubeConfigFilePrefix: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.GetManagedKubernetesClustersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.GetManagedKubernetesClustersPlainArgs =
        com.pulumi.alicloud.cs.inputs.GetManagedKubernetesClustersPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .kubeConfigFilePrefix(kubeConfigFilePrefix?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedKubernetesClustersPlainArgs].
 */
@PulumiTagMarker
public class GetManagedKubernetesClustersPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var kubeConfigFilePrefix: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value
     */
    @JvmName("iecwhdrhdklakaub")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value Cluster IDs to filter.
     */
    @JvmName("yaxnacpminiavujm")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values Cluster IDs to filter.
     */
    @JvmName("qftydaaehjdsljgc")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The path prefix of kube config. You could store kube config in a specified directory by specifying this field, like `~/.kube/managed`, then it will be named with `~/.kube/managed-clusterID-kubeconfig`. From version 1.187.0+, kube_config will not export kube_config if this field is not set.
     */
    @JvmName("grggjqgaqqlyvixm")
    public suspend fun kubeConfigFilePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.kubeConfigFilePrefix = mapped
    }

    /**
     * @param value A regex string to filter results by cluster name.
     */
    @JvmName("uybwkwitaxmsidex")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("jscypkukvawpvirv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetManagedKubernetesClustersPlainArgs =
        GetManagedKubernetesClustersPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            kubeConfigFilePrefix = kubeConfigFilePrefix,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
}
