@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.GetRegistryEnterpriseInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRegistryEnterpriseInstances.
 * @property enableDetails Default to `true`. Set it to true can output instance authorization token.
 * @property ids A list of ids to filter results by instance id.
 * @property nameRegex A regex string to filter results by instance name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetRegistryEnterpriseInstancesPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.GetRegistryEnterpriseInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.GetRegistryEnterpriseInstancesPlainArgs =
        com.pulumi.alicloud.cs.inputs.GetRegistryEnterpriseInstancesPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegistryEnterpriseInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetRegistryEnterpriseInstancesPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value Default to `true`. Set it to true can output instance authorization token.
     */
    @JvmName("tejiaweopqikjois")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of ids to filter results by instance id.
     */
    @JvmName("yckbjympemespemt")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of ids to filter results by instance id.
     */
    @JvmName("omehxnontkyakppi")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by instance name.
     */
    @JvmName("icwrfobdchxkwvot")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("scvaymxjxrymwaeg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetRegistryEnterpriseInstancesPlainArgs =
        GetRegistryEnterpriseInstancesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
}
