@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.GetRegistryEnterpriseNamespacesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRegistryEnterpriseNamespaces.
 * @property ids A list of ids to filter results by namespace id. Each item formats as `<instance_id>:<namespace_name>`.
 * @property instanceId ID of Container Registry Enterprise Edition instance.
 * @property nameRegex A regex string to filter results by namespace name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetRegistryEnterpriseNamespacesPlainArgs(
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.GetRegistryEnterpriseNamespacesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.GetRegistryEnterpriseNamespacesPlainArgs =
        com.pulumi.alicloud.cs.inputs.GetRegistryEnterpriseNamespacesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegistryEnterpriseNamespacesPlainArgs].
 */
@PulumiTagMarker
public class GetRegistryEnterpriseNamespacesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of ids to filter results by namespace id. Each item formats as `<instance_id>:<namespace_name>`.
     */
    @JvmName("bxceoxognvwqqyro")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of ids to filter results by namespace id. Each item formats as `<instance_id>:<namespace_name>`.
     */
    @JvmName("titdlgvjjvysjnkr")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value ID of Container Registry Enterprise Edition instance.
     */
    @JvmName("bsxcxbvhptqjjxvu")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter results by namespace name.
     */
    @JvmName("kafidethaigbhlgi")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wursqnqnkiotfixc")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetRegistryEnterpriseNamespacesPlainArgs =
        GetRegistryEnterpriseNamespacesPlainArgs(
            ids = ids,
            instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
}
