@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.GetRegistryEnterpriseReposPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRegistryEnterpriseRepos.
 * @property enableDetails Boolean, false by default, only repository attributes are exported. Set to true if tags belong to this repository are needed. See `tags` in attributes.
 * @property ids A list of ids to filter results by repository id.
 * @property instanceId ID of Container Registry Enterprise Edition instance.
 * @property nameRegex A regex string to filter results by repository name.
 * @property namespace Name of Container Registry Enterprise Edition namespace where the repositories are located in.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetRegistryEnterpriseReposPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val namespace: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.GetRegistryEnterpriseReposPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.GetRegistryEnterpriseReposPlainArgs =
        com.pulumi.alicloud.cs.inputs.GetRegistryEnterpriseReposPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .namespace(namespace?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegistryEnterpriseReposPlainArgs].
 */
@PulumiTagMarker
public class GetRegistryEnterpriseReposPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var namespace: String? = null

    private var outputFile: String? = null

    /**
     * @param value Boolean, false by default, only repository attributes are exported. Set to true if tags belong to this repository are needed. See `tags` in attributes.
     */
    @JvmName("qhcgrtmkcxwhqrfl")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of ids to filter results by repository id.
     */
    @JvmName("evymolnqyjgkkkkr")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of ids to filter results by repository id.
     */
    @JvmName("hwfilqssssgducyk")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value ID of Container Registry Enterprise Edition instance.
     */
    @JvmName("jjhqxcunkypucfvf")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter results by repository name.
     */
    @JvmName("nwkgwixgufqoexpw")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value Name of Container Registry Enterprise Edition namespace where the repositories are located in.
     */
    @JvmName("fwgvokitueswsumd")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.namespace = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("kqgiejimgtxcxyro")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetRegistryEnterpriseReposPlainArgs = GetRegistryEnterpriseReposPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        nameRegex = nameRegex,
        namespace = namespace,
        outputFile = outputFile,
    )
}
