@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.GetRegistryEnterpriseSyncRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRegistryEnterpriseSyncRules.
 * @property ids A list of ids to filter results by sync rule id.
 * @property instanceId ID of Container Registry Enterprise Edition local instance.
 * @property nameRegex A regex string to filter results by sync rule name.
 * @property namespaceName Name of Container Registry Enterprise Edition local namespace.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property repoName Name of Container Registry Enterprise Edition local repo.
 * @property targetInstanceId ID of Container Registry Enterprise Edition target instance.
 */
public data class GetRegistryEnterpriseSyncRulesPlainArgs(
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val namespaceName: String? = null,
    public val outputFile: String? = null,
    public val repoName: String? = null,
    public val targetInstanceId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.GetRegistryEnterpriseSyncRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.GetRegistryEnterpriseSyncRulesPlainArgs =
        com.pulumi.alicloud.cs.inputs.GetRegistryEnterpriseSyncRulesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .namespaceName(namespaceName?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .repoName(repoName?.let({ args0 -> args0 }))
            .targetInstanceId(targetInstanceId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegistryEnterpriseSyncRulesPlainArgs].
 */
@PulumiTagMarker
public class GetRegistryEnterpriseSyncRulesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var namespaceName: String? = null

    private var outputFile: String? = null

    private var repoName: String? = null

    private var targetInstanceId: String? = null

    /**
     * @param value A list of ids to filter results by sync rule id.
     */
    @JvmName("fcamkjyvaocclfha")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of ids to filter results by sync rule id.
     */
    @JvmName("jvsfhwwyyffjevpc")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value ID of Container Registry Enterprise Edition local instance.
     */
    @JvmName("xiypmlsvisbuqdbf")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter results by sync rule name.
     */
    @JvmName("ibakddgsshhruend")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value Name of Container Registry Enterprise Edition local namespace.
     */
    @JvmName("osbmoymticyntlme")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("baaeexxjbwyxdrpk")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Name of Container Registry Enterprise Edition local repo.
     */
    @JvmName("hhavojctmnaxtiru")
    public suspend fun repoName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.repoName = mapped
    }

    /**
     * @param value ID of Container Registry Enterprise Edition target instance.
     */
    @JvmName("jagwsveacyecctvc")
    public suspend fun targetInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.targetInstanceId = mapped
    }

    internal fun build(): GetRegistryEnterpriseSyncRulesPlainArgs =
        GetRegistryEnterpriseSyncRulesPlainArgs(
            ids = ids,
            instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
            nameRegex = nameRegex,
            namespaceName = namespaceName,
            outputFile = outputFile,
            repoName = repoName,
            targetInstanceId = targetInstanceId,
        )
}
