@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.KubernetesAddonArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property config The ACK add-on configurations. For more config information, see cs_kubernetes_addon_metadata.
 * @property disabled Disables the automatic installation of a component. Default is `false`.
 * The following example is the definition of addons block, The type of this field is list:
 * ```
 * # install nginx ingress, conflict with SLB ingress
 * addons {
 * name = "nginx-ingress-controller"
 * # use internet
 * config = "{\"IngressSlbNetworkType\":\"internet",\"IngressSlbSpec\":\"slb.s2.small\"}"
 * # if use intranet, detail below.
 * # config = "{\"IngressSlbNetworkType\":\"intranet",\"IngressSlbSpec\":\"slb.s2.small\"}"
 * }
 * ```
 * @property name Name of the ACK add-on. The name must match one of the names returned by [DescribeAddons](https://help.aliyun.com/document_detail/171524.html).
 * @property version The version of the component.
 */
public data class KubernetesAddonArgs(
    public val config: Output<String>? = null,
    public val disabled: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.KubernetesAddonArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.KubernetesAddonArgs =
        com.pulumi.alicloud.cs.inputs.KubernetesAddonArgs.builder()
            .config(config?.applyValue({ args0 -> args0 }))
            .disabled(disabled?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KubernetesAddonArgs].
 */
@PulumiTagMarker
public class KubernetesAddonArgsBuilder internal constructor() {
    private var config: Output<String>? = null

    private var disabled: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value The ACK add-on configurations. For more config information, see cs_kubernetes_addon_metadata.
     */
    @JvmName("rsrcihymkwhrccyq")
    public suspend fun config(`value`: Output<String>) {
        this.config = value
    }

    /**
     * @param value Disables the automatic installation of a component. Default is `false`.
     * The following example is the definition of addons block, The type of this field is list:
     * ```
     * # install nginx ingress, conflict with SLB ingress
     * addons {
     * name = "nginx-ingress-controller"
     * # use internet
     * config = "{\"IngressSlbNetworkType\":\"internet",\"IngressSlbSpec\":\"slb.s2.small\"}"
     * # if use intranet, detail below.
     * # config = "{\"IngressSlbNetworkType\":\"intranet",\"IngressSlbSpec\":\"slb.s2.small\"}"
     * }
     * ```
     */
    @JvmName("kuwmyaaoqeuyeuqf")
    public suspend fun disabled(`value`: Output<Boolean>) {
        this.disabled = value
    }

    /**
     * @param value Name of the ACK add-on. The name must match one of the names returned by [DescribeAddons](https://help.aliyun.com/document_detail/171524.html).
     */
    @JvmName("sggybrkmbstgdejf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The version of the component.
     */
    @JvmName("iaaboxaqdpffbuum")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The ACK add-on configurations. For more config information, see cs_kubernetes_addon_metadata.
     */
    @JvmName("mdyptnxcjtifvapl")
    public suspend fun config(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.config = mapped
    }

    /**
     * @param value Disables the automatic installation of a component. Default is `false`.
     * The following example is the definition of addons block, The type of this field is list:
     * ```
     * # install nginx ingress, conflict with SLB ingress
     * addons {
     * name = "nginx-ingress-controller"
     * # use internet
     * config = "{\"IngressSlbNetworkType\":\"internet",\"IngressSlbSpec\":\"slb.s2.small\"}"
     * # if use intranet, detail below.
     * # config = "{\"IngressSlbNetworkType\":\"intranet",\"IngressSlbSpec\":\"slb.s2.small\"}"
     * }
     * ```
     */
    @JvmName("ohgiuxsbhlystnxr")
    public suspend fun disabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabled = mapped
    }

    /**
     * @param value Name of the ACK add-on. The name must match one of the names returned by [DescribeAddons](https://help.aliyun.com/document_detail/171524.html).
     */
    @JvmName("tpoxqrrmcnvfbvpk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The version of the component.
     */
    @JvmName("iklvpkyhewfvlrgc")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): KubernetesAddonArgs = KubernetesAddonArgs(
        config = config,
        disabled = disabled,
        name = name,
        version = version,
    )
}
