@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.KubernetesAutoscalerNodepoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id The scaling group id of the groups configured for cluster-autoscaler.
 * @property labels The labels for the nodes in scaling group.
 * @property taints The taints for the nodes in scaling group.
 */
public data class KubernetesAutoscalerNodepoolArgs(
    public val id: Output<String>? = null,
    public val labels: Output<String>? = null,
    public val taints: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.KubernetesAutoscalerNodepoolArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.KubernetesAutoscalerNodepoolArgs =
        com.pulumi.alicloud.cs.inputs.KubernetesAutoscalerNodepoolArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .labels(labels?.applyValue({ args0 -> args0 }))
            .taints(taints?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KubernetesAutoscalerNodepoolArgs].
 */
@PulumiTagMarker
public class KubernetesAutoscalerNodepoolArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var labels: Output<String>? = null

    private var taints: Output<String>? = null

    /**
     * @param value The scaling group id of the groups configured for cluster-autoscaler.
     */
    @JvmName("rausjblmtqtlnjth")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The labels for the nodes in scaling group.
     */
    @JvmName("suuchhtqnaftkjcy")
    public suspend fun labels(`value`: Output<String>) {
        this.labels = value
    }

    /**
     * @param value The taints for the nodes in scaling group.
     */
    @JvmName("wynnwysnangctcuy")
    public suspend fun taints(`value`: Output<String>) {
        this.taints = value
    }

    /**
     * @param value The scaling group id of the groups configured for cluster-autoscaler.
     */
    @JvmName("ecpckximaouohnjs")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The labels for the nodes in scaling group.
     */
    @JvmName("ktecnipgroivflvx")
    public suspend fun labels(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value The taints for the nodes in scaling group.
     */
    @JvmName("aaldlmvxwcdrdhwn")
    public suspend fun taints(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taints = mapped
    }

    internal fun build(): KubernetesAutoscalerNodepoolArgs = KubernetesAutoscalerNodepoolArgs(
        id = id,
        labels = labels,
        taints = taints,
    )
}
