@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.KubernetesPermissionPermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cluster The ID of the cluster that you want to manage, When `role_type` value is `all-clusters`, the value of `cluster` must be `""`.
 * @property isCustom Specifies whether to perform a custom authorization. To perform a custom authorization, the value of `is_custom` must be `true`, and set `role_name` to a custom cluster role.
 * @property isRamRole Specifies whether the permissions are granted to a RAM role. When `uid` is ram role id, the value of `is_ram_role` must be `true`.
 * @property namespace The namespace to which the permissions are scoped. This parameter is required only if you set role_type to namespace.
 * @property roleName Specifies the predefined role that you want to assign. Valid values `admin`, `ops`, `dev`, `restricted` and the custom cluster roles.
 * @property roleType The authorization type. Valid values `cluster`, `namespace` and `all-clusters`.
 */
public data class KubernetesPermissionPermissionArgs(
    public val cluster: Output<String>,
    public val isCustom: Output<Boolean>? = null,
    public val isRamRole: Output<Boolean>? = null,
    public val namespace: Output<String>? = null,
    public val roleName: Output<String>,
    public val roleType: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.KubernetesPermissionPermissionArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.KubernetesPermissionPermissionArgs =
        com.pulumi.alicloud.cs.inputs.KubernetesPermissionPermissionArgs.builder()
            .cluster(cluster.applyValue({ args0 -> args0 }))
            .isCustom(isCustom?.applyValue({ args0 -> args0 }))
            .isRamRole(isRamRole?.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .roleName(roleName.applyValue({ args0 -> args0 }))
            .roleType(roleType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KubernetesPermissionPermissionArgs].
 */
@PulumiTagMarker
public class KubernetesPermissionPermissionArgsBuilder internal constructor() {
    private var cluster: Output<String>? = null

    private var isCustom: Output<Boolean>? = null

    private var isRamRole: Output<Boolean>? = null

    private var namespace: Output<String>? = null

    private var roleName: Output<String>? = null

    private var roleType: Output<String>? = null

    /**
     * @param value The ID of the cluster that you want to manage, When `role_type` value is `all-clusters`, the value of `cluster` must be `""`.
     */
    @JvmName("qejehcyrrswjroyv")
    public suspend fun cluster(`value`: Output<String>) {
        this.cluster = value
    }

    /**
     * @param value Specifies whether to perform a custom authorization. To perform a custom authorization, the value of `is_custom` must be `true`, and set `role_name` to a custom cluster role.
     */
    @JvmName("ssboyulgponlhfpa")
    public suspend fun isCustom(`value`: Output<Boolean>) {
        this.isCustom = value
    }

    /**
     * @param value Specifies whether the permissions are granted to a RAM role. When `uid` is ram role id, the value of `is_ram_role` must be `true`.
     */
    @JvmName("fgcnrdffkcbssmkb")
    public suspend fun isRamRole(`value`: Output<Boolean>) {
        this.isRamRole = value
    }

    /**
     * @param value The namespace to which the permissions are scoped. This parameter is required only if you set role_type to namespace.
     */
    @JvmName("rhypqjucccerpkea")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Specifies the predefined role that you want to assign. Valid values `admin`, `ops`, `dev`, `restricted` and the custom cluster roles.
     */
    @JvmName("tadjuldvfnspulij")
    public suspend fun roleName(`value`: Output<String>) {
        this.roleName = value
    }

    /**
     * @param value The authorization type. Valid values `cluster`, `namespace` and `all-clusters`.
     */
    @JvmName("leimmtkqikxmtlas")
    public suspend fun roleType(`value`: Output<String>) {
        this.roleType = value
    }

    /**
     * @param value The ID of the cluster that you want to manage, When `role_type` value is `all-clusters`, the value of `cluster` must be `""`.
     */
    @JvmName("eqraejmltasutaoh")
    public suspend fun cluster(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cluster = mapped
    }

    /**
     * @param value Specifies whether to perform a custom authorization. To perform a custom authorization, the value of `is_custom` must be `true`, and set `role_name` to a custom cluster role.
     */
    @JvmName("xcphtixbswiquskb")
    public suspend fun isCustom(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isCustom = mapped
    }

    /**
     * @param value Specifies whether the permissions are granted to a RAM role. When `uid` is ram role id, the value of `is_ram_role` must be `true`.
     */
    @JvmName("jnvlobairpvumiqa")
    public suspend fun isRamRole(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isRamRole = mapped
    }

    /**
     * @param value The namespace to which the permissions are scoped. This parameter is required only if you set role_type to namespace.
     */
    @JvmName("kscratnrymkbjhdu")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value Specifies the predefined role that you want to assign. Valid values `admin`, `ops`, `dev`, `restricted` and the custom cluster roles.
     */
    @JvmName("aprqifcyjkdrjkhi")
    public suspend fun roleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleName = mapped
    }

    /**
     * @param value The authorization type. Valid values `cluster`, `namespace` and `all-clusters`.
     */
    @JvmName("aayfuqesgjabduuu")
    public suspend fun roleType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleType = mapped
    }

    internal fun build(): KubernetesPermissionPermissionArgs = KubernetesPermissionPermissionArgs(
        cluster = cluster ?: throw PulumiNullFieldException("cluster"),
        isCustom = isCustom,
        isRamRole = isRamRole,
        namespace = namespace,
        roleName = roleName ?: throw PulumiNullFieldException("roleName"),
        roleType = roleType ?: throw PulumiNullFieldException("roleType"),
    )
}
