@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.KubernetesRuntimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the runtime. Supported runtimes can be queried by data source alicloud_cs_kubernetes_version.
 * @property version The version of the runtime.
 * The following example is the definition of runtime block:
 * ```
 * runtime = {
 * name = "containerd"
 * version = "1.6.28"
 * }
 * ```
 */
public data class KubernetesRuntimeArgs(
    public val name: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.KubernetesRuntimeArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.KubernetesRuntimeArgs =
        com.pulumi.alicloud.cs.inputs.KubernetesRuntimeArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KubernetesRuntimeArgs].
 */
@PulumiTagMarker
public class KubernetesRuntimeArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value The name of the runtime. Supported runtimes can be queried by data source alicloud_cs_kubernetes_version.
     */
    @JvmName("hagdarmqdnubcqeg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The version of the runtime.
     * The following example is the definition of runtime block:
     * ```
     * runtime = {
     * name = "containerd"
     * version = "1.6.28"
     * }
     * ```
     */
    @JvmName("mboxmeqhlsoqtomi")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The name of the runtime. Supported runtimes can be queried by data source alicloud_cs_kubernetes_version.
     */
    @JvmName("iaveyijpwpbeydww")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The version of the runtime.
     * The following example is the definition of runtime block:
     * ```
     * runtime = {
     * name = "containerd"
     * version = "1.6.28"
     * }
     * ```
     */
    @JvmName("xgohttpaebwaiiga")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): KubernetesRuntimeArgs = KubernetesRuntimeArgs(
        name = name,
        version = version,
    )
}
