@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.ManagedKubernetesAddonArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property config If this parameter is left empty, no configurations are required. For more config information, see cs_kubernetes_addon_metadata.
 * @property disabled It specifies whether to disable automatic installation.
 * It is a new field since 1.75.0. You can specific network plugin, log component,ingress component and so on.
 * You can get more information about addons on ACK web console. When you create a ACK cluster. You can get openapi-spec before creating the cluster on submission page.
 * `logtail-ds` - You can specify `IngressDashboardEnabled` and `sls_project_name` in config. If you switch on `IngressDashboardEnabled` and `sls_project_name`,then logtail-ds would use `sls_project_name` as default log store.
 * `nginx-ingress-controller` - You can specific `IngressSlbNetworkType` in config. Options: internet|intranet.
 * The `main.tf`:
 * @property name This parameter specifies the name of the component.
 * @property version It specifies the version of the component.
 */
public data class ManagedKubernetesAddonArgs(
    public val config: Output<String>? = null,
    public val disabled: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.ManagedKubernetesAddonArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.ManagedKubernetesAddonArgs =
        com.pulumi.alicloud.cs.inputs.ManagedKubernetesAddonArgs.builder()
            .config(config?.applyValue({ args0 -> args0 }))
            .disabled(disabled?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedKubernetesAddonArgs].
 */
@PulumiTagMarker
public class ManagedKubernetesAddonArgsBuilder internal constructor() {
    private var config: Output<String>? = null

    private var disabled: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value If this parameter is left empty, no configurations are required. For more config information, see cs_kubernetes_addon_metadata.
     */
    @JvmName("ysxhwugcevwwgrom")
    public suspend fun config(`value`: Output<String>) {
        this.config = value
    }

    /**
     * @param value It specifies whether to disable automatic installation.
     * It is a new field since 1.75.0. You can specific network plugin, log component,ingress component and so on.
     * You can get more information about addons on ACK web console. When you create a ACK cluster. You can get openapi-spec before creating the cluster on submission page.
     * `logtail-ds` - You can specify `IngressDashboardEnabled` and `sls_project_name` in config. If you switch on `IngressDashboardEnabled` and `sls_project_name`,then logtail-ds would use `sls_project_name` as default log store.
     * `nginx-ingress-controller` - You can specific `IngressSlbNetworkType` in config. Options: internet|intranet.
     * The `main.tf`:
     */
    @JvmName("tjaaiibtwbleyqko")
    public suspend fun disabled(`value`: Output<Boolean>) {
        this.disabled = value
    }

    /**
     * @param value This parameter specifies the name of the component.
     */
    @JvmName("ekpxrtclhpewfrnm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value It specifies the version of the component.
     */
    @JvmName("egeaxfxyugoexsso")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value If this parameter is left empty, no configurations are required. For more config information, see cs_kubernetes_addon_metadata.
     */
    @JvmName("xtfcivnfkguclkgq")
    public suspend fun config(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.config = mapped
    }

    /**
     * @param value It specifies whether to disable automatic installation.
     * It is a new field since 1.75.0. You can specific network plugin, log component,ingress component and so on.
     * You can get more information about addons on ACK web console. When you create a ACK cluster. You can get openapi-spec before creating the cluster on submission page.
     * `logtail-ds` - You can specify `IngressDashboardEnabled` and `sls_project_name` in config. If you switch on `IngressDashboardEnabled` and `sls_project_name`,then logtail-ds would use `sls_project_name` as default log store.
     * `nginx-ingress-controller` - You can specific `IngressSlbNetworkType` in config. Options: internet|intranet.
     * The `main.tf`:
     */
    @JvmName("ofvpihslmlvjguxr")
    public suspend fun disabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabled = mapped
    }

    /**
     * @param value This parameter specifies the name of the component.
     */
    @JvmName("mbsopcxokwhdiayy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value It specifies the version of the component.
     */
    @JvmName("mfoawehsajsbvmlv")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ManagedKubernetesAddonArgs = ManagedKubernetesAddonArgs(
        config = config,
        disabled = disabled,
        name = name,
        version = version,
    )
}
