@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.ManagedKubernetesDeleteOptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deleteMode The deletion mode of the cluster. Different resources may have different default behavior, see `resource_type` for details. Valid values:
 * @property resourceType The type of resources that are created by cluster. Valid values:
 * - `SLB`: SLB resources created through the service, default behavior is to delete, option to retain is available.
 * - `ALB`: ALB resources created by the ALB Ingress Controller, default behavior is to retain, option to delete is available.
 * - `SLS_Data`: SLS Project used by the cluster logging feature, default behavior is to retain, option to delete is available.
 * - `SLS_ControlPlane`: SLS Project used for the managed cluster control plane logs, default behavior is to retain, option to delete is available.
 * ```
 * ...
 * // Specify delete_options as below when deleting cluster
 * // delete SLB resources created by the cluster
 * delete_options {
 * delete_mode = "delete"
 * resource_type = "SLB"
 * }
 * // delete ALB resources created by the ALB Ingress Controller
 * delete_options {
 * delete_mode = "delete"
 * resource_type = "ALB"
 * }
 * // delete SLS Project used by the cluster logging feature
 * delete_options {
 * delete_mode = "delete"
 * resource_type = "SLS_Data"
 * }
 * // delete SLS Project used for the managed cluster control plane logs
 * delete_options {
 * delete_mode = "delete"
 * resource_type = "SLS_ControlPlane"
 * }
 * ```
 */
public data class ManagedKubernetesDeleteOptionArgs(
    public val deleteMode: Output<String>? = null,
    public val resourceType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.ManagedKubernetesDeleteOptionArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.ManagedKubernetesDeleteOptionArgs =
        com.pulumi.alicloud.cs.inputs.ManagedKubernetesDeleteOptionArgs.builder()
            .deleteMode(deleteMode?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedKubernetesDeleteOptionArgs].
 */
@PulumiTagMarker
public class ManagedKubernetesDeleteOptionArgsBuilder internal constructor() {
    private var deleteMode: Output<String>? = null

    private var resourceType: Output<String>? = null

    /**
     * @param value The deletion mode of the cluster. Different resources may have different default behavior, see `resource_type` for details. Valid values:
     */
    @JvmName("fthkqqwvqoefhqvr")
    public suspend fun deleteMode(`value`: Output<String>) {
        this.deleteMode = value
    }

    /**
     * @param value The type of resources that are created by cluster. Valid values:
     * - `SLB`: SLB resources created through the service, default behavior is to delete, option to retain is available.
     * - `ALB`: ALB resources created by the ALB Ingress Controller, default behavior is to retain, option to delete is available.
     * - `SLS_Data`: SLS Project used by the cluster logging feature, default behavior is to retain, option to delete is available.
     * - `SLS_ControlPlane`: SLS Project used for the managed cluster control plane logs, default behavior is to retain, option to delete is available.
     * ```
     * ...
     * // Specify delete_options as below when deleting cluster
     * // delete SLB resources created by the cluster
     * delete_options {
     * delete_mode = "delete"
     * resource_type = "SLB"
     * }
     * // delete ALB resources created by the ALB Ingress Controller
     * delete_options {
     * delete_mode = "delete"
     * resource_type = "ALB"
     * }
     * // delete SLS Project used by the cluster logging feature
     * delete_options {
     * delete_mode = "delete"
     * resource_type = "SLS_Data"
     * }
     * // delete SLS Project used for the managed cluster control plane logs
     * delete_options {
     * delete_mode = "delete"
     * resource_type = "SLS_ControlPlane"
     * }
     * ```
     */
    @JvmName("nxkgrcmhoanggwtj")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The deletion mode of the cluster. Different resources may have different default behavior, see `resource_type` for details. Valid values:
     */
    @JvmName("ltelaacnvmfdjhoi")
    public suspend fun deleteMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteMode = mapped
    }

    /**
     * @param value The type of resources that are created by cluster. Valid values:
     * - `SLB`: SLB resources created through the service, default behavior is to delete, option to retain is available.
     * - `ALB`: ALB resources created by the ALB Ingress Controller, default behavior is to retain, option to delete is available.
     * - `SLS_Data`: SLS Project used by the cluster logging feature, default behavior is to retain, option to delete is available.
     * - `SLS_ControlPlane`: SLS Project used for the managed cluster control plane logs, default behavior is to retain, option to delete is available.
     * ```
     * ...
     * // Specify delete_options as below when deleting cluster
     * // delete SLB resources created by the cluster
     * delete_options {
     * delete_mode = "delete"
     * resource_type = "SLB"
     * }
     * // delete ALB resources created by the ALB Ingress Controller
     * delete_options {
     * delete_mode = "delete"
     * resource_type = "ALB"
     * }
     * // delete SLS Project used by the cluster logging feature
     * delete_options {
     * delete_mode = "delete"
     * resource_type = "SLS_Data"
     * }
     * // delete SLS Project used for the managed cluster control plane logs
     * delete_options {
     * delete_mode = "delete"
     * resource_type = "SLS_ControlPlane"
     * }
     * ```
     */
    @JvmName("bsjwiwidnfjfydej")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    internal fun build(): ManagedKubernetesDeleteOptionArgs = ManagedKubernetesDeleteOptionArgs(
        deleteMode = deleteMode,
        resourceType = resourceType,
    )
}
