@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.ManagedKubernetesMaintenanceWindowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property duration The maintenance time, values range from 1 to 24,unit is hour. For example: "3h".
 * @property enable Whether to open the maintenance window. The following parameters take effect only `enable = true`.
 * @property maintenanceTime Initial maintenance time, For example:"03:00:00Z".
 * @property weeklyPeriod Maintenance cycle, you can set the values from Monday to Sunday, separated by commas when the values are multiple. The default is Thursday.
 * for example:
 * ```
 * maintenance_window {
 * enable            = true
 * maintenance_time  = "01:00:00Z"
 * duration          = "3h"
 * weekly_period     = "Monday,Friday"
 * }
 * ```
 */
public data class ManagedKubernetesMaintenanceWindowArgs(
    public val duration: Output<String>,
    public val enable: Output<Boolean>,
    public val maintenanceTime: Output<String>,
    public val weeklyPeriod: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.ManagedKubernetesMaintenanceWindowArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.ManagedKubernetesMaintenanceWindowArgs =
        com.pulumi.alicloud.cs.inputs.ManagedKubernetesMaintenanceWindowArgs.builder()
            .duration(duration.applyValue({ args0 -> args0 }))
            .enable(enable.applyValue({ args0 -> args0 }))
            .maintenanceTime(maintenanceTime.applyValue({ args0 -> args0 }))
            .weeklyPeriod(weeklyPeriod.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedKubernetesMaintenanceWindowArgs].
 */
@PulumiTagMarker
public class ManagedKubernetesMaintenanceWindowArgsBuilder internal constructor() {
    private var duration: Output<String>? = null

    private var enable: Output<Boolean>? = null

    private var maintenanceTime: Output<String>? = null

    private var weeklyPeriod: Output<String>? = null

    /**
     * @param value The maintenance time, values range from 1 to 24,unit is hour. For example: "3h".
     */
    @JvmName("lawnbpntbrnxpxvc")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value Whether to open the maintenance window. The following parameters take effect only `enable = true`.
     */
    @JvmName("worlpyjupmtgdqoq")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value Initial maintenance time, For example:"03:00:00Z".
     */
    @JvmName("ahoajmwhimojuqhb")
    public suspend fun maintenanceTime(`value`: Output<String>) {
        this.maintenanceTime = value
    }

    /**
     * @param value Maintenance cycle, you can set the values from Monday to Sunday, separated by commas when the values are multiple. The default is Thursday.
     * for example:
     * ```
     * maintenance_window {
     * enable            = true
     * maintenance_time  = "01:00:00Z"
     * duration          = "3h"
     * weekly_period     = "Monday,Friday"
     * }
     * ```
     */
    @JvmName("drdmpfarhnvvbnox")
    public suspend fun weeklyPeriod(`value`: Output<String>) {
        this.weeklyPeriod = value
    }

    /**
     * @param value The maintenance time, values range from 1 to 24,unit is hour. For example: "3h".
     */
    @JvmName("pcuagkadkgfnkerk")
    public suspend fun duration(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value Whether to open the maintenance window. The following parameters take effect only `enable = true`.
     */
    @JvmName("wwvblklykslfurgy")
    public suspend fun enable(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value Initial maintenance time, For example:"03:00:00Z".
     */
    @JvmName("lnbmwwmvwueitvjn")
    public suspend fun maintenanceTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maintenanceTime = mapped
    }

    /**
     * @param value Maintenance cycle, you can set the values from Monday to Sunday, separated by commas when the values are multiple. The default is Thursday.
     * for example:
     * ```
     * maintenance_window {
     * enable            = true
     * maintenance_time  = "01:00:00Z"
     * duration          = "3h"
     * weekly_period     = "Monday,Friday"
     * }
     * ```
     */
    @JvmName("abahfugqsodocnur")
    public suspend fun weeklyPeriod(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weeklyPeriod = mapped
    }

    internal fun build(): ManagedKubernetesMaintenanceWindowArgs =
        ManagedKubernetesMaintenanceWindowArgs(
            duration = duration ?: throw PulumiNullFieldException("duration"),
            enable = enable ?: throw PulumiNullFieldException("enable"),
            maintenanceTime = maintenanceTime ?: throw PulumiNullFieldException("maintenanceTime"),
            weeklyPeriod = weeklyPeriod ?: throw PulumiNullFieldException("weeklyPeriod"),
        )
}
