@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.NodePoolDataDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property autoFormat Whether to automatically mount the data disk. Valid values: true and false.
 * @property autoSnapshotPolicyId The ID of the automatic snapshot policy that you want to apply to the system disk.
 * @property burstingEnabled Whether the data disk is enabled with Burst (performance Burst). This is configured when the disk type is cloud_auto.
 * @property category The type of the data disks. Valid values:`cloud`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_auto`.
 * @property device The mount target of data disk N. Valid values of N: 1 to 16. If you do not specify this parameter, the system automatically assigns a mount target when Auto Scaling creates ECS instances. The name of the mount target ranges from /dev/xvdb to /dev/xvdz.
 * @property encrypted Specifies whether to encrypt data disks. Valid values: true and false. Default to `false`.
 * @property fileSystem The Mount path. Works when auto_format is true.
 * @property kmsKeyId The kms key id used to encrypt the data disk. It takes effect when `encrypted` is true.
 * @property mountTarget The type of the mounted file system. Works when auto_format is true. Optional value: `ext4`, `xfs`.
 * @property name The length is 2~128 English or Chinese characters. It must start with an uppercase or lowr letter or a Chinese character and cannot start with http:// or https. Can contain numbers, colons (:), underscores (_), or dashes (-). It will be overwritten if auto_format is set.
 * @property performanceLevel Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
 * @property provisionedIops The read/write IOPS preconfigured for the data disk, which is configured when the disk type is cloud_auto.
 * @property size The size of a data disk, Its valid value range [40~32768] in GB. Default to `40`.
 * @property snapshotId The ID of the snapshot that you want to use to create data disk N. Valid values of N: 1 to 16. If you specify this parameter, DataDisk.N.Size is ignored. The size of the disk is the same as the size of the specified snapshot. If you specify a snapshot that is created on or before July 15, 2013, the operation fails and InvalidSnapshot.TooOld is returned.
 */
public data class NodePoolDataDiskArgs(
    public val autoFormat: Output<String>? = null,
    public val autoSnapshotPolicyId: Output<String>? = null,
    public val burstingEnabled: Output<Boolean>? = null,
    public val category: Output<String>? = null,
    public val device: Output<String>? = null,
    public val encrypted: Output<String>? = null,
    public val fileSystem: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val mountTarget: Output<String>? = null,
    public val name: Output<String>? = null,
    public val performanceLevel: Output<String>? = null,
    public val provisionedIops: Output<Int>? = null,
    public val size: Output<Int>? = null,
    public val snapshotId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.NodePoolDataDiskArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.NodePoolDataDiskArgs =
        com.pulumi.alicloud.cs.inputs.NodePoolDataDiskArgs.builder()
            .autoFormat(autoFormat?.applyValue({ args0 -> args0 }))
            .autoSnapshotPolicyId(autoSnapshotPolicyId?.applyValue({ args0 -> args0 }))
            .burstingEnabled(burstingEnabled?.applyValue({ args0 -> args0 }))
            .category(category?.applyValue({ args0 -> args0 }))
            .device(device?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .fileSystem(fileSystem?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .mountTarget(mountTarget?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .performanceLevel(performanceLevel?.applyValue({ args0 -> args0 }))
            .provisionedIops(provisionedIops?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodePoolDataDiskArgs].
 */
@PulumiTagMarker
public class NodePoolDataDiskArgsBuilder internal constructor() {
    private var autoFormat: Output<String>? = null

    private var autoSnapshotPolicyId: Output<String>? = null

    private var burstingEnabled: Output<Boolean>? = null

    private var category: Output<String>? = null

    private var device: Output<String>? = null

    private var encrypted: Output<String>? = null

    private var fileSystem: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var mountTarget: Output<String>? = null

    private var name: Output<String>? = null

    private var performanceLevel: Output<String>? = null

    private var provisionedIops: Output<Int>? = null

    private var size: Output<Int>? = null

    private var snapshotId: Output<String>? = null

    /**
     * @param value Whether to automatically mount the data disk. Valid values: true and false.
     */
    @JvmName("kehscwimlbsnxrsd")
    public suspend fun autoFormat(`value`: Output<String>) {
        this.autoFormat = value
    }

    /**
     * @param value The ID of the automatic snapshot policy that you want to apply to the system disk.
     */
    @JvmName("afgkuqggeaoussee")
    public suspend fun autoSnapshotPolicyId(`value`: Output<String>) {
        this.autoSnapshotPolicyId = value
    }

    /**
     * @param value Whether the data disk is enabled with Burst (performance Burst). This is configured when the disk type is cloud_auto.
     */
    @JvmName("roqhsmqaqwoakkqx")
    public suspend fun burstingEnabled(`value`: Output<Boolean>) {
        this.burstingEnabled = value
    }

    /**
     * @param value The type of the data disks. Valid values:`cloud`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_auto`.
     */
    @JvmName("smfpwgmsjuqsxlpi")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value The mount target of data disk N. Valid values of N: 1 to 16. If you do not specify this parameter, the system automatically assigns a mount target when Auto Scaling creates ECS instances. The name of the mount target ranges from /dev/xvdb to /dev/xvdz.
     */
    @JvmName("kppsghqiexirfhpe")
    public suspend fun device(`value`: Output<String>) {
        this.device = value
    }

    /**
     * @param value Specifies whether to encrypt data disks. Valid values: true and false. Default to `false`.
     */
    @JvmName("tqjspboujuugjxhu")
    public suspend fun encrypted(`value`: Output<String>) {
        this.encrypted = value
    }

    /**
     * @param value The Mount path. Works when auto_format is true.
     */
    @JvmName("jxdhhivksynulumt")
    public suspend fun fileSystem(`value`: Output<String>) {
        this.fileSystem = value
    }

    /**
     * @param value The kms key id used to encrypt the data disk. It takes effect when `encrypted` is true.
     */
    @JvmName("xxqussvfsqrjgpsv")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The type of the mounted file system. Works when auto_format is true. Optional value: `ext4`, `xfs`.
     */
    @JvmName("oymiilxffirsxkmu")
    public suspend fun mountTarget(`value`: Output<String>) {
        this.mountTarget = value
    }

    /**
     * @param value The length is 2~128 English or Chinese characters. It must start with an uppercase or lowr letter or a Chinese character and cannot start with http:// or https. Can contain numbers, colons (:), underscores (_), or dashes (-). It will be overwritten if auto_format is set.
     */
    @JvmName("lhccspwgilgrtkkx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
     */
    @JvmName("otslpjtwilryrcpi")
    public suspend fun performanceLevel(`value`: Output<String>) {
        this.performanceLevel = value
    }

    /**
     * @param value The read/write IOPS preconfigured for the data disk, which is configured when the disk type is cloud_auto.
     */
    @JvmName("yogcwmelvnqugalv")
    public suspend fun provisionedIops(`value`: Output<Int>) {
        this.provisionedIops = value
    }

    /**
     * @param value The size of a data disk, Its valid value range [40~32768] in GB. Default to `40`.
     */
    @JvmName("akinvlvnlhsdbsji")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value The ID of the snapshot that you want to use to create data disk N. Valid values of N: 1 to 16. If you specify this parameter, DataDisk.N.Size is ignored. The size of the disk is the same as the size of the specified snapshot. If you specify a snapshot that is created on or before July 15, 2013, the operation fails and InvalidSnapshot.TooOld is returned.
     */
    @JvmName("vtbdamwlsrfqvkcr")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value Whether to automatically mount the data disk. Valid values: true and false.
     */
    @JvmName("qxelnovhmdbfligf")
    public suspend fun autoFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoFormat = mapped
    }

    /**
     * @param value The ID of the automatic snapshot policy that you want to apply to the system disk.
     */
    @JvmName("npymoveqpitupfmb")
    public suspend fun autoSnapshotPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoSnapshotPolicyId = mapped
    }

    /**
     * @param value Whether the data disk is enabled with Burst (performance Burst). This is configured when the disk type is cloud_auto.
     */
    @JvmName("apmwnwuknvhxgfwy")
    public suspend fun burstingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.burstingEnabled = mapped
    }

    /**
     * @param value The type of the data disks. Valid values:`cloud`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_auto`.
     */
    @JvmName("cqdrarpqvemdceuf")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The mount target of data disk N. Valid values of N: 1 to 16. If you do not specify this parameter, the system automatically assigns a mount target when Auto Scaling creates ECS instances. The name of the mount target ranges from /dev/xvdb to /dev/xvdz.
     */
    @JvmName("ttestetvjfblaqst")
    public suspend fun device(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.device = mapped
    }

    /**
     * @param value Specifies whether to encrypt data disks. Valid values: true and false. Default to `false`.
     */
    @JvmName("ivueomqhhocwhxwo")
    public suspend fun encrypted(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value The Mount path. Works when auto_format is true.
     */
    @JvmName("cwskrrgputwokmvk")
    public suspend fun fileSystem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystem = mapped
    }

    /**
     * @param value The kms key id used to encrypt the data disk. It takes effect when `encrypted` is true.
     */
    @JvmName("mprisgfpcbyooakr")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The type of the mounted file system. Works when auto_format is true. Optional value: `ext4`, `xfs`.
     */
    @JvmName("xeprcnxtotnpimqr")
    public suspend fun mountTarget(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountTarget = mapped
    }

    /**
     * @param value The length is 2~128 English or Chinese characters. It must start with an uppercase or lowr letter or a Chinese character and cannot start with http:// or https. Can contain numbers, colons (:), underscores (_), or dashes (-). It will be overwritten if auto_format is set.
     */
    @JvmName("fnwserchwuhtmcsw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
     */
    @JvmName("rfcafavfikeyqjlh")
    public suspend fun performanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceLevel = mapped
    }

    /**
     * @param value The read/write IOPS preconfigured for the data disk, which is configured when the disk type is cloud_auto.
     */
    @JvmName("opfixvljvjqlpwxg")
    public suspend fun provisionedIops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionedIops = mapped
    }

    /**
     * @param value The size of a data disk, Its valid value range [40~32768] in GB. Default to `40`.
     */
    @JvmName("vuuonlvuoydfssrx")
    public suspend fun size(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The ID of the snapshot that you want to use to create data disk N. Valid values of N: 1 to 16. If you specify this parameter, DataDisk.N.Size is ignored. The size of the disk is the same as the size of the specified snapshot. If you specify a snapshot that is created on or before July 15, 2013, the operation fails and InvalidSnapshot.TooOld is returned.
     */
    @JvmName("lkkochcuvgpnxvqs")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    internal fun build(): NodePoolDataDiskArgs = NodePoolDataDiskArgs(
        autoFormat = autoFormat,
        autoSnapshotPolicyId = autoSnapshotPolicyId,
        burstingEnabled = burstingEnabled,
        category = category,
        device = device,
        encrypted = encrypted,
        fileSystem = fileSystem,
        kmsKeyId = kmsKeyId,
        mountTarget = mountTarget,
        name = name,
        performanceLevel = performanceLevel,
        provisionedIops = provisionedIops,
        size = size,
        snapshotId = snapshotId,
    )
}
