@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.NodePoolKubeletConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property allowedUnsafeSysctls Allowed sysctl mode whitelist.
 * @property containerLogMaxFiles The maximum number of log files that can exist in each container.
 * @property containerLogMaxSize The maximum size that can be reached before a log file is rotated.
 * @property cpuManagerPolicy Same as cpuManagerPolicy. The name of the policy to use. Requires the CPUManager feature gate to be enabled. Valid value is `none` or `static`.
 * @property eventBurst Same as eventBurst. The maximum size of a burst of event creations, temporarily allows event creations to burst to this number, while still not exceeding `event_record_qps`. It is only used when `event_record_qps` is greater than 0. Valid value is `[0-100]`.
 * @property eventRecordQps Same as eventRecordQPS. The maximum event creations per second. If 0, there is no limit enforced. Valid value is `[0-50]`.
 * @property evictionHard Same as evictionHard. The map of signal names to quantities that defines hard eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
 * @property evictionSoft Same as evictionSoft. The map of signal names to quantities that defines soft eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
 * @property evictionSoftGracePeriod Same as evictionSoftGracePeriod. The map of signal names to quantities that defines grace periods for each soft eviction signal. For example: `{"memory.available" = "30s"}`.
 * @property featureGates Feature switch to enable configuration of experimental features.
 * @property kubeApiBurst Same as kubeAPIBurst. The burst to allow while talking with kubernetes api-server. Valid value is `[0-100]`.
 * @property kubeApiQps Same as kubeAPIQPS. The QPS to use while talking with kubernetes api-server. Valid value is `[0-50]`.
 * @property kubeReserved Same as kubeReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for kubernetes system components. Currently, cpu, memory and local storage for root file system are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
 * @property maxPods The maximum number of running pods.
 * @property readOnlyPort Read-only port number.
 * @property registryBurst Same as registryBurst. The maximum size of burst pulls, temporarily allows pulls to burst to this number, while still not exceeding `registry_pull_qps`. Only used if `registry_pull_qps` is greater than 0. Valid value is `[0-100]`.
 * @property registryPullQps Same as registryPullQPS. The limit of registry pulls per second. Setting it to `0` means no limit. Valid value is `[0-50]`.
 * @property serializeImagePulls Same as serializeImagePulls. When enabled, it tells the Kubelet to pull images one at a time. We recommend not changing the default value on nodes that run docker daemon with version < 1.9 or an Aufs storage backend. Valid value is `true` or `false`.
 * @property systemReserved Same as systemReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for non-kubernetes components. Currently, only cpu and memory are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
 */
public data class NodePoolKubeletConfigurationArgs(
    public val allowedUnsafeSysctls: Output<List<String>>? = null,
    public val containerLogMaxFiles: Output<String>? = null,
    public val containerLogMaxSize: Output<String>? = null,
    public val cpuManagerPolicy: Output<String>? = null,
    public val eventBurst: Output<String>? = null,
    public val eventRecordQps: Output<String>? = null,
    public val evictionHard: Output<Map<String, String>>? = null,
    public val evictionSoft: Output<Map<String, String>>? = null,
    public val evictionSoftGracePeriod: Output<Map<String, String>>? = null,
    public val featureGates: Output<Map<String, Boolean>>? = null,
    public val kubeApiBurst: Output<String>? = null,
    public val kubeApiQps: Output<String>? = null,
    public val kubeReserved: Output<Map<String, String>>? = null,
    public val maxPods: Output<String>? = null,
    public val readOnlyPort: Output<String>? = null,
    public val registryBurst: Output<String>? = null,
    public val registryPullQps: Output<String>? = null,
    public val serializeImagePulls: Output<String>? = null,
    public val systemReserved: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.NodePoolKubeletConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.NodePoolKubeletConfigurationArgs =
        com.pulumi.alicloud.cs.inputs.NodePoolKubeletConfigurationArgs.builder()
            .allowedUnsafeSysctls(allowedUnsafeSysctls?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .containerLogMaxFiles(containerLogMaxFiles?.applyValue({ args0 -> args0 }))
            .containerLogMaxSize(containerLogMaxSize?.applyValue({ args0 -> args0 }))
            .cpuManagerPolicy(cpuManagerPolicy?.applyValue({ args0 -> args0 }))
            .eventBurst(eventBurst?.applyValue({ args0 -> args0 }))
            .eventRecordQps(eventRecordQps?.applyValue({ args0 -> args0 }))
            .evictionHard(
                evictionHard?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .evictionSoft(
                evictionSoft?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .evictionSoftGracePeriod(
                evictionSoftGracePeriod?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .featureGates(
                featureGates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .kubeApiBurst(kubeApiBurst?.applyValue({ args0 -> args0 }))
            .kubeApiQps(kubeApiQps?.applyValue({ args0 -> args0 }))
            .kubeReserved(
                kubeReserved?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .maxPods(maxPods?.applyValue({ args0 -> args0 }))
            .readOnlyPort(readOnlyPort?.applyValue({ args0 -> args0 }))
            .registryBurst(registryBurst?.applyValue({ args0 -> args0 }))
            .registryPullQps(registryPullQps?.applyValue({ args0 -> args0 }))
            .serializeImagePulls(serializeImagePulls?.applyValue({ args0 -> args0 }))
            .systemReserved(
                systemReserved?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NodePoolKubeletConfigurationArgs].
 */
@PulumiTagMarker
public class NodePoolKubeletConfigurationArgsBuilder internal constructor() {
    private var allowedUnsafeSysctls: Output<List<String>>? = null

    private var containerLogMaxFiles: Output<String>? = null

    private var containerLogMaxSize: Output<String>? = null

    private var cpuManagerPolicy: Output<String>? = null

    private var eventBurst: Output<String>? = null

    private var eventRecordQps: Output<String>? = null

    private var evictionHard: Output<Map<String, String>>? = null

    private var evictionSoft: Output<Map<String, String>>? = null

    private var evictionSoftGracePeriod: Output<Map<String, String>>? = null

    private var featureGates: Output<Map<String, Boolean>>? = null

    private var kubeApiBurst: Output<String>? = null

    private var kubeApiQps: Output<String>? = null

    private var kubeReserved: Output<Map<String, String>>? = null

    private var maxPods: Output<String>? = null

    private var readOnlyPort: Output<String>? = null

    private var registryBurst: Output<String>? = null

    private var registryPullQps: Output<String>? = null

    private var serializeImagePulls: Output<String>? = null

    private var systemReserved: Output<Map<String, String>>? = null

    /**
     * @param value Allowed sysctl mode whitelist.
     */
    @JvmName("sprygytjhdmlcwnp")
    public suspend fun allowedUnsafeSysctls(`value`: Output<List<String>>) {
        this.allowedUnsafeSysctls = value
    }

    @JvmName("mxrcanvactupelft")
    public suspend fun allowedUnsafeSysctls(vararg values: Output<String>) {
        this.allowedUnsafeSysctls = Output.all(values.asList())
    }

    /**
     * @param values Allowed sysctl mode whitelist.
     */
    @JvmName("nsmjloksqggjuqax")
    public suspend fun allowedUnsafeSysctls(values: List<Output<String>>) {
        this.allowedUnsafeSysctls = Output.all(values)
    }

    /**
     * @param value The maximum number of log files that can exist in each container.
     */
    @JvmName("ucqgvjnjojqxxmaq")
    public suspend fun containerLogMaxFiles(`value`: Output<String>) {
        this.containerLogMaxFiles = value
    }

    /**
     * @param value The maximum size that can be reached before a log file is rotated.
     */
    @JvmName("tctgkdsxsyoyubjb")
    public suspend fun containerLogMaxSize(`value`: Output<String>) {
        this.containerLogMaxSize = value
    }

    /**
     * @param value Same as cpuManagerPolicy. The name of the policy to use. Requires the CPUManager feature gate to be enabled. Valid value is `none` or `static`.
     */
    @JvmName("votqjdokryfxrgkt")
    public suspend fun cpuManagerPolicy(`value`: Output<String>) {
        this.cpuManagerPolicy = value
    }

    /**
     * @param value Same as eventBurst. The maximum size of a burst of event creations, temporarily allows event creations to burst to this number, while still not exceeding `event_record_qps`. It is only used when `event_record_qps` is greater than 0. Valid value is `[0-100]`.
     */
    @JvmName("hhayhindomnhcjcq")
    public suspend fun eventBurst(`value`: Output<String>) {
        this.eventBurst = value
    }

    /**
     * @param value Same as eventRecordQPS. The maximum event creations per second. If 0, there is no limit enforced. Valid value is `[0-50]`.
     */
    @JvmName("kairrhvpcivjaphb")
    public suspend fun eventRecordQps(`value`: Output<String>) {
        this.eventRecordQps = value
    }

    /**
     * @param value Same as evictionHard. The map of signal names to quantities that defines hard eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
     */
    @JvmName("gspccenoylmkfysd")
    public suspend fun evictionHard(`value`: Output<Map<String, String>>) {
        this.evictionHard = value
    }

    /**
     * @param value Same as evictionSoft. The map of signal names to quantities that defines soft eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
     */
    @JvmName("deudeoipxofjbjhd")
    public suspend fun evictionSoft(`value`: Output<Map<String, String>>) {
        this.evictionSoft = value
    }

    /**
     * @param value Same as evictionSoftGracePeriod. The map of signal names to quantities that defines grace periods for each soft eviction signal. For example: `{"memory.available" = "30s"}`.
     */
    @JvmName("xivdhhabilxskdhm")
    public suspend fun evictionSoftGracePeriod(`value`: Output<Map<String, String>>) {
        this.evictionSoftGracePeriod = value
    }

    /**
     * @param value Feature switch to enable configuration of experimental features.
     */
    @JvmName("sdxdtufreqdargjq")
    public suspend fun featureGates(`value`: Output<Map<String, Boolean>>) {
        this.featureGates = value
    }

    /**
     * @param value Same as kubeAPIBurst. The burst to allow while talking with kubernetes api-server. Valid value is `[0-100]`.
     */
    @JvmName("kuuilqmkmsrkgmkr")
    public suspend fun kubeApiBurst(`value`: Output<String>) {
        this.kubeApiBurst = value
    }

    /**
     * @param value Same as kubeAPIQPS. The QPS to use while talking with kubernetes api-server. Valid value is `[0-50]`.
     */
    @JvmName("rlvxotmxxkewfjvt")
    public suspend fun kubeApiQps(`value`: Output<String>) {
        this.kubeApiQps = value
    }

    /**
     * @param value Same as kubeReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for kubernetes system components. Currently, cpu, memory and local storage for root file system are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
     */
    @JvmName("xaleciuoankuymhn")
    public suspend fun kubeReserved(`value`: Output<Map<String, String>>) {
        this.kubeReserved = value
    }

    /**
     * @param value The maximum number of running pods.
     */
    @JvmName("abeyybpwyfnmerff")
    public suspend fun maxPods(`value`: Output<String>) {
        this.maxPods = value
    }

    /**
     * @param value Read-only port number.
     */
    @JvmName("pfarotqnmfvqfawf")
    public suspend fun readOnlyPort(`value`: Output<String>) {
        this.readOnlyPort = value
    }

    /**
     * @param value Same as registryBurst. The maximum size of burst pulls, temporarily allows pulls to burst to this number, while still not exceeding `registry_pull_qps`. Only used if `registry_pull_qps` is greater than 0. Valid value is `[0-100]`.
     */
    @JvmName("rlieevpqejcwqnbf")
    public suspend fun registryBurst(`value`: Output<String>) {
        this.registryBurst = value
    }

    /**
     * @param value Same as registryPullQPS. The limit of registry pulls per second. Setting it to `0` means no limit. Valid value is `[0-50]`.
     */
    @JvmName("xadwaergomdmskwj")
    public suspend fun registryPullQps(`value`: Output<String>) {
        this.registryPullQps = value
    }

    /**
     * @param value Same as serializeImagePulls. When enabled, it tells the Kubelet to pull images one at a time. We recommend not changing the default value on nodes that run docker daemon with version < 1.9 or an Aufs storage backend. Valid value is `true` or `false`.
     */
    @JvmName("newctdwjqspgaxej")
    public suspend fun serializeImagePulls(`value`: Output<String>) {
        this.serializeImagePulls = value
    }

    /**
     * @param value Same as systemReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for non-kubernetes components. Currently, only cpu and memory are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
     */
    @JvmName("epcjwfmejqrfxoqm")
    public suspend fun systemReserved(`value`: Output<Map<String, String>>) {
        this.systemReserved = value
    }

    /**
     * @param value Allowed sysctl mode whitelist.
     */
    @JvmName("bltxvqdarcqfcmaq")
    public suspend fun allowedUnsafeSysctls(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedUnsafeSysctls = mapped
    }

    /**
     * @param values Allowed sysctl mode whitelist.
     */
    @JvmName("xpsnfjrydsnlcqts")
    public suspend fun allowedUnsafeSysctls(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedUnsafeSysctls = mapped
    }

    /**
     * @param value The maximum number of log files that can exist in each container.
     */
    @JvmName("wigtyicxirhvmwan")
    public suspend fun containerLogMaxFiles(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerLogMaxFiles = mapped
    }

    /**
     * @param value The maximum size that can be reached before a log file is rotated.
     */
    @JvmName("kaojrvcjhrfkvxuj")
    public suspend fun containerLogMaxSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerLogMaxSize = mapped
    }

    /**
     * @param value Same as cpuManagerPolicy. The name of the policy to use. Requires the CPUManager feature gate to be enabled. Valid value is `none` or `static`.
     */
    @JvmName("pjpsgsqjivhmrrwo")
    public suspend fun cpuManagerPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuManagerPolicy = mapped
    }

    /**
     * @param value Same as eventBurst. The maximum size of a burst of event creations, temporarily allows event creations to burst to this number, while still not exceeding `event_record_qps`. It is only used when `event_record_qps` is greater than 0. Valid value is `[0-100]`.
     */
    @JvmName("okpjjcufolypyrrc")
    public suspend fun eventBurst(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventBurst = mapped
    }

    /**
     * @param value Same as eventRecordQPS. The maximum event creations per second. If 0, there is no limit enforced. Valid value is `[0-50]`.
     */
    @JvmName("mxwshwrutwrhawoq")
    public suspend fun eventRecordQps(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventRecordQps = mapped
    }

    /**
     * @param value Same as evictionHard. The map of signal names to quantities that defines hard eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
     */
    @JvmName("hxcajvxexraknulx")
    public suspend fun evictionHard(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evictionHard = mapped
    }

    /**
     * @param values Same as evictionHard. The map of signal names to quantities that defines hard eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
     */
    @JvmName("rfrxqkidaypdkpvn")
    public fun evictionHard(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evictionHard = mapped
    }

    /**
     * @param value Same as evictionSoft. The map of signal names to quantities that defines soft eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
     */
    @JvmName("ihwkiqanlsdimosb")
    public suspend fun evictionSoft(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evictionSoft = mapped
    }

    /**
     * @param values Same as evictionSoft. The map of signal names to quantities that defines soft eviction thresholds. For example: `{"memory.available" = "300Mi"}`.
     */
    @JvmName("hswydfwwxstvdofa")
    public fun evictionSoft(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evictionSoft = mapped
    }

    /**
     * @param value Same as evictionSoftGracePeriod. The map of signal names to quantities that defines grace periods for each soft eviction signal. For example: `{"memory.available" = "30s"}`.
     */
    @JvmName("utfsgjkcmrfmyjog")
    public suspend fun evictionSoftGracePeriod(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evictionSoftGracePeriod = mapped
    }

    /**
     * @param values Same as evictionSoftGracePeriod. The map of signal names to quantities that defines grace periods for each soft eviction signal. For example: `{"memory.available" = "30s"}`.
     */
    @JvmName("tbspabfewntfujhc")
    public fun evictionSoftGracePeriod(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evictionSoftGracePeriod = mapped
    }

    /**
     * @param value Feature switch to enable configuration of experimental features.
     */
    @JvmName("ivxnjhfrwmqplspb")
    public suspend fun featureGates(`value`: Map<String, Boolean>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featureGates = mapped
    }

    /**
     * @param values Feature switch to enable configuration of experimental features.
     */
    @JvmName("maaijbfuoxhqscat")
    public fun featureGates(vararg values: Pair<String, Boolean>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.featureGates = mapped
    }

    /**
     * @param value Same as kubeAPIBurst. The burst to allow while talking with kubernetes api-server. Valid value is `[0-100]`.
     */
    @JvmName("sdceoixbksjtpded")
    public suspend fun kubeApiBurst(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubeApiBurst = mapped
    }

    /**
     * @param value Same as kubeAPIQPS. The QPS to use while talking with kubernetes api-server. Valid value is `[0-50]`.
     */
    @JvmName("oyjxrhbfyiybcrmq")
    public suspend fun kubeApiQps(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubeApiQps = mapped
    }

    /**
     * @param value Same as kubeReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for kubernetes system components. Currently, cpu, memory and local storage for root file system are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
     */
    @JvmName("gytvnrbmtdsncqic")
    public suspend fun kubeReserved(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubeReserved = mapped
    }

    /**
     * @param values Same as kubeReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for kubernetes system components. Currently, cpu, memory and local storage for root file system are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
     */
    @JvmName("ynhuckabcvuomiur")
    public fun kubeReserved(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kubeReserved = mapped
    }

    /**
     * @param value The maximum number of running pods.
     */
    @JvmName("vymlmeidedfesdss")
    public suspend fun maxPods(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPods = mapped
    }

    /**
     * @param value Read-only port number.
     */
    @JvmName("xihitascdojmasch")
    public suspend fun readOnlyPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnlyPort = mapped
    }

    /**
     * @param value Same as registryBurst. The maximum size of burst pulls, temporarily allows pulls to burst to this number, while still not exceeding `registry_pull_qps`. Only used if `registry_pull_qps` is greater than 0. Valid value is `[0-100]`.
     */
    @JvmName("xfytnpwrfabdsghm")
    public suspend fun registryBurst(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryBurst = mapped
    }

    /**
     * @param value Same as registryPullQPS. The limit of registry pulls per second. Setting it to `0` means no limit. Valid value is `[0-50]`.
     */
    @JvmName("gedkjpfxqerjaijx")
    public suspend fun registryPullQps(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryPullQps = mapped
    }

    /**
     * @param value Same as serializeImagePulls. When enabled, it tells the Kubelet to pull images one at a time. We recommend not changing the default value on nodes that run docker daemon with version < 1.9 or an Aufs storage backend. Valid value is `true` or `false`.
     */
    @JvmName("qytdxrypterxvhqy")
    public suspend fun serializeImagePulls(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serializeImagePulls = mapped
    }

    /**
     * @param value Same as systemReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for non-kubernetes components. Currently, only cpu and memory are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
     */
    @JvmName("olvfrfwgqnjdndlk")
    public suspend fun systemReserved(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemReserved = mapped
    }

    /**
     * @param values Same as systemReserved. The set of ResourceName=ResourceQuantity (e.g. cpu=200m,memory=150G) pairs that describe resources reserved for non-kubernetes components. Currently, only cpu and memory are supported. See [compute resources](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/) for more details.
     */
    @JvmName("bnkwfwfcomhhgamr")
    public fun systemReserved(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.systemReserved = mapped
    }

    internal fun build(): NodePoolKubeletConfigurationArgs = NodePoolKubeletConfigurationArgs(
        allowedUnsafeSysctls = allowedUnsafeSysctls,
        containerLogMaxFiles = containerLogMaxFiles,
        containerLogMaxSize = containerLogMaxSize,
        cpuManagerPolicy = cpuManagerPolicy,
        eventBurst = eventBurst,
        eventRecordQps = eventRecordQps,
        evictionHard = evictionHard,
        evictionSoft = evictionSoft,
        evictionSoftGracePeriod = evictionSoftGracePeriod,
        featureGates = featureGates,
        kubeApiBurst = kubeApiBurst,
        kubeApiQps = kubeApiQps,
        kubeReserved = kubeReserved,
        maxPods = maxPods,
        readOnlyPort = readOnlyPort,
        registryBurst = registryBurst,
        registryPullQps = registryPullQps,
        serializeImagePulls = serializeImagePulls,
        systemReserved = systemReserved,
    )
}
