@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.NodePoolLabelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key The label key.
 * @property value The label value.
 */
public data class NodePoolLabelArgs(
    public val key: Output<String>,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.NodePoolLabelArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.NodePoolLabelArgs =
        com.pulumi.alicloud.cs.inputs.NodePoolLabelArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodePoolLabelArgs].
 */
@PulumiTagMarker
public class NodePoolLabelArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The label key.
     */
    @JvmName("tgwhfgauwpbjixyb")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The label value.
     */
    @JvmName("fgwfdyacgtcawlae")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The label key.
     */
    @JvmName("mlciiwgjoyjoxyih")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The label value.
     */
    @JvmName("dtvbcoefmjlvhorc")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): NodePoolLabelArgs = NodePoolLabelArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        `value` = `value`,
    )
}
