@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.NodePoolManagementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property autoRepair Whether to enable automatic repair. Valid values: `true`: Automatic repair. `false`: not automatically repaired.
 * @property autoRepairPolicy Automatic repair node policy. See `auto_repair_policy` below.
 * @property autoUpgrade Specifies whether to enable auto update. Valid values: `true`: enables auto update. `false`: disables auto update.
 * @property autoUpgradePolicy The auto update policy. See `auto_upgrade_policy` below.
 * @property autoVulFix Specifies whether to automatically patch CVE vulnerabilities. Valid values: `true`, `false`.
 * @property autoVulFixPolicy The auto CVE patching policy. See `auto_vul_fix_policy` below.
 * @property enable Specifies whether to enable the managed node pool feature. Valid values: `true`: enables the managed node pool feature. `false`: disables the managed node pool feature. Other parameters in this section take effect only when you specify enable=true.
 * @property maxUnavailable Maximum number of unavailable nodes. Default value: 1. Value range:\[1,1000\].
 * @property surge Number of additional nodes. You have to specify one of surge, surge_percentage.
 * @property surgePercentage Proportion of additional nodes. You have to specify one of surge, surge_percentage.
 */
public data class NodePoolManagementArgs(
    public val autoRepair: Output<Boolean>? = null,
    public val autoRepairPolicy: Output<NodePoolManagementAutoRepairPolicyArgs>? = null,
    public val autoUpgrade: Output<Boolean>? = null,
    public val autoUpgradePolicy: Output<NodePoolManagementAutoUpgradePolicyArgs>? = null,
    public val autoVulFix: Output<Boolean>? = null,
    public val autoVulFixPolicy: Output<NodePoolManagementAutoVulFixPolicyArgs>? = null,
    public val enable: Output<Boolean>? = null,
    public val maxUnavailable: Output<Int>? = null,
    @Deprecated(
        message = """
  Field 'surge' has been deprecated from provider version 1.219.0. Number of additional nodes. You
      have to specify one of surge, surge_percentage.
  """,
    )
    public val surge: Output<Int>? = null,
    @Deprecated(
        message = """
  Field 'surge_percentage' has been deprecated from provider version 1.219.0. Proportion of
      additional nodes. You have to specify one of surge, surge_percentage.
  """,
    )
    public val surgePercentage: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.NodePoolManagementArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.NodePoolManagementArgs =
        com.pulumi.alicloud.cs.inputs.NodePoolManagementArgs.builder()
            .autoRepair(autoRepair?.applyValue({ args0 -> args0 }))
            .autoRepairPolicy(autoRepairPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .autoUpgrade(autoUpgrade?.applyValue({ args0 -> args0 }))
            .autoUpgradePolicy(autoUpgradePolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .autoVulFix(autoVulFix?.applyValue({ args0 -> args0 }))
            .autoVulFixPolicy(autoVulFixPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .maxUnavailable(maxUnavailable?.applyValue({ args0 -> args0 }))
            .surge(surge?.applyValue({ args0 -> args0 }))
            .surgePercentage(surgePercentage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodePoolManagementArgs].
 */
@PulumiTagMarker
public class NodePoolManagementArgsBuilder internal constructor() {
    private var autoRepair: Output<Boolean>? = null

    private var autoRepairPolicy: Output<NodePoolManagementAutoRepairPolicyArgs>? = null

    private var autoUpgrade: Output<Boolean>? = null

    private var autoUpgradePolicy: Output<NodePoolManagementAutoUpgradePolicyArgs>? = null

    private var autoVulFix: Output<Boolean>? = null

    private var autoVulFixPolicy: Output<NodePoolManagementAutoVulFixPolicyArgs>? = null

    private var enable: Output<Boolean>? = null

    private var maxUnavailable: Output<Int>? = null

    private var surge: Output<Int>? = null

    private var surgePercentage: Output<Int>? = null

    /**
     * @param value Whether to enable automatic repair. Valid values: `true`: Automatic repair. `false`: not automatically repaired.
     */
    @JvmName("ownbltstgaehaqxo")
    public suspend fun autoRepair(`value`: Output<Boolean>) {
        this.autoRepair = value
    }

    /**
     * @param value Automatic repair node policy. See `auto_repair_policy` below.
     */
    @JvmName("icxyedsqojdqtrsr")
    public suspend fun autoRepairPolicy(`value`: Output<NodePoolManagementAutoRepairPolicyArgs>) {
        this.autoRepairPolicy = value
    }

    /**
     * @param value Specifies whether to enable auto update. Valid values: `true`: enables auto update. `false`: disables auto update.
     */
    @JvmName("agamftwxqbcqtwaj")
    public suspend fun autoUpgrade(`value`: Output<Boolean>) {
        this.autoUpgrade = value
    }

    /**
     * @param value The auto update policy. See `auto_upgrade_policy` below.
     */
    @JvmName("yqxoanshqtxkfsfv")
    public suspend fun autoUpgradePolicy(`value`: Output<NodePoolManagementAutoUpgradePolicyArgs>) {
        this.autoUpgradePolicy = value
    }

    /**
     * @param value Specifies whether to automatically patch CVE vulnerabilities. Valid values: `true`, `false`.
     */
    @JvmName("onncopevlfowfaqk")
    public suspend fun autoVulFix(`value`: Output<Boolean>) {
        this.autoVulFix = value
    }

    /**
     * @param value The auto CVE patching policy. See `auto_vul_fix_policy` below.
     */
    @JvmName("cdetgaqfqyxpfsdi")
    public suspend fun autoVulFixPolicy(`value`: Output<NodePoolManagementAutoVulFixPolicyArgs>) {
        this.autoVulFixPolicy = value
    }

    /**
     * @param value Specifies whether to enable the managed node pool feature. Valid values: `true`: enables the managed node pool feature. `false`: disables the managed node pool feature. Other parameters in this section take effect only when you specify enable=true.
     */
    @JvmName("ttnfcvtlrwfppiww")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value Maximum number of unavailable nodes. Default value: 1. Value range:\[1,1000\].
     */
    @JvmName("xflmynrgmidvtaku")
    public suspend fun maxUnavailable(`value`: Output<Int>) {
        this.maxUnavailable = value
    }

    /**
     * @param value Number of additional nodes. You have to specify one of surge, surge_percentage.
     */
    @Deprecated(
        message = """
  Field 'surge' has been deprecated from provider version 1.219.0. Number of additional nodes. You
      have to specify one of surge, surge_percentage.
  """,
    )
    @JvmName("efleuhjrnftatbod")
    public suspend fun surge(`value`: Output<Int>) {
        this.surge = value
    }

    /**
     * @param value Proportion of additional nodes. You have to specify one of surge, surge_percentage.
     */
    @Deprecated(
        message = """
  Field 'surge_percentage' has been deprecated from provider version 1.219.0. Proportion of
      additional nodes. You have to specify one of surge, surge_percentage.
  """,
    )
    @JvmName("cjxdbnkcvkgyxoip")
    public suspend fun surgePercentage(`value`: Output<Int>) {
        this.surgePercentage = value
    }

    /**
     * @param value Whether to enable automatic repair. Valid values: `true`: Automatic repair. `false`: not automatically repaired.
     */
    @JvmName("dmcovhtqsaglgnir")
    public suspend fun autoRepair(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRepair = mapped
    }

    /**
     * @param value Automatic repair node policy. See `auto_repair_policy` below.
     */
    @JvmName("qhlfyikwbqpewnfq")
    public suspend fun autoRepairPolicy(`value`: NodePoolManagementAutoRepairPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRepairPolicy = mapped
    }

    /**
     * @param argument Automatic repair node policy. See `auto_repair_policy` below.
     */
    @JvmName("bensaabwmbgjbwne")
    public suspend fun autoRepairPolicy(argument: suspend NodePoolManagementAutoRepairPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = NodePoolManagementAutoRepairPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoRepairPolicy = mapped
    }

    /**
     * @param value Specifies whether to enable auto update. Valid values: `true`: enables auto update. `false`: disables auto update.
     */
    @JvmName("mfxqghooleyogygy")
    public suspend fun autoUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUpgrade = mapped
    }

    /**
     * @param value The auto update policy. See `auto_upgrade_policy` below.
     */
    @JvmName("oumocxlnchqysern")
    public suspend fun autoUpgradePolicy(`value`: NodePoolManagementAutoUpgradePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUpgradePolicy = mapped
    }

    /**
     * @param argument The auto update policy. See `auto_upgrade_policy` below.
     */
    @JvmName("yxgsdlndmpwejtrf")
    public suspend fun autoUpgradePolicy(argument: suspend NodePoolManagementAutoUpgradePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = NodePoolManagementAutoUpgradePolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoUpgradePolicy = mapped
    }

    /**
     * @param value Specifies whether to automatically patch CVE vulnerabilities. Valid values: `true`, `false`.
     */
    @JvmName("fyhqpchkkisccnwd")
    public suspend fun autoVulFix(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoVulFix = mapped
    }

    /**
     * @param value The auto CVE patching policy. See `auto_vul_fix_policy` below.
     */
    @JvmName("deysugjpjgvymekm")
    public suspend fun autoVulFixPolicy(`value`: NodePoolManagementAutoVulFixPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoVulFixPolicy = mapped
    }

    /**
     * @param argument The auto CVE patching policy. See `auto_vul_fix_policy` below.
     */
    @JvmName("ttlojhakghclcvrc")
    public suspend fun autoVulFixPolicy(argument: suspend NodePoolManagementAutoVulFixPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = NodePoolManagementAutoVulFixPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoVulFixPolicy = mapped
    }

    /**
     * @param value Specifies whether to enable the managed node pool feature. Valid values: `true`: enables the managed node pool feature. `false`: disables the managed node pool feature. Other parameters in this section take effect only when you specify enable=true.
     */
    @JvmName("xgnkswxiearvlfkg")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value Maximum number of unavailable nodes. Default value: 1. Value range:\[1,1000\].
     */
    @JvmName("gajuxindyhssxcjb")
    public suspend fun maxUnavailable(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxUnavailable = mapped
    }

    /**
     * @param value Number of additional nodes. You have to specify one of surge, surge_percentage.
     */
    @Deprecated(
        message = """
  Field 'surge' has been deprecated from provider version 1.219.0. Number of additional nodes. You
      have to specify one of surge, surge_percentage.
  """,
    )
    @JvmName("rnhdhlqfkmioqclv")
    public suspend fun surge(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.surge = mapped
    }

    /**
     * @param value Proportion of additional nodes. You have to specify one of surge, surge_percentage.
     */
    @Deprecated(
        message = """
  Field 'surge_percentage' has been deprecated from provider version 1.219.0. Proportion of
      additional nodes. You have to specify one of surge, surge_percentage.
  """,
    )
    @JvmName("dgcyxrcaepusyvkk")
    public suspend fun surgePercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.surgePercentage = mapped
    }

    internal fun build(): NodePoolManagementArgs = NodePoolManagementArgs(
        autoRepair = autoRepair,
        autoRepairPolicy = autoRepairPolicy,
        autoUpgrade = autoUpgrade,
        autoUpgradePolicy = autoUpgradePolicy,
        autoVulFix = autoVulFix,
        autoVulFixPolicy = autoVulFixPolicy,
        enable = enable,
        maxUnavailable = maxUnavailable,
        surge = surge,
        surgePercentage = surgePercentage,
    )
}
