@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.NodePoolManagementAutoRepairPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property restartNode Specifies whether to automatically restart nodes after patching CVE vulnerabilities. Valid values: `true`, `false`.
 */
public data class NodePoolManagementAutoRepairPolicyArgs(
    public val restartNode: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.NodePoolManagementAutoRepairPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.NodePoolManagementAutoRepairPolicyArgs =
        com.pulumi.alicloud.cs.inputs.NodePoolManagementAutoRepairPolicyArgs.builder()
            .restartNode(restartNode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodePoolManagementAutoRepairPolicyArgs].
 */
@PulumiTagMarker
public class NodePoolManagementAutoRepairPolicyArgsBuilder internal constructor() {
    private var restartNode: Output<Boolean>? = null

    /**
     * @param value Specifies whether to automatically restart nodes after patching CVE vulnerabilities. Valid values: `true`, `false`.
     */
    @JvmName("imejevngqkokcunk")
    public suspend fun restartNode(`value`: Output<Boolean>) {
        this.restartNode = value
    }

    /**
     * @param value Specifies whether to automatically restart nodes after patching CVE vulnerabilities. Valid values: `true`, `false`.
     */
    @JvmName("hasoucmrnpbibxyq")
    public suspend fun restartNode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restartNode = mapped
    }

    internal fun build(): NodePoolManagementAutoRepairPolicyArgs =
        NodePoolManagementAutoRepairPolicyArgs(
            restartNode = restartNode,
        )
}
