@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.NodePoolManagementAutoUpgradePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property autoUpgradeKubelet Specifies whether  to automatically update the kubelet. Valid values: `true`: yes; `false`: no.
 */
public data class NodePoolManagementAutoUpgradePolicyArgs(
    public val autoUpgradeKubelet: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.NodePoolManagementAutoUpgradePolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.NodePoolManagementAutoUpgradePolicyArgs =
        com.pulumi.alicloud.cs.inputs.NodePoolManagementAutoUpgradePolicyArgs.builder()
            .autoUpgradeKubelet(autoUpgradeKubelet?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodePoolManagementAutoUpgradePolicyArgs].
 */
@PulumiTagMarker
public class NodePoolManagementAutoUpgradePolicyArgsBuilder internal constructor() {
    private var autoUpgradeKubelet: Output<Boolean>? = null

    /**
     * @param value Specifies whether  to automatically update the kubelet. Valid values: `true`: yes; `false`: no.
     */
    @JvmName("otigdcsmnueskqof")
    public suspend fun autoUpgradeKubelet(`value`: Output<Boolean>) {
        this.autoUpgradeKubelet = value
    }

    /**
     * @param value Specifies whether  to automatically update the kubelet. Valid values: `true`: yes; `false`: no.
     */
    @JvmName("pfegydaxfcbhkhqq")
    public suspend fun autoUpgradeKubelet(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUpgradeKubelet = mapped
    }

    internal fun build(): NodePoolManagementAutoUpgradePolicyArgs =
        NodePoolManagementAutoUpgradePolicyArgs(
            autoUpgradeKubelet = autoUpgradeKubelet,
        )
}
