@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.NodePoolManagementAutoVulFixPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property restartNode Specifies whether to automatically restart nodes after patching CVE vulnerabilities. Valid values: `true`, `false`.
 * @property vulLevel The severity levels of vulnerabilities that is allowed to automatically patch. Multiple severity levels are separated by commas (,).
 */
public data class NodePoolManagementAutoVulFixPolicyArgs(
    public val restartNode: Output<Boolean>? = null,
    public val vulLevel: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.NodePoolManagementAutoVulFixPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.NodePoolManagementAutoVulFixPolicyArgs =
        com.pulumi.alicloud.cs.inputs.NodePoolManagementAutoVulFixPolicyArgs.builder()
            .restartNode(restartNode?.applyValue({ args0 -> args0 }))
            .vulLevel(vulLevel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodePoolManagementAutoVulFixPolicyArgs].
 */
@PulumiTagMarker
public class NodePoolManagementAutoVulFixPolicyArgsBuilder internal constructor() {
    private var restartNode: Output<Boolean>? = null

    private var vulLevel: Output<String>? = null

    /**
     * @param value Specifies whether to automatically restart nodes after patching CVE vulnerabilities. Valid values: `true`, `false`.
     */
    @JvmName("omwxcygohrksvbqw")
    public suspend fun restartNode(`value`: Output<Boolean>) {
        this.restartNode = value
    }

    /**
     * @param value The severity levels of vulnerabilities that is allowed to automatically patch. Multiple severity levels are separated by commas (,).
     */
    @JvmName("aubxxatduaewrpoe")
    public suspend fun vulLevel(`value`: Output<String>) {
        this.vulLevel = value
    }

    /**
     * @param value Specifies whether to automatically restart nodes after patching CVE vulnerabilities. Valid values: `true`, `false`.
     */
    @JvmName("tcfywlmbvkrlyxas")
    public suspend fun restartNode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restartNode = mapped
    }

    /**
     * @param value The severity levels of vulnerabilities that is allowed to automatically patch. Multiple severity levels are separated by commas (,).
     */
    @JvmName("xxcvnxdvpijomxmc")
    public suspend fun vulLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vulLevel = mapped
    }

    internal fun build(): NodePoolManagementAutoVulFixPolicyArgs =
        NodePoolManagementAutoVulFixPolicyArgs(
            restartNode = restartNode,
            vulLevel = vulLevel,
        )
}
