@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.NodePoolPrivatePoolOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privatePoolOptionsId The ID of the private node pool.
 * @property privatePoolOptionsMatchCriteria The type of private node pool. This parameter specifies the type of the private pool that you want to use to create instances. A private node pool is generated when an elasticity assurance or a capacity reservation service takes effect. The system selects a private node pool to launch instances. Valid values: `Open`: specifies an open private node pool. The system selects an open private node pool to launch instances. If no matching open private node pool is available, the resources in the public node pool are used. `Target`: specifies a private node pool. The system uses the resources of the specified private node pool to launch instances. If the specified private node pool is unavailable, instances cannot be started. `None`: no private node pool is used. The resources of private node pools are not used to launch the instances.
 */
public data class NodePoolPrivatePoolOptionsArgs(
    public val privatePoolOptionsId: Output<String>? = null,
    public val privatePoolOptionsMatchCriteria: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.NodePoolPrivatePoolOptionsArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.NodePoolPrivatePoolOptionsArgs =
        com.pulumi.alicloud.cs.inputs.NodePoolPrivatePoolOptionsArgs.builder()
            .privatePoolOptionsId(privatePoolOptionsId?.applyValue({ args0 -> args0 }))
            .privatePoolOptionsMatchCriteria(
                privatePoolOptionsMatchCriteria?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [NodePoolPrivatePoolOptionsArgs].
 */
@PulumiTagMarker
public class NodePoolPrivatePoolOptionsArgsBuilder internal constructor() {
    private var privatePoolOptionsId: Output<String>? = null

    private var privatePoolOptionsMatchCriteria: Output<String>? = null

    /**
     * @param value The ID of the private node pool.
     */
    @JvmName("ainbpkxljrqlsili")
    public suspend fun privatePoolOptionsId(`value`: Output<String>) {
        this.privatePoolOptionsId = value
    }

    /**
     * @param value The type of private node pool. This parameter specifies the type of the private pool that you want to use to create instances. A private node pool is generated when an elasticity assurance or a capacity reservation service takes effect. The system selects a private node pool to launch instances. Valid values: `Open`: specifies an open private node pool. The system selects an open private node pool to launch instances. If no matching open private node pool is available, the resources in the public node pool are used. `Target`: specifies a private node pool. The system uses the resources of the specified private node pool to launch instances. If the specified private node pool is unavailable, instances cannot be started. `None`: no private node pool is used. The resources of private node pools are not used to launch the instances.
     */
    @JvmName("yhofjambuxknmubk")
    public suspend fun privatePoolOptionsMatchCriteria(`value`: Output<String>) {
        this.privatePoolOptionsMatchCriteria = value
    }

    /**
     * @param value The ID of the private node pool.
     */
    @JvmName("ofjiyimunexnfali")
    public suspend fun privatePoolOptionsId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privatePoolOptionsId = mapped
    }

    /**
     * @param value The type of private node pool. This parameter specifies the type of the private pool that you want to use to create instances. A private node pool is generated when an elasticity assurance or a capacity reservation service takes effect. The system selects a private node pool to launch instances. Valid values: `Open`: specifies an open private node pool. The system selects an open private node pool to launch instances. If no matching open private node pool is available, the resources in the public node pool are used. `Target`: specifies a private node pool. The system uses the resources of the specified private node pool to launch instances. If the specified private node pool is unavailable, instances cannot be started. `None`: no private node pool is used. The resources of private node pools are not used to launch the instances.
     */
    @JvmName("xcuvuvlcychnmkbu")
    public suspend fun privatePoolOptionsMatchCriteria(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privatePoolOptionsMatchCriteria = mapped
    }

    internal fun build(): NodePoolPrivatePoolOptionsArgs = NodePoolPrivatePoolOptionsArgs(
        privatePoolOptionsId = privatePoolOptionsId,
        privatePoolOptionsMatchCriteria = privatePoolOptionsMatchCriteria,
    )
}
