@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.NodePoolRollingPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxParallelism The maximum number of unusable nodes.
 */
public data class NodePoolRollingPolicyArgs(
    public val maxParallelism: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.NodePoolRollingPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.NodePoolRollingPolicyArgs =
        com.pulumi.alicloud.cs.inputs.NodePoolRollingPolicyArgs.builder()
            .maxParallelism(maxParallelism?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodePoolRollingPolicyArgs].
 */
@PulumiTagMarker
public class NodePoolRollingPolicyArgsBuilder internal constructor() {
    private var maxParallelism: Output<Int>? = null

    /**
     * @param value The maximum number of unusable nodes.
     */
    @JvmName("bhdmtklixxopetwn")
    public suspend fun maxParallelism(`value`: Output<Int>) {
        this.maxParallelism = value
    }

    /**
     * @param value The maximum number of unusable nodes.
     */
    @JvmName("wasyduhsusnwelhk")
    public suspend fun maxParallelism(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxParallelism = mapped
    }

    internal fun build(): NodePoolRollingPolicyArgs = NodePoolRollingPolicyArgs(
        maxParallelism = maxParallelism,
    )
}
