@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.NodePoolScalingConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eipBandwidth Peak EIP bandwidth. Its valid value range [1~500] in Mbps. It works if `is_bond_eip=true`. Default to `5`.
 * @property eipInternetChargeType EIP billing type. `PayByBandwidth`: Charged at fixed bandwidth. `PayByTraffic`: Billed as used traffic. Default: `PayByBandwidth`. It works if `is_bond_eip=true`, conflict with `internet_charge_type`. EIP and public network IP can only choose one.
 * @property enable Whether to enable automatic scaling. Value:
 * @property isBondEip Whether to bind EIP for an instance. Default: `false`.
 * @property maxSize Max number of instances in a auto scaling group, its valid value range [0~1000]. `max_size` has to be greater than `min_size`.
 * @property minSize Min number of instances in a auto scaling group, its valid value range [0~1000].
 * @property type Instance classification, not required. Vaild value: `cpu`, `gpu`, `gpushare` and `spot`. Default: `cpu`. The actual instance type is determined by `instance_types`.
 */
public data class NodePoolScalingConfigArgs(
    public val eipBandwidth: Output<Int>? = null,
    public val eipInternetChargeType: Output<String>? = null,
    public val enable: Output<Boolean>? = null,
    public val isBondEip: Output<Boolean>? = null,
    public val maxSize: Output<Int>? = null,
    public val minSize: Output<Int>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.NodePoolScalingConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.NodePoolScalingConfigArgs =
        com.pulumi.alicloud.cs.inputs.NodePoolScalingConfigArgs.builder()
            .eipBandwidth(eipBandwidth?.applyValue({ args0 -> args0 }))
            .eipInternetChargeType(eipInternetChargeType?.applyValue({ args0 -> args0 }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .isBondEip(isBondEip?.applyValue({ args0 -> args0 }))
            .maxSize(maxSize?.applyValue({ args0 -> args0 }))
            .minSize(minSize?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodePoolScalingConfigArgs].
 */
@PulumiTagMarker
public class NodePoolScalingConfigArgsBuilder internal constructor() {
    private var eipBandwidth: Output<Int>? = null

    private var eipInternetChargeType: Output<String>? = null

    private var enable: Output<Boolean>? = null

    private var isBondEip: Output<Boolean>? = null

    private var maxSize: Output<Int>? = null

    private var minSize: Output<Int>? = null

    private var type: Output<String>? = null

    /**
     * @param value Peak EIP bandwidth. Its valid value range [1~500] in Mbps. It works if `is_bond_eip=true`. Default to `5`.
     */
    @JvmName("pdjdddhwjourmots")
    public suspend fun eipBandwidth(`value`: Output<Int>) {
        this.eipBandwidth = value
    }

    /**
     * @param value EIP billing type. `PayByBandwidth`: Charged at fixed bandwidth. `PayByTraffic`: Billed as used traffic. Default: `PayByBandwidth`. It works if `is_bond_eip=true`, conflict with `internet_charge_type`. EIP and public network IP can only choose one.
     */
    @JvmName("pxhqwluaohlvajeg")
    public suspend fun eipInternetChargeType(`value`: Output<String>) {
        this.eipInternetChargeType = value
    }

    /**
     * @param value Whether to enable automatic scaling. Value:
     */
    @JvmName("glwfqwcaapgmxaxg")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value Whether to bind EIP for an instance. Default: `false`.
     */
    @JvmName("lxjejrfwwwmlvqmf")
    public suspend fun isBondEip(`value`: Output<Boolean>) {
        this.isBondEip = value
    }

    /**
     * @param value Max number of instances in a auto scaling group, its valid value range [0~1000]. `max_size` has to be greater than `min_size`.
     */
    @JvmName("uhswsltktkqhdbid")
    public suspend fun maxSize(`value`: Output<Int>) {
        this.maxSize = value
    }

    /**
     * @param value Min number of instances in a auto scaling group, its valid value range [0~1000].
     */
    @JvmName("dquoetpufhbcemtg")
    public suspend fun minSize(`value`: Output<Int>) {
        this.minSize = value
    }

    /**
     * @param value Instance classification, not required. Vaild value: `cpu`, `gpu`, `gpushare` and `spot`. Default: `cpu`. The actual instance type is determined by `instance_types`.
     */
    @JvmName("utfehevituhvubhr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Peak EIP bandwidth. Its valid value range [1~500] in Mbps. It works if `is_bond_eip=true`. Default to `5`.
     */
    @JvmName("ltopgcbwwwyucoww")
    public suspend fun eipBandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eipBandwidth = mapped
    }

    /**
     * @param value EIP billing type. `PayByBandwidth`: Charged at fixed bandwidth. `PayByTraffic`: Billed as used traffic. Default: `PayByBandwidth`. It works if `is_bond_eip=true`, conflict with `internet_charge_type`. EIP and public network IP can only choose one.
     */
    @JvmName("dtxpwligglorsulv")
    public suspend fun eipInternetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eipInternetChargeType = mapped
    }

    /**
     * @param value Whether to enable automatic scaling. Value:
     */
    @JvmName("wqtudeeubgyrdmwk")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value Whether to bind EIP for an instance. Default: `false`.
     */
    @JvmName("rfambxjwdmiaypyb")
    public suspend fun isBondEip(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isBondEip = mapped
    }

    /**
     * @param value Max number of instances in a auto scaling group, its valid value range [0~1000]. `max_size` has to be greater than `min_size`.
     */
    @JvmName("pirljwbpfubqjwhr")
    public suspend fun maxSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSize = mapped
    }

    /**
     * @param value Min number of instances in a auto scaling group, its valid value range [0~1000].
     */
    @JvmName("kvrthxobnxsbwhbr")
    public suspend fun minSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minSize = mapped
    }

    /**
     * @param value Instance classification, not required. Vaild value: `cpu`, `gpu`, `gpushare` and `spot`. Default: `cpu`. The actual instance type is determined by `instance_types`.
     */
    @JvmName("onsfvfcyuhxsscmo")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): NodePoolScalingConfigArgs = NodePoolScalingConfigArgs(
        eipBandwidth = eipBandwidth,
        eipInternetChargeType = eipInternetChargeType,
        enable = enable,
        isBondEip = isBondEip,
        maxSize = maxSize,
        minSize = minSize,
        type = type,
    )
}
