@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.NodePoolSpotPriceLimitArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceType The type of the preemptible instance.
 * @property priceLimit The maximum price of a single instance.
 */
public data class NodePoolSpotPriceLimitArgs(
    public val instanceType: Output<String>? = null,
    public val priceLimit: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.NodePoolSpotPriceLimitArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.NodePoolSpotPriceLimitArgs =
        com.pulumi.alicloud.cs.inputs.NodePoolSpotPriceLimitArgs.builder()
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .priceLimit(priceLimit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodePoolSpotPriceLimitArgs].
 */
@PulumiTagMarker
public class NodePoolSpotPriceLimitArgsBuilder internal constructor() {
    private var instanceType: Output<String>? = null

    private var priceLimit: Output<String>? = null

    /**
     * @param value The type of the preemptible instance.
     */
    @JvmName("jdndplmccacmoxuo")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The maximum price of a single instance.
     */
    @JvmName("ufqtuijgognahgwa")
    public suspend fun priceLimit(`value`: Output<String>) {
        this.priceLimit = value
    }

    /**
     * @param value The type of the preemptible instance.
     */
    @JvmName("rxyfvtjsfsqsrqdj")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The maximum price of a single instance.
     */
    @JvmName("kviybuvcuqhvmqll")
    public suspend fun priceLimit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priceLimit = mapped
    }

    internal fun build(): NodePoolSpotPriceLimitArgs = NodePoolSpotPriceLimitArgs(
        instanceType = instanceType,
        priceLimit = priceLimit,
    )
}
