@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.NodePoolTaintArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property effect The scheduling policy.
 * @property key The key of a taint.
 * @property value The value of a taint.
 */
public data class NodePoolTaintArgs(
    public val effect: Output<String>? = null,
    public val key: Output<String>,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.NodePoolTaintArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.NodePoolTaintArgs =
        com.pulumi.alicloud.cs.inputs.NodePoolTaintArgs.builder()
            .effect(effect?.applyValue({ args0 -> args0 }))
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodePoolTaintArgs].
 */
@PulumiTagMarker
public class NodePoolTaintArgsBuilder internal constructor() {
    private var effect: Output<String>? = null

    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The scheduling policy.
     */
    @JvmName("ldfffmsceaposcfs")
    public suspend fun effect(`value`: Output<String>) {
        this.effect = value
    }

    /**
     * @param value The key of a taint.
     */
    @JvmName("bxnaspasryllikrv")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The value of a taint.
     */
    @JvmName("cronfirikjgwapnw")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The scheduling policy.
     */
    @JvmName("orgfayvfcfdftsud")
    public suspend fun effect(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effect = mapped
    }

    /**
     * @param value The key of a taint.
     */
    @JvmName("wgdanmndbilembsp")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The value of a taint.
     */
    @JvmName("voxcbvnowrypwhdi")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): NodePoolTaintArgs = NodePoolTaintArgs(
        effect = effect,
        key = key ?: throw PulumiNullFieldException("key"),
        `value` = `value`,
    )
}
