@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.NodePoolTeeConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property teeEnable Specifies whether to enable confidential computing for the cluster.
 */
public data class NodePoolTeeConfigArgs(
    public val teeEnable: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.NodePoolTeeConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.NodePoolTeeConfigArgs =
        com.pulumi.alicloud.cs.inputs.NodePoolTeeConfigArgs.builder()
            .teeEnable(teeEnable?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodePoolTeeConfigArgs].
 */
@PulumiTagMarker
public class NodePoolTeeConfigArgsBuilder internal constructor() {
    private var teeEnable: Output<Boolean>? = null

    /**
     * @param value Specifies whether to enable confidential computing for the cluster.
     */
    @JvmName("idbnbjslhijcruik")
    public suspend fun teeEnable(`value`: Output<Boolean>) {
        this.teeEnable = value
    }

    /**
     * @param value Specifies whether to enable confidential computing for the cluster.
     */
    @JvmName("hdvuryggbgceradf")
    public suspend fun teeEnable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.teeEnable = mapped
    }

    internal fun build(): NodePoolTeeConfigArgs = NodePoolTeeConfigArgs(
        teeEnable = teeEnable,
    )
}
