@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.ServerlessKubernetesAddonArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property config The ACK add-on configurations. For more config information, see cs_kubernetes_addon_metadata.
 * @property disabled Disables the automatic installation of a component. Default is `false`.
 * The following example is the definition of addons block, The type of this field is list:
 * ```
 * # install nginx ingress, conflict with SLB ingress
 * addons {
 * name = "nginx-ingress-controller"
 * # use internet
 * config = "{\"IngressSlbNetworkType\":\"internet",\"IngressSlbSpec\":\"slb.s2.small\"}"
 * # if use intranet, detail below.
 * # config = "{\"IngressSlbNetworkType\":\"intranet",\"IngressSlbSpec\":\"slb.s2.small\"}"
 * }
 * # install SLB ingress, conflict with nginx ingress
 * addons {
 * name = "alb-ingress-controller"
 * }
 * # install metric server
 * addons {
 * name = "metrics-server"
 * }
 * # install knative
 * addons {
 * name = "knative"
 * }
 * # install prometheus
 * addons {
 * name = "arms-prometheus"
 * # prometheus also provides managed version, specify with name `managed-arms-prometheus` for professional serverless clusters
 * # name = "managed-arms-prometheus"
 * }
 * ```
 * @property name Name of the ACK add-on. The name must match one of the names returned by [DescribeAddons](https://help.aliyun.com/document_detail/171524.html).
 */
public data class ServerlessKubernetesAddonArgs(
    public val config: Output<String>? = null,
    public val disabled: Output<Boolean>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.ServerlessKubernetesAddonArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.ServerlessKubernetesAddonArgs =
        com.pulumi.alicloud.cs.inputs.ServerlessKubernetesAddonArgs.builder()
            .config(config?.applyValue({ args0 -> args0 }))
            .disabled(disabled?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerlessKubernetesAddonArgs].
 */
@PulumiTagMarker
public class ServerlessKubernetesAddonArgsBuilder internal constructor() {
    private var config: Output<String>? = null

    private var disabled: Output<Boolean>? = null

    private var name: Output<String>? = null

    /**
     * @param value The ACK add-on configurations. For more config information, see cs_kubernetes_addon_metadata.
     */
    @JvmName("qfeblsypmtqoeaox")
    public suspend fun config(`value`: Output<String>) {
        this.config = value
    }

    /**
     * @param value Disables the automatic installation of a component. Default is `false`.
     * The following example is the definition of addons block, The type of this field is list:
     * ```
     * # install nginx ingress, conflict with SLB ingress
     * addons {
     * name = "nginx-ingress-controller"
     * # use internet
     * config = "{\"IngressSlbNetworkType\":\"internet",\"IngressSlbSpec\":\"slb.s2.small\"}"
     * # if use intranet, detail below.
     * # config = "{\"IngressSlbNetworkType\":\"intranet",\"IngressSlbSpec\":\"slb.s2.small\"}"
     * }
     * # install SLB ingress, conflict with nginx ingress
     * addons {
     * name = "alb-ingress-controller"
     * }
     * # install metric server
     * addons {
     * name = "metrics-server"
     * }
     * # install knative
     * addons {
     * name = "knative"
     * }
     * # install prometheus
     * addons {
     * name = "arms-prometheus"
     * # prometheus also provides managed version, specify with name `managed-arms-prometheus` for professional serverless clusters
     * # name = "managed-arms-prometheus"
     * }
     * ```
     */
    @JvmName("nteybjjtcrhyyimt")
    public suspend fun disabled(`value`: Output<Boolean>) {
        this.disabled = value
    }

    /**
     * @param value Name of the ACK add-on. The name must match one of the names returned by [DescribeAddons](https://help.aliyun.com/document_detail/171524.html).
     */
    @JvmName("ojdfrnqlbahoksff")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ACK add-on configurations. For more config information, see cs_kubernetes_addon_metadata.
     */
    @JvmName("hvlcvaymhupcuqqc")
    public suspend fun config(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.config = mapped
    }

    /**
     * @param value Disables the automatic installation of a component. Default is `false`.
     * The following example is the definition of addons block, The type of this field is list:
     * ```
     * # install nginx ingress, conflict with SLB ingress
     * addons {
     * name = "nginx-ingress-controller"
     * # use internet
     * config = "{\"IngressSlbNetworkType\":\"internet",\"IngressSlbSpec\":\"slb.s2.small\"}"
     * # if use intranet, detail below.
     * # config = "{\"IngressSlbNetworkType\":\"intranet",\"IngressSlbSpec\":\"slb.s2.small\"}"
     * }
     * # install SLB ingress, conflict with nginx ingress
     * addons {
     * name = "alb-ingress-controller"
     * }
     * # install metric server
     * addons {
     * name = "metrics-server"
     * }
     * # install knative
     * addons {
     * name = "knative"
     * }
     * # install prometheus
     * addons {
     * name = "arms-prometheus"
     * # prometheus also provides managed version, specify with name `managed-arms-prometheus` for professional serverless clusters
     * # name = "managed-arms-prometheus"
     * }
     * ```
     */
    @JvmName("wqmnixwioecdggdn")
    public suspend fun disabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabled = mapped
    }

    /**
     * @param value Name of the ACK add-on. The name must match one of the names returned by [DescribeAddons](https://help.aliyun.com/document_detail/171524.html).
     */
    @JvmName("mgvbdalkytdqhdwh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ServerlessKubernetesAddonArgs = ServerlessKubernetesAddonArgs(
        config = config,
        disabled = disabled,
        name = name,
    )
}
