@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.inputs

import com.pulumi.alicloud.cs.inputs.ServerlessKubernetesRrsaMetadataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Whether the RRSA feature has been enabled.
 * @property ramOidcProviderArn The arn of OIDC provider that was registered in RAM.
 * @property ramOidcProviderName The name of OIDC Provider that was registered in RAM.
 * @property rrsaOidcIssuerUrl The issuer URL of RRSA OIDC Token.
 */
public data class ServerlessKubernetesRrsaMetadataArgs(
    public val enabled: Output<Boolean>? = null,
    public val ramOidcProviderArn: Output<String>? = null,
    public val ramOidcProviderName: Output<String>? = null,
    public val rrsaOidcIssuerUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.inputs.ServerlessKubernetesRrsaMetadataArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.inputs.ServerlessKubernetesRrsaMetadataArgs =
        com.pulumi.alicloud.cs.inputs.ServerlessKubernetesRrsaMetadataArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .ramOidcProviderArn(ramOidcProviderArn?.applyValue({ args0 -> args0 }))
            .ramOidcProviderName(ramOidcProviderName?.applyValue({ args0 -> args0 }))
            .rrsaOidcIssuerUrl(rrsaOidcIssuerUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerlessKubernetesRrsaMetadataArgs].
 */
@PulumiTagMarker
public class ServerlessKubernetesRrsaMetadataArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var ramOidcProviderArn: Output<String>? = null

    private var ramOidcProviderName: Output<String>? = null

    private var rrsaOidcIssuerUrl: Output<String>? = null

    /**
     * @param value Whether the RRSA feature has been enabled.
     */
    @JvmName("huqnfuntnalaaoln")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The arn of OIDC provider that was registered in RAM.
     */
    @JvmName("onpnqrsbawctlbxy")
    public suspend fun ramOidcProviderArn(`value`: Output<String>) {
        this.ramOidcProviderArn = value
    }

    /**
     * @param value The name of OIDC Provider that was registered in RAM.
     */
    @JvmName("egetxwssmoclhual")
    public suspend fun ramOidcProviderName(`value`: Output<String>) {
        this.ramOidcProviderName = value
    }

    /**
     * @param value The issuer URL of RRSA OIDC Token.
     */
    @JvmName("nosbophshtnmvlsd")
    public suspend fun rrsaOidcIssuerUrl(`value`: Output<String>) {
        this.rrsaOidcIssuerUrl = value
    }

    /**
     * @param value Whether the RRSA feature has been enabled.
     */
    @JvmName("vbdcmytedaxelhko")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The arn of OIDC provider that was registered in RAM.
     */
    @JvmName("oxlekvesfauumygu")
    public suspend fun ramOidcProviderArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ramOidcProviderArn = mapped
    }

    /**
     * @param value The name of OIDC Provider that was registered in RAM.
     */
    @JvmName("uxhqmesbojsgncmn")
    public suspend fun ramOidcProviderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ramOidcProviderName = mapped
    }

    /**
     * @param value The issuer URL of RRSA OIDC Token.
     */
    @JvmName("vcvwmbcdppwoegwi")
    public suspend fun rrsaOidcIssuerUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rrsaOidcIssuerUrl = mapped
    }

    internal fun build(): ServerlessKubernetesRrsaMetadataArgs = ServerlessKubernetesRrsaMetadataArgs(
        enabled = enabled,
        ramOidcProviderArn = ramOidcProviderArn,
        ramOidcProviderName = ramOidcProviderName,
        rrsaOidcIssuerUrl = rrsaOidcIssuerUrl,
    )
}
