@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property config The ACK add-on configurations. For more config information, see cs_kubernetes_addon_metadata.
 * @property disabled Disables the automatic installation of a component. Default is `false`.
 * The following example is the definition of addons block, The type of this field is list:
 * ```
 * # install nginx ingress, conflict with SLB ingress
 * addons {
 * name = "nginx-ingress-controller"
 * # use internet
 * config = "{\"IngressSlbNetworkType\":\"internet",\"IngressSlbSpec\":\"slb.s2.small\"}"
 * # if use intranet, detail below.
 * # config = "{\"IngressSlbNetworkType\":\"intranet",\"IngressSlbSpec\":\"slb.s2.small\"}"
 * }
 * ```
 * @property name Name of the ACK add-on. The name must match one of the names returned by [DescribeAddons](https://help.aliyun.com/document_detail/171524.html).
 * @property version It specifies the version of the component.
 */
public data class EdgeKubernetesAddon(
    public val config: String? = null,
    public val disabled: Boolean? = null,
    public val name: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.EdgeKubernetesAddon): EdgeKubernetesAddon = EdgeKubernetesAddon(
            config = javaType.config().map({ args0 -> args0 }).orElse(null),
            disabled = javaType.disabled().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
