@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clientCert The path of client certificate, like `~/.kube/client-cert.pem`.
 * @property clientKey The path of client key, like `~/.kube/client-key.pem`.
 * @property clusterCert The base64 encoded cluster certificate data required to communicate with your cluster. Add this to the certificate-authority-data section of the kubeconfig file for your cluster.
 */
public data class EdgeKubernetesCertificateAuthority(
    public val clientCert: String? = null,
    public val clientKey: String? = null,
    public val clusterCert: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.EdgeKubernetesCertificateAuthority): EdgeKubernetesCertificateAuthority = EdgeKubernetesCertificateAuthority(
            clientCert = javaType.clientCert().map({ args0 -> args0 }).orElse(null),
            clientKey = javaType.clientKey().map({ args0 -> args0 }).orElse(null),
            clusterCert = javaType.clusterCert().map({ args0 -> args0 }).orElse(null),
        )
    }
}
