@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property project Log Service project name, cluster logs will output to this project.
 * @property type Type of collecting logs, only `SLS` are supported currently.
 */
public data class EdgeKubernetesLogConfig(
    public val project: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cs.outputs.EdgeKubernetesLogConfig): EdgeKubernetesLogConfig = EdgeKubernetesLogConfig(
            project = javaType.project().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
